/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardItemPrinter;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SectionPrinter
extends WizardItemPrinter {
    private static final Logger logger = Logger.getLogger((Class)SectionPrinter.class);
    private WizardDisplayInfoDTO.SectionItemDTO section;

    protected void initalize(WizardDisplayInfoDTO.AbstractItemDTO item) {
        this.section = (WizardDisplayInfoDTO.SectionItemDTO)item;
    }

    public void print(float xOffset, float yOffset) throws FormRendererException {
        PdfPTable table = new PdfPTable(this.section.getColdefs().size());
        table.setWidthPercentage(100.0f);
        table.setHeaderRows(1);
        table.setSpacingAfter(18.0f);
        try {
            int[] columns = this.getGridArray(this.section.getColdefs());
            table.setWidths(columns);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print section", e);
        }
        Iterator it = this.section.getHeaders().iterator();
        while (it.hasNext()) {
            String translatedText;
            WizardDisplayInfoDTO.HeaderItemDTO header = (WizardDisplayInfoDTO.HeaderItemDTO)it.next();
            String key = header.getName().toString();
            try {
                translatedText = header.getText(this.getLocalizationHelper());
            }
            catch (FormRendererException e) {
                logger.error((Object)("could not retrieve header-addons for header " + key), (Throwable)e);
                translatedText = Messages.getString(key);
            }
            this.addTableHeader(table, translatedText, header.getColspan());
        }
        List rows = this.section.getRows();
        if (rows != null && rows.size() > 0) {
            Iterator it2 = rows.iterator();
            while (it2.hasNext()) {
                WizardDisplayInfoDTO.RowItemDTO rowItemDTO = (WizardDisplayInfoDTO.RowItemDTO)it2.next();
                if (12 == rowItemDTO.getState()) continue;
                this.printRow(table, rowItemDTO);
            }
        }
        try {
            this.getDocument().add((Element)table);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print section", e);
        }
    }

    private void printRow(PdfPTable table, WizardDisplayInfoDTO.RowItemDTO rowItemDTO) throws FormRendererException {
        List cols = rowItemDTO.getCols();
        if (cols != null && cols.size() > 0) {
            Iterator it = cols.iterator();
            while (it.hasNext()) {
                WizardDisplayInfoDTO.AbstractItemDTO element = (WizardDisplayInfoDTO.AbstractItemDTO)it.next();
                if (element instanceof WizardDisplayInfoDTO.LabelItemDTO) {
                    WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)element;
                    this.addTableCell(table, this.getText(labelItemDTO), labelItemDTO.getColspan(), labelItemDTO.getAlign());
                    continue;
                }
                if (element instanceof WizardDisplayInfoDTO.ItemItemDTO) {
                    WizardDisplayInfoDTO.ItemItemDTO itemItemDTO = (WizardDisplayInfoDTO.ItemItemDTO)element;
                    String s = this.getText(itemItemDTO);
                    this.addTableCell(table, s, itemItemDTO.getColspan(), itemItemDTO.getAlign());
                    continue;
                }
                logger.warn((Object)("undefined section child type: " + element.getClass()));
            }
        } else {
            this.addTableCell(table, " ", this.section.getColdefs().size(), "");
        }
    }
}

