/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinterFactory;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TablePrinter
extends ExpertItemPrinter {
    private float top;
    protected ExpertDisplayInfoDTO.TableDTO item;
    protected int rowNo = 0;

    protected void initalize(ExpertDisplayInfoDTO.ItemDTO item) {
        this.item = (ExpertDisplayInfoDTO.TableDTO)item;
        this.rowNo = this.item.getStartRow();
    }

    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        if (this.item.isEnhanced()) {
            this.printEnhancedTable();
        } else {
            this.printStandardTable(xOffset, yOffset);
        }
    }

    protected void printStandardTable(float xOffset, float yOffset) throws FormRendererException {
        boolean hasExtraPagesSumRow = this.hasExtraPagesSumRow();
        int rowsToPrint = this.item.getFormRows();
        if (hasExtraPagesSumRow) {
            --rowsToPrint;
        }
        this.top = this.calcUpperRightY(this.item, yOffset) - (float)this.item.getHeaderHeight();
        List rows = this.item.getPrintRows();
        while (this.rowNo < rows.size() && this.rowNo < rowsToPrint) {
            ExpertDisplayInfoDTO.TableDTO.RowDTO row = (ExpertDisplayInfoDTO.TableDTO.RowDTO)rows.get(this.rowNo);
            this.printRow(xOffset, yOffset, row);
            this.top -= this.item.getRowHeight();
            ++this.rowNo;
        }
        if (hasExtraPagesSumRow) {
            this.printRow(xOffset, yOffset, this.getExtraPagesSumRow());
        }
        this.printAbsoluteExtraPagesSums(xOffset, yOffset);
        if (this.rowNo < rows.size() && this.rowNo < this.item.getEndRow()) {
            this.addExtraItem(new TableAdditionItem(this.item, this.rowNo));
        }
    }

    private void printRow(float xOffset, float yOffset, ExpertDisplayInfoDTO.TableDTO.RowDTO row) throws FormRendererException {
        float left = this.calcLowerLeftX(this.item, xOffset) + 3.0f;
        int colNo = 0;
        Iterator cols = this.item.getAllColumns().iterator();
        while (cols.hasNext()) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)cols.next();
            if (col.getPrintMode() == 8 || col.getPrintMode() == 1) {
                int width = col.getWidth();
                if (colNo < row.getValues().size()) {
                    ExpertDisplayInfoDTO.TableDTO.CellDTO cell = (ExpertDisplayInfoDTO.TableDTO.CellDTO)row.getValues().get(colNo);
                    for (int i = cell.getColspan(); i > 1 && cols.hasNext(); --i) {
                        ExpertDisplayInfoDTO.TableDTO.ColumnDTO spanedCol = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)cols.next();
                        width += spanedCol.getWidth();
                    }
                    float llx = left + this.item.getColSpace() / 2.0f;
                    float lly = this.top - this.item.getRowHeight();
                    float urx = left + (float)width - this.item.getColSpace() / 2.0f;
                    float ury = this.top;
                    ExpertDisplayInfoDTO.FontDTO font = cell.getFont();
                    if (col.getValuePositions() == null || col.getValuePositions().isEmpty()) {
                        String text = this.getText(col, cell);
                        if (col.getAlignment() == 0) {
                            llx += this.getDocumentContext().getValuePaddingX() - this.item.getColSpace() / 2.0f;
                        } else if (col.getAlignment() == 2) {
                            urx -= this.getDocumentContext().getValuePaddingX() - this.item.getColSpace() / 2.0f;
                        }
                        this.printText(text, llx, lly, urx, ury, font, col.getAlignment());
                    } else {
                        ExpertDisplayInfoDTO.ValuePositionDTO pos;
                        ExpertDisplayInfoDTO.TableDTO.ValueCellDTO valueCell = (ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)cell;
                        Object value = null;
                        if (valueCell.getModelItem() != null) {
                            value = valueCell.getModelItem().getValue();
                        }
                        if (value != null && (pos = (ExpertDisplayInfoDTO.ValuePositionDTO)col.getValuePositions().get(value.toString())) != null) {
                            this.printText("X", llx += (float)pos.getX(), lly -= (float)pos.getY(), urx += (float)pos.getX(), ury -= (float)pos.getY(), font, 0);
                        }
                    }
                }
                left += (float)width;
            }
            ++colNo;
        }
    }

    private boolean hasExtraPagesSumRow() {
        if (this.item.getPrintRows().size() <= this.item.getFormRows()) {
            return false;
        }
        boolean printExtraPagesSum = false;
        List columns = this.item.getAllColumns();
        if (columns != null) {
            Iterator it = columns.iterator();
            while (it.hasNext() && !printExtraPagesSum) {
                ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)it.next();
                if (!col.isExtraPagesSum() && col.getExtraPagesSumKey() == null || col.getExtraPagesSumPos() != null) continue;
                printExtraPagesSum = true;
            }
        }
        return printExtraPagesSum;
    }

    private void printAbsoluteExtraPagesSums(float xOffset, float yOffset) throws FormRendererException {
        Map sums = this.getExtraPagesSums();
        List cols = this.item.getAllColumns();
        for (int i = 0; i < cols.size(); ++i) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)cols.get(i);
            String text = null;
            ExpertDisplayInfoDTO.TableDTO.ExtraPagesSumDTO pos = null;
            if (col.getExtraPagesSumKey() != null && col.getExtraPagesSumPos() != null) {
                pos = col.getExtraPagesSumPos();
                try {
                    text = this.getLocalizationHelper().translate(col.getExtraPagesSumKey(), new Object[0]);
                }
                catch (LocalizationHelper.LocalizationHelperException e) {
                    throw new FormRendererException("locaization failed", e);
                }
            } else if (col.isExtraPagesSum() && col.getExtraPagesSumPos() != null) {
                pos = col.getExtraPagesSumPos();
                ModelItemDTO mi = new ModelItemDTO(sums.get(new Integer(i)));
                text = col.getRendererAndInputValidator().getRenderedValueToPrint(mi.getValue(), col.isReadonly(), null, this.getLocalizationHelper());
            }
            if (pos == null || text == null) continue;
            float llx = this.calcLowerLeftX(pos, xOffset);
            float lly = this.calcLowerLeftY(pos, yOffset);
            float urx = this.calcUpperRightX(pos, xOffset);
            float ury = this.calcUpperRightY(pos, yOffset);
            this.printText(text, llx, lly, urx, ury, pos.getFont(), pos.getAlignment());
        }
    }

    private Map getExtraPagesSums() {
        HashMap<Integer, Number> sums = new HashMap<Integer, Number>();
        List cols = this.item.getAllColumns();
        for (int i = 0; i < cols.size(); ++i) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)cols.get(i);
            if (!col.isExtraPagesSum()) continue;
            sums.put(new Integer(i), null);
        }
        List rows = this.item.getPrintRows();
        int start = this.item.getFormRows() + this.item.getStartRow();
        if (this.hasExtraPagesSumRow()) {
            --start;
        }
        for (int i = start; i < rows.size(); ++i) {
            ExpertDisplayInfoDTO.TableDTO.RowDTO row = (ExpertDisplayInfoDTO.TableDTO.RowDTO)rows.get(i);
            List values = row.getValues();
            for (int j = 0; j < values.size(); ++j) {
                Integer col = new Integer(j);
                if (!sums.containsKey(col)) continue;
                ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cell = (ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)values.get(j);
                ModelItemDTO mi = cell.getModelItem();
                Number curr = (Number)sums.get(col);
                Number val = mi == null ? (Number)null : (Number)((Number)mi.getValue());
                sums.put(col, this.add(curr, val));
            }
        }
        return sums;
    }

    private ExpertDisplayInfoDTO.TableDTO.RowDTO getExtraPagesSumRow() {
        Map sums = this.getExtraPagesSums();
        List cols = this.item.getAllColumns();
        ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO> values = new ArrayList<ExpertDisplayInfoDTO.TableDTO.CellDTO>();
        ExpertDisplayInfoDTO.TableDTO.CellDTO cell = null;
        for (int i = 0; i < cols.size(); ++i) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)cols.get(i);
            if (col.getExtraPagesSumPos() != null) {
                if (cell == null) {
                    cell = new ExpertDisplayInfoDTO.TableDTO.ValueCellDTO(null, new ModelItemDTO(), null, 1, null, col.getDefaultCellFont(), null);
                    continue;
                }
                cell.setColspan(cell.getColspan() + 1);
                continue;
            }
            if (col.getExtraPagesSumKey() == null && !col.isExtraPagesSum()) {
                if (cell == null) {
                    cell = new ExpertDisplayInfoDTO.TableDTO.ValueCellDTO(null, new ModelItemDTO(), null, 1, null, col.getDefaultCellFont(), null);
                    continue;
                }
                cell.setColspan(cell.getColspan() + 1);
                continue;
            }
            if (col.getExtraPagesSumKey() != null) {
                if (cell != null) {
                    values.add(cell);
                }
                cell = new ExpertDisplayInfoDTO.TableDTO.LabelCellDTO(col.getExtraPagesSumKey(), null, 1, null, col.getDefaultCellFont());
                if (col.getAlignment() == 0) continue;
                values.add(cell);
                cell = null;
                continue;
            }
            if (!col.isExtraPagesSum()) continue;
            if (cell != null) {
                values.add(cell);
            }
            ModelItemDTO mi = new ModelItemDTO(sums.get(new Integer(i)));
            cell = new ExpertDisplayInfoDTO.TableDTO.ValueCellDTO(null, mi, null, 1, null, col.getDefaultCellFont(), null);
            if (col.getAlignment() == 0) continue;
            values.add(cell);
            cell = null;
        }
        if (cell != null) {
            values.add(cell);
        }
        return new ExpertDisplayInfoDTO.TableDTO.RowDTO(0, values, null, true, false, null, false);
    }

    private Number add(Number a, Number b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof Double || b instanceof Double) {
            return new Double(a.doubleValue() + b.doubleValue());
        }
        return new Long(a.longValue() + b.longValue());
    }

    protected void printEnhancedTable() throws FormRendererException {
        ItemPrinterFactory printerFactory = new ItemPrinterFactory(this.getDocumentContext());
        List rows = this.item.getPrintRows();
        int firstRow = this.rowNo;
        while (this.rowNo < rows.size() && this.rowNo - firstRow < this.item.getFormRows()) {
            ExpertDisplayInfoDTO.TableDTO.RowDTO row = (ExpertDisplayInfoDTO.TableDTO.RowDTO)rows.get(this.rowNo);
            Iterator rowItems = row.getValues().iterator();
            while (rowItems.hasNext()) {
                ExpertDisplayInfoDTO.ItemDTO rowItem = (ExpertDisplayInfoDTO.ItemDTO)rowItems.next();
                ItemPrinter printer = printerFactory.getPrinter(rowItem);
                printer.print(this.item.getX(), (float)(this.item.getY() + this.item.getHeaderHeight()) + (float)(this.rowNo - firstRow) * this.item.getRowHeight());
            }
            ++this.rowNo;
        }
        if (this.rowNo < rows.size() && this.rowNo < this.item.getEndRow()) {
            this.addExtraItem(new TableAdditionItem(this.item, this.rowNo));
        }
    }
}

