/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TablePrinter;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PatternColor;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPatternPainter;
import java.awt.Color;
import java.util.Iterator;

public class TableAdditionPrinter
extends TablePrinter {
    protected void initalize(ExpertDisplayInfoDTO.ItemDTO item) {
        TableAdditionItem tableItem = (TableAdditionItem)item;
        super.initalize(tableItem.getTable());
        this.rowNo = tableItem.getNextRow();
    }

    protected void printStandardTable(float xOffset, float yOffset) throws FormRendererException {
        try {
            int start;
            ExpertDisplayInfoDTO.TableDTO tableDTO = this.item;
            int colCnt = 0;
            Iterator cols = tableDTO.getPrintColumns().iterator();
            while (cols.hasNext()) {
                ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)cols.next();
                if (!this.isPrintColumn(col)) continue;
                ++colCnt;
            }
            Font titleFont = this.itextFont(tableDTO.getTitleFont());
            PdfPTable table = new PdfPTable(colCnt);
            table.setWidthPercentage(100.0f);
            table.setHeaderRows(2);
            table.setSpacingBefore(12.0f);
            Paragraph title = new Paragraph(this.getLocalizationHelper().translate(tableDTO.getTitle(), null), titleFont);
            PdfPCell cellTitle = new PdfPCell((Phrase)title);
            if (tableDTO.getTitlePattern() != null) {
                ExpertDisplayInfoDTO.PatternDTO pattern = tableDTO.getTitlePattern();
                PdfPatternPainter pat = this.getDirectContent().createPattern(pattern.getDistance(), pattern.getDistance(), TableAdditionPrinter.awtColor(pattern.getColor()));
                pat.rectangle(pattern.getSize(), pattern.getSize(), pattern.getSize(), pattern.getSize());
                pat.fill();
                cellTitle.setBackgroundColor((Color)new PatternColor(pat));
            }
            cellTitle.setColspan(colCnt);
            cellTitle.setBorderColor(TableAdditionPrinter.awtColor(tableDTO.getBorderColor()));
            table.addCell(cellTitle);
            float[] colWidths = new float[colCnt];
            int j = 0;
            Iterator cols2 = tableDTO.getPrintColumns().iterator();
            while (cols2.hasNext()) {
                ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)cols2.next();
                if (!this.isPrintColumn(col)) continue;
                Chunk colTitle = new Chunk(this.getLocalizationHelper().translate(col.getTitle(), null));
                colTitle.setFont(this.itextFont(col.getFont()));
                colTitle.setHyphenation(this.getDocumentContext().getHyphenation());
                PdfPCell cell = new PdfPCell(new Phrase(colTitle));
                cell.setBorderColor(TableAdditionPrinter.awtColor(tableDTO.getBorderColor()));
                cell.setHorizontalAlignment(col.getAlignment());
                table.addCell(cell);
                colWidths[j++] = (float)col.getWidth() / (float)tableDTO.getWidth();
            }
            table.setWidths(colWidths);
            for (int i = start = this.rowNo; i < tableDTO.getPrintRows().size(); ++i) {
                ExpertDisplayInfoDTO.TableDTO.RowDTO row = (ExpertDisplayInfoDTO.TableDTO.RowDTO)tableDTO.getPrintRows().get(i);
                int colNo = 0;
                Iterator cols3 = tableDTO.getPrintColumns().iterator();
                while (cols3.hasNext()) {
                    ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)cols3.next();
                    if (this.isPrintColumn(col) && colNo < row.getValues().size()) {
                        ExpertDisplayInfoDTO.TableDTO.CellDTO cell = (ExpertDisplayInfoDTO.TableDTO.CellDTO)row.getValues().get(colNo);
                        Chunk ck = new Chunk(this.getText(col, cell));
                        ck.setFont(this.itextFont(cell.getFont()));
                        PdfPCell pdfCell = new PdfPCell(new Phrase(ck));
                        pdfCell.setBorderColor(TableAdditionPrinter.awtColor(tableDTO.getBorderColor()));
                        pdfCell.setPaddingTop(tableDTO.getExtraPagesRowPadding());
                        pdfCell.setHorizontalAlignment(TableAdditionPrinter.itextAlignment(col.getAlignment()));
                        table.addCell(pdfCell);
                    }
                    ++colNo;
                }
            }
            this.getDocumentContext().getDocument().add((Element)table);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new FormRendererException("can't print additional table", e);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print additional table", e);
        }
    }

    private boolean isPrintColumn(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col) {
        return col.getPrintMode() != 1 && col.getPrintMode() != 0;
    }
}

