/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ImagePrinter
extends ExpertItemPrinter {
    private static final Logger log = Logger.getLogger((Class)ImagePrinter.class);
    private ExpertDisplayInfoDTO.ImageDTO item;
    private HashMap readerCache = new HashMap();
    private HashMap imageCache = new HashMap();

    protected void initalize(ExpertDisplayInfoDTO.ItemDTO item) {
        this.item = (ExpertDisplayInfoDTO.ImageDTO)item;
    }

    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        if (this.item.getFileName() == null) {
            log.debug((Object)"Skipping image because the file name is empty");
            return;
        }
        try {
            if (this.item.getFileName().toLowerCase().endsWith("pdf")) {
                if (this.item.getPage() > 0) {
                    PdfWriter writer = this.getDocumentContext().getWriter();
                    PdfContentByte cb = writer.getDirectContentUnder();
                    PdfImportedPage page = writer.getImportedPage(this.getReader(), this.item.getPage());
                    if (this.item.getWidth() > this.item.getHeight() && page.getWidth() < page.getHeight()) {
                        cb.addTemplate((PdfTemplate)page, 0.0f, -1.0f, 1.0f, 0.0f, (float)this.item.getX() + xOffset, (float)this.item.getY() + yOffset + page.getWidth());
                    } else {
                        cb.addTemplate((PdfTemplate)page, (float)this.item.getX() + xOffset, (float)this.item.getY() + yOffset);
                    }
                }
            } else {
                Image image = this.getImage();
                image.setAbsolutePosition(this.calcLowerLeftX(this.item, xOffset), this.calcLowerLeftY(this.item, yOffset));
                image.scaleAbsolute((float)this.item.getWidth(), (float)this.item.getHeight());
                this.getDirectContent().addImage(image);
            }
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't add image to document", e);
        }
        catch (IOException e) {
            throw new FormRendererException("can't open image", e);
        }
    }

    private Image getImage() throws IOException, BadElementException {
        Image image = (Image)this.imageCache.get(this.item.getFileName());
        if (image == null) {
            image = Image.getInstance((byte[])this.getImageData());
            this.imageCache.put(this.item.getFileName(), image);
        }
        return image;
    }

    private byte[] getImageData() throws IOException {
        ImageSource imgSource = this.getDocumentContext().getImageSource();
        return imgSource.getImage(this.item.getFileName());
    }

    private PdfReader getReader() throws IOException {
        PdfReader reader = (PdfReader)this.readerCache.get(this.item.getFileName());
        if (reader == null) {
            reader = new PdfReader(this.getImageData());
            this.readerCache.put(this.item.getFileName(), reader);
        }
        return reader;
    }
}

