/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Barcode2DAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BarcodePDF417;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;

public class Barcode2DPrinter
extends ExpertItemPrinter {
    private ExpertDisplayInfoDTO.Barcode2DContainerDTO item;
    private BarcodePDF417 barcode = new BarcodePDF417();
    private byte currentSymbol;
    private byte numberOfSymbols;

    protected void initalize(ExpertDisplayInfoDTO.ItemDTO newItem) {
        if (newItem instanceof Barcode2DAdditionItem) {
            Barcode2DAdditionItem addItem = (Barcode2DAdditionItem)newItem;
            this.item = addItem.getBarcodeContainer();
            this.numberOfSymbols = addItem.getNumberOfSymbols();
            this.currentSymbol = addItem.getCurrentSymbol();
        } else {
            this.currentSymbol = 0;
            this.item = (ExpertDisplayInfoDTO.Barcode2DContainerDTO)newItem;
            this.numberOfSymbols = (byte)Math.ceil((float)this.item.getData().length / (float)this.item.getLength());
            int pages = (int)Math.ceil((float)this.numberOfSymbols / (float)this.item.getBarcodes().size());
            this.getDocumentContext().setFormPages(pages);
        }
        this.barcode.setDefaultParameters();
        if (this.item.getErrorCorrection() > 8) {
            this.barcode.setErrorLevel(8);
        } else {
            this.barcode.setErrorLevel(this.item.getErrorCorrection());
        }
        this.barcode.setAspectRatio(this.item.getAspectRatio());
        this.barcode.setYHeight((float)this.item.getRowHeight());
        if (this.item.getColumns() > 0) {
            this.barcode.setCodeColumns(this.item.getColumns());
        }
        if (this.item.getRows() > 0) {
            this.barcode.setCodeRows(this.item.getRows());
        }
        int options = 48;
        options = this.item.getRows() > 0 && this.item.getColumns() > 0 ? (options |= 1) : (this.item.getRows() > 0 ? (options |= 4) : (this.item.getColumns() > 0 ? (options |= 2) : (options |= 0)));
        if (this.item.getType() == 1) {
            options |= 0x100;
        }
        this.barcode.setOptions(options);
    }

    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        Iterator it = this.item.getBarcodes().iterator();
        while (it.hasNext() && this.currentSymbol < this.numberOfSymbols) {
            ExpertDisplayInfoDTO.Barcode2DDTO bc = (ExpertDisplayInfoDTO.Barcode2DDTO)it.next();
            this.printBarcode(bc, xOffset, yOffset);
            this.currentSymbol = (byte)(this.currentSymbol + 1);
        }
        if (this.currentSymbol < this.numberOfSymbols) {
            Barcode2DAdditionItem addItem = new Barcode2DAdditionItem(this.item, this.currentSymbol, this.numberOfSymbols);
            this.addExtraItem(addItem);
        }
    }

    private void printBarcode(ExpertDisplayInfoDTO.Barcode2DDTO bc, float xOffset, float yOffset) throws FormRendererException {
        if (this.item.getType() == 1) {
            BigInteger id = new BigInteger(this.item.getId());
            this.barcode.setMacroFileId(id.toString());
            this.barcode.setMacroSegmentCount((int)this.numberOfSymbols);
            this.barcode.setMacroSegmentId((int)this.currentSymbol);
        }
        this.barcode.setText(this.getData());
        try {
            Image awtImage = this.barcode.createAwtImage(Color.BLACK, Color.WHITE);
            awtImage = awtImage.getScaledInstance(awtImage.getWidth(null) * 2, awtImage.getHeight(null) * 2, 4);
            com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((Image)awtImage, null);
            image.scalePercent(50.0f, 50.0f);
            float lly = this.getPageSize().getHeight() - image.getScaledHeight() - (float)this.item.getY();
            image.setAbsolutePosition((float)this.item.getX() + xOffset + (float)bc.getX(), lly + yOffset - (float)bc.getY());
            this.getDirectContent().addImage(image);
        }
        catch (IOException e) {
            throw new FormRendererException("can't add barcode image to document", e);
        }
        catch (BadElementException e) {
            throw new FormRendererException("can't add barcode image to document", e);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't add barcode image to document", e);
        }
    }

    private byte[] getData() {
        byte[] data;
        int start = this.currentSymbol * this.item.getLength();
        int len = Math.min(this.item.getData().length - start, this.item.getLength());
        if (this.item.getType() == 2) {
            data = new byte[len + 10];
            System.arraycopy(this.item.getId(), 0, data, 0, 4);
            data[4] = this.item.getContentType();
            Barcode2DPrinter.append(data, len, 5, 3);
            data[8] = (byte)(this.currentSymbol + 1);
            data[9] = this.numberOfSymbols;
            System.arraycopy(this.item.getData(), start, data, 10, len);
        } else {
            data = new byte[len];
            System.arraycopy(this.item.getData(), start, data, 0, len);
        }
        return data;
    }

    private static void append(byte[] dest, int v, int offset, int len) {
        int i = 0;
        int shift = 8 * (len - 1);
        while (i < len) {
            dest[offset + i] = (byte)(0xFF & v >> shift);
            ++i;
            shift -= 8;
        }
    }
}

