/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.Barcode39;

public class Barcode1DPrinter
extends ExpertItemPrinter {
    private ExpertDisplayInfoDTO.Barcode1DDTO item;

    protected void initalize(ExpertDisplayInfoDTO.ItemDTO item) {
        this.item = (ExpertDisplayInfoDTO.Barcode1DDTO)item;
    }

    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        Barcode39 bc;
        switch (this.item.getType()) {
            case 1: {
                bc = new Barcode39();
                break;
            }
            case 2: {
                bc = new Barcode128();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid barcode 1D type: " + this.item.getType());
            }
        }
        bc.setStartStopText(false);
        String data = this.item.getData();
        DocumentContext ctx = this.getDocumentContext();
        data = data.replaceAll("@formpage@", Integer.toString(ctx.getFormPage()));
        data = data.replaceAll("@extrapage@", Integer.toString(ctx.getFormPage() - 1));
        bc.setCode(data);
        if (this.item.getBarHeight() >= 0) {
            bc.setBarHeight((float)this.item.getBarHeight());
        }
        if (this.item.getMinBarWidth() >= 0.0f) {
            bc.setX(this.item.getMinBarWidth());
        }
        if (this.item.getRelBarWidth() >= 0.0f) {
            bc.setN(this.item.getRelBarWidth());
        }
        if (this.item.getTextSize() >= 0) {
            bc.setSize((float)this.item.getTextSize());
        }
        Image image = bc.createImageWithBarcode(this.getDirectContent(), null, null);
        image.setAbsolutePosition((float)this.item.getX(), this.getPageSize().getHeight() - image.getHeight() - (float)this.item.getY());
        try {
            this.getDirectContent().addImage(image);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't add barcode image to document", e);
        }
    }
}

