/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer;

import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Barcode1DPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Barcode2DAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Barcode2DPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ImagePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ListAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ListAdditionPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ListPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.RectanglePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TablePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Template;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TemplatePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TextPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.BrPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.ButtonPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.LabelPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.SectionPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardTablePrinter;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.HashMap;
import java.util.Map;

public class ItemPrinterFactory {
    private DocumentContext ctx;
    private Map printers = new HashMap();

    public ItemPrinterFactory(DocumentContext ctx) {
        this.ctx = ctx;
        this.printers.put(ExpertDisplayInfoDTO.Barcode1DDTO.class, new Barcode1DPrinter());
        this.printers.put(ExpertDisplayInfoDTO.ImageDTO.class, new ImagePrinter());
        this.printers.put(ExpertDisplayInfoDTO.ValueItemDTO.class, new TextPrinter());
        this.printers.put(ExpertDisplayInfoDTO.LabelDTO.class, new TextPrinter());
        this.printers.put(ExpertDisplayInfoDTO.TableDTO.class, new TablePrinter());
        this.printers.put(TableAdditionItem.class, new TableAdditionPrinter());
        this.printers.put(ExpertDisplayInfoDTO.Barcode2DContainerDTO.class, new Barcode2DPrinter());
        this.printers.put(Barcode2DAdditionItem.class, new Barcode2DPrinter());
        this.printers.put(ExpertDisplayInfoDTO.RectangleDTO.class, new RectanglePrinter());
        this.printers.put(ExpertDisplayInfoDTO.ListDTO.class, new ListPrinter());
        this.printers.put(ListAdditionItem.class, new ListAdditionPrinter());
        this.printers.put(Template.class, new TemplatePrinter());
        this.printers.put(WizardDisplayInfoDTO.BRItemDTO.class, new BrPrinter());
        this.printers.put(WizardDisplayInfoDTO.ButtonDTO.class, new ButtonPrinter());
        this.printers.put(WizardDisplayInfoDTO.LabelItemDTO.class, new LabelPrinter());
        this.printers.put(WizardDisplayInfoDTO.SectionItemDTO.class, new SectionPrinter());
        this.printers.put(WizardDisplayInfoDTO.TableItemDTO.class, new WizardTablePrinter());
    }

    public ItemPrinter getPrinter(ExpertDisplayInfoDTO.ItemDTO item) {
        ExpertItemPrinter printer = (ExpertItemPrinter)this.findPrinter(item);
        printer.initalize(this.ctx, item);
        return printer;
    }

    public ItemPrinter getPrinter(WizardDisplayInfoDTO.AbstractItemDTO item) {
        WizardItemPrinter printer = (WizardItemPrinter)this.findPrinter(item);
        printer.initalize(this.ctx, item);
        return printer;
    }

    private Object findPrinter(Object item) {
        Object printer = this.printers.get(item.getClass());
        if (printer != null) {
            return printer;
        }
        throw new IllegalArgumentException("no ItemPrinter available for item class: " + item);
    }
}

