/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf;

import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinterFactory;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Template;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.common.transfer.util.LabelAddOnHelper;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PdfFormRenderer
extends FormRenderer {
    private static final int WATERMARK_SIZE = 32;
    private Document document;
    private PdfWriter writer;
    private ItemPrinterFactory printerFactory;
    private DocumentContext ctx;
    private String watermark;

    public PdfFormRenderer(LocalizationHelper locHelper, ImageSource imgSource) {
        super(locHelper, imgSource);
    }

    public void render(List forms, OutputStream os, String wm) throws FormRendererException {
        try {
            this.document = new Document();
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            this.writer.setCloseStream(false);
            this.ctx = new DocumentContext(this.document, this.writer, this.getLocalizationHelper(), this.getImageSource());
            this.ctx.setUseBoldFonts(this.isUseBoldFonts());
            this.printerFactory = new ItemPrinterFactory(this.ctx);
            int i = 0;
            Iterator it = forms.iterator();
            while (it.hasNext()) {
                Object form = it.next();
                if (form instanceof ExpertDisplayInfoDTO) {
                    this.watermark = wm;
                    this.render((ExpertDisplayInfoDTO)form);
                } else if (form instanceof WizardDisplayInfoDTO) {
                    this.watermark = null;
                    if (this.getWizardBackground() != null) {
                        this.render(this.getWizardBackground());
                    }
                    this.render((WizardDisplayInfoDTO)form);
                } else {
                    throw new FormRendererException("Invalid form type: " + form.getClass());
                }
                this.notifyProgressListeners(i);
                ++i;
            }
            it = this.ctx.getTemplates().iterator();
            while (it.hasNext()) {
                Template templ = (Template)it.next();
                this.printerFactory.getPrinter(templ).print();
            }
            this.document.close();
            this.writer.close();
        }
        catch (DocumentException e) {
            throw new FormRendererException("pdf printing failed", e);
        }
    }

    private void render(final ExpertDisplayInfoDTO form) throws DocumentException, FormRendererException {
        ExpertDisplayInfoDTO.PageSettingsDTO page = form.getPageSize();
        this.document.setPageSize(new Rectangle((float)page.getWidth(), (float)page.getHeight()));
        this.document.setMargins(page.getMarginLeft() > 0 ? (float)page.getMarginLeft() : this.document.leftMargin(), page.getMarginRight() > 0 ? (float)page.getMarginRight() : this.document.rightMargin(), page.getMarginTop() > 0 ? (float)page.getMarginTop() : this.document.topMargin(), page.getMarginBottom() > 0 ? (float)page.getMarginBottom() : this.document.bottomMargin());
        this.ctx.setValuePaddingX(form.getValuePrintPaddingX());
        this.writer.setPageEvent(null);
        if (!this.document.isOpen()) {
            this.document.open();
        } else {
            this.document.newPage();
        }
        this.ctx.setFormPage(1);
        this.ctx.setFormPages(1);
        this.ctx.setPageSettings(page);
        this.printWatermark();
        ExpertDisplayInfoDTO.ImageDTO image = form.getPrintBackground();
        if (image != null) {
            this.printerFactory.getPrinter(image).print();
        }
        final List items = form.getItems();
        this.printItems(items, 9);
        this.writer.setPageEvent((PdfPageEvent)new PdfPageEventHelper(){

            public void onStartPage(PdfWriter w, Document doc) {
                try {
                    PdfFormRenderer.this.ctx.setFormPage(PdfFormRenderer.this.ctx.getFormPage() + 1);
                    PdfFormRenderer.this.printWatermark();
                    ExpertDisplayInfoDTO.ImageDTO image = form.getExtraPagesBackground();
                    if (image != null) {
                        PdfFormRenderer.this.printerFactory.getPrinter(image).print();
                    }
                    PdfFormRenderer.this.printItems(items, 12);
                }
                catch (FormRendererException e) {
                    throw new RuntimeException("can't print page header", e);
                }
            }

            public void onEndPage(PdfWriter w, Document doc) {
            }
        });
        while (!this.ctx.getExtraItems().isEmpty()) {
            this.document.newPage();
            ArrayList toPrint = new ArrayList();
            toPrint.addAll(this.ctx.getExtraItems());
            this.ctx.getExtraItems().clear();
            this.printItems(toPrint, -1);
        }
        this.printItems(form.getItems(), 2);
    }

    private void render(WizardDisplayInfoDTO form) throws DocumentException, FormRendererException {
        WizardDisplayInfoDTO.FormItemDTO formItem = form.getFormItemDTO();
        this.printTitle(formItem);
        List items = formItem.getChildren();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            WizardDisplayInfoDTO.AbstractItemDTO item = (WizardDisplayInfoDTO.AbstractItemDTO)it.next();
            ItemPrinter printer = this.printerFactory.getPrinter(item);
            printer.print(0.0f, 0.0f);
        }
    }

    private void printTitle(WizardDisplayInfoDTO.FormItemDTO formItem) throws DocumentException, FormRendererException {
        try {
            String titleKey = formItem.getHeader();
            if (titleKey != null) {
                Object[] args = LabelAddOnHelper.getReplacements(formItem.getLabelAddOns(), this.getLocalizationHelper());
                String title = this.getLocalizationHelper().translate(titleKey, args);
                BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
                Font f = new Font(bf, 14.0f, 1);
                Paragraph p = new Paragraph(title, f);
                PdfPCell cell = new PdfPCell((Phrase)p);
                cell.setPaddingBottom(5.0f);
                cell.setBackgroundColor(Color.LIGHT_GRAY);
                PdfPTable table = new PdfPTable(1);
                table.setWidthPercentage(100.0f);
                table.addCell(cell);
                table.setSpacingAfter(12.0f);
                this.document.add((Element)table);
            }
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new FormRendererException("can't translate title", e);
        }
        catch (IOException e) {
            throw new FormRendererException("title printing failed", e);
        }
    }

    private void printItems(Collection items, int mode) throws FormRendererException {
        Iterator it = items.iterator();
        while (it.hasNext()) {
            ExpertDisplayInfoDTO.ItemDTO item = (ExpertDisplayInfoDTO.ItemDTO)it.next();
            if (mode >= 0 && (item.getPrintMode() & mode) == 0) continue;
            ItemPrinter printer = this.printerFactory.getPrinter(item);
            printer.print(0.0f, 0.0f);
        }
    }

    private void printWatermark() throws FormRendererException {
        if (this.watermark == null || this.watermark.length() < 1) {
            return;
        }
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            PdfContentByte content = this.writer.getDirectContentUnder();
            content.setGrayFill(0.7f);
            content.beginText();
            content.setFontAndSize(bf, 32.0f);
            Rectangle pageSize = this.document.getPageSize();
            content.showTextAligned(1, this.watermark, pageSize.getWidth() / 2.0f, pageSize.getHeight() / 2.0f, 45.0f);
            content.endText();
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print watermark", e);
        }
        catch (IOException e) {
            throw new FormRendererException("can't print watermark", e);
        }
    }
}

