/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Template;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.HyphenationAuto;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.Collection;

public class DocumentContext {
    private Document document;
    private PdfWriter writer;
    private LocalizationHelper locHelper;
    private ImageSource imgSource;
    private Collection extraItems;
    private int formPage;
    private int formPages;
    private HyphenationAuto hypenation;
    private Collection templates;
    private boolean useBoldFonts;
    private ExpertDisplayInfoDTO.PageSettingsDTO pageSettings;
    private float valuePaddingHorizontal;

    public DocumentContext(Document document, PdfWriter writer, LocalizationHelper locHelper, ImageSource imgSource) {
        this.document = document;
        this.writer = writer;
        this.locHelper = locHelper;
        this.imgSource = imgSource;
        this.extraItems = new ArrayList();
        this.templates = new ArrayList();
        try {
            String lang = locHelper.getCurrentLocale().getLanguage();
            this.hypenation = new HyphenationAuto(lang, null, 2, 2);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new RuntimeException("hyphenation initialization failed", e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public LocalizationHelper getLocalizationHelper() {
        return this.locHelper;
    }

    public ImageSource getImageSource() {
        return this.imgSource;
    }

    public Collection getExtraItems() {
        return this.extraItems;
    }

    public void addExtraItem(ExpertDisplayInfoDTO.ItemDTO item) {
        if (item == null) {
            throw new NullPointerException("item must not be null");
        }
        this.extraItems.add(item);
    }

    public int getFormPage() {
        return this.formPage;
    }

    public void setFormPage(int formPage) {
        this.formPage = formPage;
    }

    public int getFormPages() {
        return this.formPages;
    }

    public void setFormPages(int formPages) {
        this.formPages = formPages;
    }

    public HyphenationEvent getHyphenation() {
        return this.hypenation;
    }

    public Collection getTemplates() {
        return this.templates;
    }

    public void addTemplate(Template temp) {
        this.templates.add(temp);
    }

    public void setUseBoldFonts(boolean useBoldFonts) {
        this.useBoldFonts = useBoldFonts;
    }

    public boolean isUseBoldFonts() {
        return this.useBoldFonts;
    }

    public void setValuePaddingX(float valuePaddingX) {
        this.valuePaddingHorizontal = valuePaddingX;
    }

    public float getValuePaddingX() {
        return this.valuePaddingHorizontal;
    }

    public void setPageSettings(ExpertDisplayInfoDTO.PageSettingsDTO pageSettings) {
        this.pageSettings = pageSettings;
    }

    public ExpertDisplayInfoDTO.PageSettingsDTO getPageSettings() {
        return this.pageSettings;
    }
}

