/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.html;

import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.FormRendererUtil;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import com.lowagie.text.DocumentException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;

public class HtmlFormRenderer
extends FormRenderer {
    private PrintWriter out;

    public HtmlFormRenderer(LocalizationHelper locHelper, ImageSource imgSrc) {
        super(locHelper, imgSrc);
    }

    public void render(ExpertDisplayModelItem form, OutputStream os, String watermark) {
    }

    protected void handleItem(ExpertDisplayInfoDTO.ImageDTO item) throws DocumentException, IOException {
        this.out.print("<div style=\"");
        this.out.print("position:absolute; ");
        this.out.print("left:" + item.getX() + "px; ");
        this.out.print("top:" + item.getY() + "px; ");
        this.out.print("width:" + item.getWidth() + "px; ");
        this.out.print("border-style:double;");
        this.out.println("\">");
        this.out.println("<img src=\"" + item.getFileName() + "\" width=\"" + item.getWidth() + "\" height=\"" + item.getHeight() + "\"");
        this.out.println("</div>");
    }

    protected void handleItem(ExpertDisplayInfoDTO.TextItemDTO item) throws DocumentException, IOException {
        this.out.print("<div style=\"");
        this.out.print("position:absolute; ");
        this.out.print("left:" + item.getX() + "px; ");
        this.out.print("top:" + item.getY() + "px; ");
        this.out.print("width:" + item.getWidth() + "px; ");
        this.out.print("background-color:" + item.getBgColor().toString() + "; ");
        this.out.print("border-bottom-style:none; ");
        this.out.print("padding:5px; ");
        this.out.print("text-align:left;");
        this.out.println("\">");
        this.out.print("<span style=\"font-family:'" + item.getFont().getName() + "'; font-size:'" + item.getFont().getSize() + "px'\">");
        this.out.print(FormRendererUtil.getText(item, this.getLocalizationHelper()));
        this.out.println("</span>");
        this.out.println("</div>");
    }

    public void render(List forms, OutputStream os, String watermark) {
    }
}

