/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;

public class FormRendererUtil {
    private static String applicationVersion;

    public static String getText(ExpertDisplayInfoDTO.TextItemDTO item, LocalizationHelper locHelper) {
        if (item instanceof ExpertDisplayInfoDTO.LabelDTO) {
            return FormRendererUtil.getText((ExpertDisplayInfoDTO.LabelDTO)item, locHelper);
        }
        if (item instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
            return FormRendererUtil.getText((ExpertDisplayInfoDTO.ValueItemDTO)item, locHelper);
        }
        throw new IllegalArgumentException("don't know what to do with " + item);
    }

    private static String getText(ExpertDisplayInfoDTO.LabelDTO label, LocalizationHelper locHelper) {
        return label.getText(locHelper);
    }

    private static String getText(ExpertDisplayInfoDTO.ValueItemDTO item, LocalizationHelper locHelper) {
        AbstractConverter converter = item.getRendererAndInputValidator();
        Object value = null;
        if (item.getModelItem() != null && item.getModelItem().getState() != 12) {
            value = item.getModelItem().getValue();
        }
        return converter.getRenderedValueToPrint(value, item.isReadonly(), item.getOptionItems(), locHelper);
    }

    public static String getText(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, ExpertDisplayInfoDTO.TableDTO.CellDTO cell, LocalizationHelper locHelper) {
        if (cell instanceof ExpertDisplayInfoDTO.TableDTO.ValueCellDTO) {
            ExpertDisplayInfoDTO.TableDTO.ValueCellDTO valueCell = (ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)cell;
            Object value = null;
            if (valueCell.getModelItem() != null) {
                value = valueCell.getModelItem().getValue();
            }
            return col.getRendererAndInputValidator().getRenderedValueToPrint(value, col.isReadonly(), valueCell.getOptionItems(), locHelper);
        }
        if (cell instanceof ExpertDisplayInfoDTO.TableDTO.LabelCellDTO) {
            ExpertDisplayInfoDTO.TableDTO.LabelCellDTO labelCell = (ExpertDisplayInfoDTO.TableDTO.LabelCellDTO)cell;
            return labelCell.getText(locHelper);
        }
        return "";
    }

    public static String getText(ExpertDisplayInfoDTO.ListDTO.RowDTO row, LocalizationHelper locHelper) {
        if (row instanceof ExpertDisplayInfoDTO.ListDTO.LabelRowDTO) {
            return FormRendererUtil.getText((ExpertDisplayInfoDTO.ListDTO.LabelRowDTO)row, locHelper);
        }
        if (row instanceof ExpertDisplayInfoDTO.ListDTO.ValueRowDTO) {
            return FormRendererUtil.getText((ExpertDisplayInfoDTO.ListDTO.ValueRowDTO)row, locHelper);
        }
        throw new IllegalArgumentException("don't know what to do with " + row);
    }

    private static String getText(ExpertDisplayInfoDTO.ListDTO.LabelRowDTO item, LocalizationHelper locHelper) {
        return item.getText(locHelper);
    }

    private static String getText(ExpertDisplayInfoDTO.ListDTO.ValueRowDTO item, LocalizationHelper locHelper) {
        AbstractConverter converter = item.getConverter();
        Object value = null;
        if (item.getModelItem() != null && item.getModelItem().getState() != 11) {
            value = item.getModelItem().getValue();
        }
        return converter.getRenderedValueToPrint(value, true, item.getOptionItems(), locHelper);
    }

    public static String getApplicationVersion() {
        return applicationVersion == null ? "" : applicationVersion;
    }

    public static void setApplicationVersion(String applicationVersion) {
        FormRendererUtil.applicationVersion = applicationVersion;
    }
}

