/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.bd.TmoSession;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.Importer;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class TaxFileImporter
implements Importer {
    private ImportContext ctx;
    private Properties importSettings;
    private Map oldDataModel;

    public TaxFileImporter(ImportContext ctx) {
        this.ctx = ctx;
        this.importSettings = ctx.getConfig().getImportSettings();
    }

    public final void doImport(String password) throws InvalidAuthenticationException, ImportException, IOException {
        this.oldDataModel = TaxFileUtil.read(this.ctx.getInputStream(), password);
        this.importOldModelItems();
    }

    protected void importOldModelItems() throws ImportException {
        Iterator it = this.oldDataModel.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry elem = it.next();
            this.importOldModelItem((String)elem.getKey(), (ModelItemDTO)elem.getValue());
        }
    }

    protected void importOldModelItem(String key, ModelItemDTO valueOld) throws ImportException {
        String newKey = this.convertKey(key);
        ModelItemDTO value = valueOld.cloneUntouched();
        if (newKey != null && (this.getTmoSession().isImportable(newKey) || this.getTmoSession().isImportable(key)) && value != null && value.getValue() != null) {
            this.storeInNewModel(newKey, value);
        }
    }

    protected String convertKey(String oldKey) throws ImportException {
        String strippedKey = EngineUtil.removeTableIndices(oldKey);
        String newKey = this.importSettings.getProperty(strippedKey);
        if (newKey == null || newKey.equals(strippedKey)) {
            return oldKey;
        }
        if (strippedKey.equals(oldKey)) {
            return newKey;
        }
        return EngineUtil.mergeModelKey(newKey, oldKey);
    }

    protected void storeInNewModel(String key, ModelItemDTO value) throws ImportException {
        this.getNewDataModel().put(key, value);
    }

    protected TmoSession getTmoSession() {
        return this.ctx.getSession();
    }

    protected Map getNewDataModel() {
        return this.ctx.getDataModel();
    }

    protected Map getOldDataModel() {
        return this.oldDataModel;
    }

    protected Properties getImportSettings() {
        return this.importSettings;
    }

    protected ImportContext getImportContext() {
        return this.ctx;
    }
}

