/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.presentation.bd.TmoSession;
import ch.dvbern.tax.common.presentation.common.imports.ImportConfig;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.Importer;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ImportUtil {
    private static ImportConfig config;

    private ImportUtil() {
    }

    public static void setConfig(ImportConfig importConfig) {
        config = importConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doImport(InputStream in, TmoSession session, String password) throws InvalidAuthenticationException, ImportException, IOException {
        try {
            Map newValues = ImportUtil.doInternalImport(in, session, password);
            session.importData(newValues, false);
            session.recalculate();
        }
        finally {
            in.close();
        }
    }

    private static Map doInternalImport(InputStream in, TmoSession session, String password) throws InvalidAuthenticationException, ImportException, IOException {
        ImportContext ctx = new ImportContext(new HashMap(), in, config, session);
        Importer importer = ImportUtil.createMainImporter(ctx);
        importer.doImport(password);
        return ctx.getDataModel();
    }

    private static Importer createMainImporter(ImportContext ctx) {
        try {
            Class clazz = config.getMainImporter();
            Constructor con = clazz.getConstructor(ctx.getClass());
            Object obj = con.newInstance(ctx);
            return (Importer)obj;
        }
        catch (Exception e) {
            throw new RuntimeException("can't instantiate the main importer", e);
        }
    }
}

