/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.presentation.common.imports.Importer;
import java.util.Properties;

public class ImportConfig {
    private Class mainImporter;
    private Properties importSettings;

    public ImportConfig(Properties config, Properties importSettings) {
        this.importSettings = importSettings;
        try {
            Class<?> clazz;
            String clazzName = config.getProperty("mainImporter");
            if (clazzName == null) {
                throw new RuntimeException("mainImporter is not set in the import configuration");
            }
            if (!Importer.class.isAssignableFrom(clazz = Class.forName(clazzName))) {
                throw new RuntimeException("mainImporter is not a subclass of AbstractImporter");
            }
            this.mainImporter = clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("mainImporter is not a valid class");
        }
    }

    public Class getMainImporter() {
        return this.mainImporter;
    }

    public Properties getImportSettings() {
        return this.importSettings;
    }
}

