/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.wizard;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.parts.HelpPart;
import ch.dvbern.tax.common.presentation.cd.parts.MessagePart;
import ch.dvbern.tax.common.presentation.cd.parts.TabPart;
import ch.dvbern.tax.common.presentation.cd.parts.TranslationPart;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.Collection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class WizardTabPart
extends TabPart {
    public static final int TAB_HELP = 0;
    public static final int TAB_MSG = 1;
    public static final int TAB_TRANSLATION = 2;
    private final TabFolder tabFolder;
    private final HelpPart helpPart;
    private final MessagePart msgPart;
    private final TranslationPart translationPart;

    public WizardTabPart(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder((Composite)this, 0);
        this.tabFolder.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        this.helpPart = new HelpPart((Composite)this.tabFolder);
        TabItem itemHelp = new TabItem(this.tabFolder, 0);
        itemHelp.setData((Object)"label.tab.help");
        itemHelp.setText(Messages.getString("label.tab.help"));
        itemHelp.setControl((Control)this.helpPart);
        this.msgPart = new MessagePart((Composite)this.tabFolder);
        TabItem itemMsg = new TabItem(this.tabFolder, 0);
        itemMsg.setData((Object)"label.tab.msg");
        itemMsg.setText(Messages.getString("label.tab.msg"));
        itemMsg.setControl((Control)this.msgPart);
        if (this.toolsEnabled) {
            this.translationPart = new TranslationPart((Composite)this.tabFolder);
            TabItem itemTranslation = new TabItem(this.tabFolder, 0);
            itemTranslation.setData((Object)"label.tab.translation");
            itemTranslation.setText(Messages.getString("label.tab.translation"));
            itemTranslation.setControl((Control)this.translationPart);
        } else {
            this.translationPart = null;
        }
    }

    public void setSelection(int tabNr) {
        if (tabNr >= 0 && tabNr < this.tabFolder.getItemCount() && tabNr != this.tabFolder.getSelectionIndex()) {
            this.tabFolder.setSelection(tabNr);
        }
    }

    public void setContent(WizardDisplayInfoDTO.FormItemDTO dto) {
        if (dto == null) {
            return;
        }
        WizardDisplayInfoDTO.collectMessagesOnWizardDisplayForm(dto);
        Collection msgs = dto.getMessages();
        this.msgPart.setContent(dto.getMessages());
        this.setFormShortHelpKey(dto.getName());
        if (this.toolsEnabled) {
            this.translationPart.setContent(TranslationManager.getInstance().getTranslationMap());
        }
        if (this.tabFolder.getSelectionIndex() != 2) {
            if (msgs != null && msgs.size() > 0) {
                this.setSelection(1);
            } else {
                this.setSelection(0);
            }
        }
    }

    public HelpPart getHelpPart() {
        return this.helpPart;
    }
}

