/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;

public final class BrowserUtil {
    private static final MyLocationListener locListener = new MyLocationListener();
    private static final Map actions = new HashMap();

    private BrowserUtil() {
    }

    public static void registerBrowserAction(String url, Action action) {
        actions.put(url, action);
    }

    public static Browser createBrowser(Composite parent) throws BrowserNotSupportedException {
        try {
            final Browser browser = new Browser(parent, 0);
            browser.addLocationListener((LocationListener)locListener);
            browser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent ev) {
                    browser.removeLocationListener((LocationListener)locListener);
                    if (OsSupport.isMacOs()) {
                        try {
                            browser.setSize(0, 0);
                            browser.setVisible(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            return browser;
        }
        catch (SWTError e) {
            throw new BrowserNotSupportedException("browser initialization failed", e);
        }
    }

    public static boolean openInWebbrowser(String url) {
        return Program.launch((String)url);
    }

    private static class MyLocationListener
    implements LocationListener {
        private MyLocationListener() {
        }

        public void changing(LocationEvent ev) {
            String loc = ev.location;
            if (loc.endsWith("?")) {
                loc = loc.substring(0, Math.max(1, loc.length() - 1));
            }
            if (actions.containsKey(loc)) {
                Action action = (Action)actions.get(loc);
                action.run();
                ev.doit = false;
            } else if (loc.startsWith("https://") || loc.startsWith("http://")) {
                BrowserUtil.openInWebbrowser(loc);
                ev.doit = false;
            }
        }

        public void changed(LocationEvent ev) {
        }
    }
}

