/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.treestructure;

import ch.dvbern.tax.common.presentation.cd.help.event.IModelChangedListener;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TreeStructureNewGui
extends Dialog
implements SelectionListener,
FocusListener,
ISelectionChangedListener,
IModelChangedListener {
    private HelpItem newHelpItem;
    private HelpItem parentItem;
    private HelpRoot root;
    private Browser browser;
    private Text linkDescription;
    private Text htmlDoc;
    private IToolCommunicationGui callback = null;

    public TreeStructureNewGui(Shell parentShell, IToolCommunicationGui pCallback, HelpItem pParentItem) {
        super(parentShell);
        this.parentItem = pParentItem;
        this.callback = pCallback;
        this.newHelpItem = new HelpItem("", "", "");
        this.newHelpItem.addModelChangedListener(this);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("New topic");
        shell.setSize(800, 600);
    }

    protected Control createDialogArea(Composite parent) {
        ch.dvbern.tax.common.presentation.cd.widgets.Composite panel = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        panel.setLayout((Layout)formLayout);
        ch.dvbern.tax.common.presentation.cd.widgets.Composite htmlDescriptionComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(panel, 2048);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        htmlDescriptionComposite.setLayoutData(data);
        FormLayout fLayout = new FormLayout();
        fLayout.marginHeight = 3;
        fLayout.marginWidth = 3;
        htmlDescriptionComposite.setLayout((Layout)fLayout);
        Label linkDescriptionLabel = new Label((Composite)htmlDescriptionComposite, 0);
        linkDescriptionLabel.setText("Link Description");
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(25, 0);
        data.top = new FormAttachment(0, 5);
        linkDescriptionLabel.setLayoutData((Object)data);
        this.linkDescription = new Text((Composite)htmlDescriptionComposite, 2048);
        data = new FormData();
        data.left = new FormAttachment((Control)linkDescriptionLabel, 0, -1);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, 3);
        this.linkDescription.setLayoutData((Object)data);
        this.linkDescription.setData((Object)"description");
        this.linkDescription.addFocusListener((FocusListener)this);
        Label htmlDocLabel = new Label((Composite)htmlDescriptionComposite, 0);
        htmlDocLabel.setText("HTML Document");
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(25, 0);
        data.top = new FormAttachment((Control)linkDescriptionLabel, 15, -1);
        htmlDocLabel.setLayoutData((Object)data);
        this.htmlDoc = new Text((Composite)htmlDescriptionComposite, 2048);
        data = new FormData();
        data.left = new FormAttachment((Control)htmlDocLabel, 0, -1);
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment((Control)this.linkDescription, 8, -1);
        this.htmlDoc.setData((Object)"document");
        this.htmlDoc.addFocusListener((FocusListener)this);
        this.htmlDoc.setLayoutData((Object)data);
        Button browse = new Button((Composite)htmlDescriptionComposite, 8);
        browse.setText("Browse");
        data = new FormData();
        data.left = new FormAttachment((Control)this.htmlDoc, 10, -1);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)this.linkDescription, 7, -1);
        browse.setLayoutData((Object)data);
        browse.addSelectionListener((SelectionListener)this);
        ch.dvbern.tax.common.presentation.cd.widgets.Composite htmlDisplayComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(panel, 2048);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)htmlDescriptionComposite, 0, -1);
        data.bottom = new FormAttachment(92, 0);
        htmlDisplayComposite.setLayoutData(data);
        FillLayout fillLayout = new FillLayout();
        htmlDisplayComposite.setLayout((Layout)fillLayout);
        Group group0 = new Group((Composite)htmlDisplayComposite, 0);
        group0.setText("HTML Preview");
        fillLayout = new FillLayout();
        fillLayout.type = 512;
        group0.setLayout((Layout)fillLayout);
        this.browser = new Browser((Composite)group0, 8);
        ch.dvbern.tax.common.presentation.cd.widgets.Composite validateComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(panel, 2048);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)htmlDisplayComposite, 0, -1);
        data.bottom = new FormAttachment(100, 0);
        validateComposite.setLayoutData(data);
        formLayout = new FormLayout();
        formLayout.marginHeight = 3;
        formLayout.marginWidth = 3;
        validateComposite.setLayout((Layout)formLayout);
        Button ok = new Button((Composite)validateComposite, 8);
        ok.setText("OK");
        data = new FormData();
        data.left = new FormAttachment(30, 0);
        data.right = new FormAttachment(50, -5);
        data.top = new FormAttachment(0, 5);
        data.bottom = new FormAttachment(100, -5);
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)this);
        Button cancel = new Button((Composite)validateComposite, 8);
        cancel.setText("Cancel");
        data = new FormData();
        data.left = new FormAttachment((Control)ok, 10, -1);
        data.right = new FormAttachment(70, 0);
        data.top = new FormAttachment(0, 5);
        data.bottom = new FormAttachment(100, -5);
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)this);
        panel.layout();
        return panel;
    }

    protected Control createButtonBar(ch.dvbern.tax.common.presentation.cd.widgets.Composite parent) {
        return null;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button selectedButton = (Button)e.getSource();
            if (selectedButton.getText().equals("Browse")) {
                this.browseClicked();
            } else if (selectedButton.getText().equals("OK")) {
                this.okClicked();
            } else if (selectedButton.getText().equals("Cancel")) {
                this.cancelClicked();
            }
        }
    }

    private void browseClicked() {
        FileDialog fileBrowser = new FileDialog(this.getShell(), 4096);
        String[] fileExtension = new String[]{"*.html;*.htm"};
        fileBrowser.setFilterExtensions(fileExtension);
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        fileBrowser.setFilterPath(mainHelpDir);
        String fileToOpen = fileBrowser.open();
        if (fileToOpen != null && !fileToOpen.equals("")) {
            this.newHelpItem.setTopic(fileBrowser.getFileName());
        }
    }

    private void okClicked() {
        if (this.parentItem == null) {
            this.root = this.callback.toolGetMainHelpModel();
            this.root.addModelChangedListener(this);
            this.newHelpItem.setParent(this.root);
            this.root.addItem(this.newHelpItem);
        } else {
            this.newHelpItem.setParent(this.parentItem);
            this.parentItem.addItem(this.newHelpItem);
        }
        this.close();
    }

    private void cancelClicked() {
        this.close();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void displayHTML(HelpItem item) {
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + "/" + item.getTopic());
            File file = new File(url.getFile());
            if (url != null && !file.isDirectory()) {
                this.browser.setUrl(url.toExternalForm());
            } else {
                this.browser.setText("");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof Text) {
            Text focusedText = (Text)e.getSource();
            if (((String)focusedText.getData()).equals("description")) {
                this.newHelpItem.setName(focusedText.getText());
            } else if (((String)focusedText.getData()).equals("document")) {
                this.newHelpItem.setTopic(focusedText.getText());
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public boolean close() {
        if (this.newHelpItem != null) {
            this.newHelpItem.removeModelChangedListener(this);
        }
        this.newHelpItem = null;
        return super.close();
    }

    public void refreshView(HelpItem item, String property) {
        if (item != null) {
            this.linkDescription.setText(item.getName());
            this.htmlDoc.setText(item.getTopic());
            this.displayHTML(item);
        }
    }

    public void refreshView(HelpRoot root, String property) {
    }
}

