/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.mapping;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.help.util.ShortHelpMapping;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HelpMappingGui
extends Dialog
implements SelectionListener,
FocusListener {
    private Browser mainBrowser;
    private Browser shortBrowser;
    private Text shortLinkDesc;
    private Text mainLinkDesc;
    private IToolCommunicationGui callback = null;

    public HelpMappingGui(IToolCommunicationGui callback) {
        super(callback.getCallBackShell());
        this.callback = callback;
    }

    public IToolCommunicationGui getCallback() {
        return this.callback;
    }

    protected Control createDialogArea(Composite parent) {
        ((Shell)parent).setText("Taxme Tools");
        parent.setSize(800, 600);
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        Group mainHelp = new Group(parent, 0);
        mainHelp.setText("Main Help");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(45, -5);
        mainHelp.setLayoutData((Object)data);
        formLayout = new FormLayout();
        mainHelp.setLayout((Layout)formLayout);
        Label mainLinkDescLabel = new Label((Composite)mainHelp, 0);
        mainLinkDescLabel.setText("Link Description");
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment(0, 10);
        mainLinkDescLabel.setLayoutData((Object)data);
        Label mainHtmlPreview = new Label((Composite)mainHelp, 0);
        mainHtmlPreview.setText("HTML Preview");
        data = new FormData();
        data.left = new FormAttachment(25, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 10);
        mainHtmlPreview.setLayoutData((Object)data);
        this.mainLinkDesc = new Text((Composite)mainHelp, 2048);
        this.mainLinkDesc.setText(this.callback.toolGetCurrentMainHelpFileName());
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment((Control)mainLinkDescLabel, 10, -1);
        this.mainLinkDesc.setData((Object)"main");
        this.mainLinkDesc.addFocusListener((FocusListener)this);
        this.mainLinkDesc.setLayoutData((Object)data);
        Button mainBrowse = new Button((Composite)mainHelp, 8);
        mainBrowse.setText("Browse");
        mainBrowse.setData((Object)new Integer(2));
        mainBrowse.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment((Control)this.mainLinkDesc, 10, -1);
        mainBrowse.setLayoutData((Object)data);
        this.mainBrowser = new Browser((Composite)mainHelp, 0);
        this.displayHTMLMain();
        data = new FormData();
        data.left = new FormAttachment(25, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)mainHtmlPreview, 10, -1);
        data.bottom = new FormAttachment(100, 0);
        this.mainBrowser.setLayoutData((Object)data);
        Group shortHelp = new Group(parent, 0);
        shortHelp.setText("Short Help");
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)mainHelp, 5, -1);
        data.bottom = new FormAttachment(90, 0);
        shortHelp.setLayoutData((Object)data);
        formLayout = new FormLayout();
        shortHelp.setLayout((Layout)formLayout);
        Label shortLinkDescLabel = new Label((Composite)shortHelp, 0);
        shortLinkDescLabel.setText("Link Description");
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment(0, 10);
        shortLinkDescLabel.setLayoutData((Object)data);
        Label shortHtmlPreview = new Label((Composite)shortHelp, 0);
        shortHtmlPreview.setText("HTML Preview");
        data = new FormData();
        data.left = new FormAttachment(25, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 10);
        shortHtmlPreview.setLayoutData((Object)data);
        this.shortLinkDesc = new Text((Composite)shortHelp, 2048);
        this.shortLinkDesc.setText(this.callback.toolGetCurrentShortHelpFileName());
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment((Control)shortLinkDescLabel, 10, -1);
        this.shortLinkDesc.addFocusListener((FocusListener)this);
        this.shortLinkDesc.setData((Object)"short");
        this.shortLinkDesc.setLayoutData((Object)data);
        Button shortBrowse = new Button((Composite)shortHelp, 8);
        shortBrowse.setText("Browse");
        shortBrowse.setData((Object)new Integer(3));
        shortBrowse.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment((Control)this.shortLinkDesc, 10, -1);
        shortBrowse.setLayoutData((Object)data);
        this.shortBrowser = new Browser((Composite)shortHelp, 0);
        this.displayHTMLShort();
        data = new FormData();
        data.left = new FormAttachment(25, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)shortHtmlPreview, 10, -1);
        data.bottom = new FormAttachment(100, 0);
        this.shortBrowser.setLayoutData((Object)data);
        Button ok = new Button(parent, 8);
        ok.setText("OK");
        ok.setData((Object)new Integer(0));
        ok.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(30, 0);
        data.right = new FormAttachment(48, 0);
        data.top = new FormAttachment((Control)shortHelp, 10, -1);
        ok.setLayoutData((Object)data);
        Button cancel = new Button(parent, 8);
        cancel.setText("Cancel");
        cancel.setData((Object)new Integer(1));
        cancel.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(52, 0);
        data.right = new FormAttachment(70, 0);
        data.top = new FormAttachment((Control)shortHelp, 10, -1);
        cancel.setLayoutData((Object)data);
        parent.layout();
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    private void displayHTMLMain() {
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + "/" + this.mainLinkDesc.getText());
            System.out.println("URL = " + url);
            File file = new File(url.getFile());
            if (url != null && file.exists() && !file.isDirectory()) {
                this.mainBrowser.setUrl(url.toExternalForm());
            } else {
                this.mainBrowser.setText("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void displayHTMLMain(String fileName) {
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + "/" + fileName);
            System.out.println("URL = " + url);
            File file = new File(url.getFile());
            if (url != null && file.exists() && !file.isDirectory()) {
                this.mainBrowser.setUrl(url.toExternalForm());
            } else {
                this.mainBrowser.setText("");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void displayHTMLShort() {
        String shortHelpDir = this.callback.toolGetCurrentShortHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + shortHelpDir + "/" + this.shortLinkDesc.getText());
            System.out.println("URL = " + url);
            File file = new File(url.getFile());
            if (url != null && file.exists() && !file.isDirectory()) {
                this.shortBrowser.setUrl(url.toExternalForm());
            } else {
                this.shortBrowser.setText("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void displayHTMLShort(String fileName) {
        String shortHelpDir = this.callback.toolGetCurrentShortHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + shortHelpDir + "/" + fileName);
            System.out.println("URL = " + url);
            File file = new File(url.getFile());
            if (url != null && file.exists() && !file.isDirectory()) {
                this.shortBrowser.setUrl(url.toExternalForm());
            } else {
                this.shortBrowser.setText("");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected Layout getLayout() {
        return new FormLayout();
    }

    protected Control createContents(Composite composite) {
        HelpMappingGui.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    public boolean close() {
        return super.close();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button selectedButton = (Button)e.getSource();
            int data = (Integer)selectedButton.getData();
            switch (data) {
                case 0: {
                    this.ok();
                    break;
                }
                case 1: {
                    this.cancel();
                    break;
                }
                case 2: {
                    this.browseMain();
                    break;
                }
                case 3: {
                    this.browseShort();
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void ok() {
        if (this.shortLinkDesc.getText() != null) {
            if (!this.shortLinkDesc.getText().equals("")) {
                ShortHelpMapping.setValue(this.callback.toolGetCurrentScreenName(), this.shortLinkDesc.getText());
                ShortHelpMapping.saveMapping();
                this.callback.toolRefreshHelpMappings();
            } else {
                ShortHelpMapping.removeValue(this.callback.toolGetCurrentScreenName());
                ShortHelpMapping.saveMapping();
                this.callback.toolRefreshHelpMappings();
            }
        }
        if (this.mainLinkDesc.getText() != null) {
            if (!this.mainLinkDesc.getText().equals("")) {
                Messages.setString(this.callback.toolGetCurrentMainHelpName(), this.mainLinkDesc.getText());
            } else {
                Messages.removeString(this.callback.toolGetCurrentMainHelpName());
            }
        }
        this.close();
    }

    private void cancel() {
        this.close();
    }

    private void browseMain() {
        FileDialog fileBrowser = new FileDialog(this.getShell(), 4096);
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        fileBrowser.setFilterPath(mainHelpDir);
        String fileToOpen = fileBrowser.open();
        if (fileToOpen != null && !fileToOpen.equals("")) {
            String linkDesc = fileBrowser.getFileName();
            this.mainLinkDesc.setText(linkDesc);
            this.displayHTMLMain(linkDesc);
        }
    }

    private void browseShort() {
        FileDialog fileBrowser = new FileDialog(this.getShell(), 4096);
        String shorthelpDir = this.callback.toolGetCurrentShortHelpDirectory() + this.callback.toolGetCurrentLanguage();
        fileBrowser.setFilterPath(shorthelpDir);
        String fileToOpen = fileBrowser.open();
        if (fileToOpen != null && !fileToOpen.equals("")) {
            String linkDesc = fileBrowser.getFileName();
            this.shortLinkDesc.setText(linkDesc);
            this.displayHTMLShort(linkDesc);
        }
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        if (arg0.getSource() instanceof Text) {
            Text textComponent = (Text)arg0.getSource();
            String text = textComponent.getText();
            if (textComponent.getData().equals("main")) {
                this.displayHTMLMain(text);
            } else if (textComponent.getData().equals("short")) {
                this.displayHTMLShort(text);
            }
        }
    }
}

