/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.index;

import ch.dvbern.tax.common.presentation.cd.help.event.IModelChangedListener;
import ch.dvbern.tax.common.presentation.cd.help.gui.model.HelpTreeContentProvider;
import ch.dvbern.tax.common.presentation.cd.help.gui.model.HelpTreeLabelProvider;
import ch.dvbern.tax.common.presentation.cd.help.gui.model.HelpTreeViewer;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpModel;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import ch.dvbern.tax.common.presentation.cd.help.parser.HelpContentHandler;
import ch.dvbern.tax.common.presentation.cd.help.parser.HelpModelBuilder;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.index.IndexNewGui;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class IndexGui
extends Dialog
implements SelectionListener,
FocusListener,
ISelectionChangedListener,
IModelChangedListener {
    private HelpModel helpModel;
    private HelpItem selectedHelpItem;
    private Browser browser;
    private TabFolder tabFolder;
    private Text linkDescription;
    private Shell shell;
    private Button delete;
    private Button save;
    private Button newButton;
    private IToolCommunicationGui callback = null;
    private HelpTreeViewer viewer;

    public IndexGui(Shell parentShell, IToolCommunicationGui callback) {
        super(parentShell);
        this.shell = parentShell;
        this.callback = callback;
        this.helpModel = HelpContentHandler.getHelpModel();
    }

    public IToolCommunicationGui getCallback() {
        return this.callback;
    }

    protected Control createDialogArea(Composite parent) {
        ((Shell)parent).setText("Index GUI");
        parent.setSize(800, 600);
        Sash sash = new Sash(parent, 512);
        sash.addSelectionListener((SelectionListener)this);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(30, 0);
        sash.setLayoutData((Object)data);
        Composite navigationPart = new Composite(parent, 2048);
        data = new FormData();
        data.top = new FormAttachment(8, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)sash, 0);
        navigationPart.setLayoutData((Object)data);
        this.tabFolder = new TabFolder(navigationPart, 128);
        navigationPart.setLayout((Layout)new FillLayout());
        Composite toolsViewPart = new Composite(parent, 2048);
        data = new FormData();
        data.top = new FormAttachment(8, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment((Control)sash, 0);
        data.right = new FormAttachment(100, 0);
        toolsViewPart.setLayoutData((Object)data);
        FormLayout formLayout = new FormLayout();
        toolsViewPart.setLayout((Layout)formLayout);
        Composite itemDescription = new Composite(toolsViewPart, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        itemDescription.setLayout((Layout)gridLayout);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        itemDescription.setLayoutData((Object)data);
        Button moveUp = new Button(itemDescription, 8);
        moveUp.setText("Move up");
        moveUp.setData((Object)new Integer(0));
        moveUp.addSelectionListener((SelectionListener)this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 1;
        moveUp.setLayoutData((Object)gridData);
        Button moveDown = new Button(itemDescription, 8);
        moveDown.setText("Move Down");
        moveDown.setData((Object)new Integer(1));
        moveDown.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        gridData.horizontalSpan = 3;
        moveDown.setLayoutData((Object)gridData);
        Label labelLinkDescription = new Label(itemDescription, 0);
        labelLinkDescription.setText("Link Description :");
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        labelLinkDescription.setLayoutData((Object)gridData);
        this.linkDescription = new Text(itemDescription, 2048);
        this.linkDescription.addFocusListener((FocusListener)this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.horizontalSpan = 3;
        this.linkDescription.setLayoutData((Object)gridData);
        Composite validateChange = new Composite(toolsViewPart, 2048);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        validateChange.setLayout((Layout)gridLayout);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        validateChange.setLayoutData((Object)data);
        this.newButton = new Button(validateChange, 8);
        this.newButton.setText("New");
        this.newButton.setData((Object)new Integer(2));
        this.newButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        this.newButton.setLayoutData((Object)gridData);
        this.save = new Button(validateChange, 8);
        this.save.setText("Save");
        this.save.setData((Object)new Integer(3));
        this.save.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        this.save.setLayoutData((Object)gridData);
        this.delete = new Button(validateChange, 8);
        this.delete.setText("Delete");
        this.delete.setData((Object)new Integer(4));
        this.delete.setEnabled(false);
        this.delete.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        this.delete.setLayoutData((Object)gridData);
        Composite viewPart = new Composite(toolsViewPart, 2048);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)itemDescription, 0, -1);
        data.bottom = new FormAttachment((Control)validateChange, 0, -1);
        viewPart.setLayoutData((Object)data);
        viewPart.setLayout((Layout)new FillLayout());
        this.browser = new Browser(viewPart, 0);
        HelpRoot root = this.callback.toolGetMainHelpIndexModel();
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setText(root.getName());
        Composite composite = new Composite((Composite)this.tabFolder, 2048);
        composite.setLayout((Layout)new FillLayout());
        item.setControl((Control)composite);
        this.createViewer((Composite)item.getControl(), root);
        parent.layout();
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Sash) {
            this.moveSash(e);
        }
        if (e.getSource() instanceof Button) {
            Button selectedButton = (Button)e.getSource();
            int data = (Integer)selectedButton.getData();
            switch (data) {
                case 0: {
                    this.moveUpClicked();
                    break;
                }
                case 1: {
                    this.moveDownClicked();
                    break;
                }
                case 2: {
                    this.newClicked();
                    break;
                }
                case 3: {
                    this.saveClicked();
                    break;
                }
                case 4: {
                    this.deleteClicked();
                }
            }
        }
    }

    private void moveSash(SelectionEvent e) {
        Sash sash = (Sash)e.getSource();
        ((FormData)sash.getLayoutData()).left = new FormAttachment(0, e.x);
        sash.getParent().layout();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void createViewer(Composite itemComposite, HelpRoot root) {
        this.viewer = new HelpTreeViewer(itemComposite, 770);
        HelpTreeContentProvider contentProvider = new HelpTreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        HelpTreeLabelProvider labelProvider = new HelpTreeLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setInput(root);
        this.viewer.addSelectionChangedListener(this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.newButton.setEnabled(true);
        this.delete.setEnabled(true);
        TreeViewer viewer = (TreeViewer)event.getSource();
        if (viewer.getSelection() instanceof StructuredSelection && !viewer.getSelection().isEmpty()) {
            StructuredSelection selection = (StructuredSelection)viewer.getSelection();
            HelpItem itemSelected = (HelpItem)selection.getFirstElement();
            itemSelected.addModelChangedListener(this);
            this.selectedHelpItem = itemSelected;
            this.displayHTML(itemSelected);
            this.linkDescription.setText(itemSelected.getName());
        }
    }

    private void displayHTML(HelpItem item) {
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + "/" + item.getTopic());
            File file = new File(url.getFile());
            if (url != null && file.exists() && !file.isDirectory()) {
                this.browser.setUrl(url.toExternalForm());
            } else {
                this.browser.setText("");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void setModel(HelpModel model) {
        this.helpModel = model;
    }

    protected Layout getLayout() {
        return new FormLayout();
    }

    protected Control createContents(Composite composite) {
        IndexGui.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    public void refreshView(HelpItem item, String property) {
        this.linkDescription.setText(item.getName());
        this.displayHTML(this.selectedHelpItem);
        if (property.equals("name") || property.equals("move") || property.equals("add") || property.equals("delete")) {
            this.viewer.refresh();
        }
    }

    public void refreshView(HelpRoot root, String property) {
        this.viewer.refresh();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof Text && this.selectedHelpItem != null) {
            this.selectedHelpItem.setName(((Text)e.getSource()).getText());
        }
    }

    public boolean close() {
        if (this.selectedHelpItem != null) {
            this.selectedHelpItem.removeModelChangedListener(this);
        }
        return super.close();
    }

    private void moveUpClicked() {
        System.out.println("moveUpClicked");
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            HelpItem selectedTopic = (HelpItem)selection.getFirstElement();
            selectedTopic.moveUp();
        }
    }

    private void moveDownClicked() {
        System.out.println("moveDownClicked");
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            HelpItem selectedTopic = (HelpItem)selection.getFirstElement();
            selectedTopic.moveDown();
        }
    }

    private void newClicked() {
        System.out.println("newRootClicked");
        this.callback.toolGetMainHelpModel().addModelChangedListener(this);
        IndexNewGui indexNew = new IndexNewGui(this.shell, this);
        indexNew.setBlockOnOpen(true);
        indexNew.create();
        indexNew.open();
        this.callback.toolGetMainHelpModel().removeModelChangedListener(this);
    }

    private void saveClicked() {
        System.out.println("saveClicked");
        HelpModelBuilder.singleton().createRootElement(this.helpModel);
    }

    private void deleteClicked() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            HelpItem selectedTopic = (HelpItem)selection.getFirstElement();
            selectedTopic.delete();
        }
    }
}

