/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.MessageControlMapper;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import java.util.Collection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MessagePart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite {
    private TableViewer viewer;
    private ch.dvbern.tax.common.presentation.cd.widgets.Table msgTable;
    private TableColumn colMsg;
    protected final boolean toolsEnabled = TaxmeConfig.getBoolean("ToolsEnabled");

    public MessagePart(Composite parent) {
        super(parent, 2048);
        this.msgTable = new ch.dvbern.tax.common.presentation.cd.widgets.Table(this, 65540);
        this.msgTable.setLinesVisible(false);
        this.msgTable.setHeaderVisible(false);
        if (this.toolsEnabled) {
            this.msgTable.addSelectionListener((SelectionListener)new TranslationSelectionListener());
        }
        this.msgTable.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        TableColumn colState = new TableColumn((Table)this.msgTable, 0);
        colState.setWidth(OsSupport.isMacOs() ? 40 : 20);
        this.colMsg = new TableColumn((Table)this.msgTable, 16384);
        this.viewer = new TableViewer((Table)this.msgTable);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MsgTableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new MsgTableContentProvider());
        this.setLayout((Layout)new FillLayout());
        MsgTableSelectionListener li = new MsgTableSelectionListener();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)li);
        this.viewer.addDoubleClickListener((IDoubleClickListener)li);
    }

    public void setContent(Collection msgs) {
        this.setRedraw(false);
        this.viewer.setInput((Object)msgs);
        this.setRedraw(true);
        this.colMsg.pack();
    }

    private class TranslationSelectionListener
    extends SelectionAdapter {
        private TranslationSelectionListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            TableItem item = MessagePart.this.msgTable.getSelection()[0];
            String key = ((MessageItemDTO)item.getData()).getKey();
            TranslationManager.getInstance().translate(key);
        }
    }

    private class MsgTableContentProvider
    implements IStructuredContentProvider {
        private MsgTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] messages;
            Collection msgs = (Collection)inputElement;
            if (msgs != null) {
                messages = new MessageItemDTO[msgs.size()];
                msgs.toArray(messages);
            } else {
                messages = new MessageItemDTO[]{};
            }
            return messages;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private class MsgTableLabelProvider
    implements ITableLabelProvider {
        private MsgTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            MessageItemDTO msg = (MessageItemDTO)element;
            if (columnIndex == 0) {
                return GuiUtil.createStateImage(msg.getType(), true);
            }
            return null;
        }

        public String getColumnText(Object inputElement, int columnIndex) {
            MessageItemDTO msg = (MessageItemDTO)inputElement;
            if (columnIndex == 1) {
                try {
                    LocalizationHelper loc = TaxmeController.getInstance().getLocalisationHelper();
                    loc.translate(msg.getKey(), new Object[]{msg.getValue()});
                    return loc.translate(msg.getKey(), new Object[]{msg.getValue()});
                }
                catch (LocalizationHelper.LocalizationHelperException e) {
                    e.printStackTrace();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return true;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private class MsgTableSelectionListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private MsgTableSelectionListener() {
        }

        public void doubleClick(DoubleClickEvent ev) {
            this.handleSelection((StructuredSelection)MessagePart.this.viewer.getSelection());
        }

        public void selectionChanged(SelectionChangedEvent ev) {
            this.handleSelection((StructuredSelection)MessagePart.this.viewer.getSelection());
        }

        private void handleSelection(StructuredSelection sel) {
            if (sel.getFirstElement() != null) {
                MessageItemDTO msg = (MessageItemDTO)sel.getFirstElement();
                Control ctrl = MessageControlMapper.getInstance().get(msg);
                if (ctrl != null) {
                    ctrl.setFocus();
                }
            }
        }
    }
}

