/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.help.util.ShortHelpMapping;
import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class HelpPart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite {
    private Browser browser = null;
    private String currentHelpUrl;

    public HelpPart(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new FillLayout());
        try {
            this.browser = BrowserUtil.createBrowser(this);
            this.setUrl(null);
        }
        catch (BrowserNotSupportedException e) {
            e.printStackTrace();
            this.browser = null;
        }
    }

    public void setContent(WizardDisplayInfoDTO.HelpItemDTO helpItemDTO) {
        String helpID;
        String helpText;
        String url = null;
        if (helpItemDTO != null && (helpText = Messages.getString(helpID = helpItemDTO.getId())).indexOf("mainHelp") > -1) {
            url = TaxmeConfig.getMainhelpFilePath(helpText.substring(helpText.lastIndexOf("/") + 1));
        }
        this.setUrl(url);
    }

    public boolean isShortHelpAvailableFor(String key) {
        String value = ShortHelpMapping.getString(key);
        return value != null;
    }

    public void setContent(String key) {
        String url = null;
        String value = ShortHelpMapping.getString(key);
        if (value == null) {
            value = "kurzhilfeDefault.html";
        }
        url = TaxmeConfig.getShorthelpFilePath(value);
        this.setUrl(url);
    }

    public String getHtmlUrl() {
        return this.currentHelpUrl;
    }

    private void setUrl(String url) {
        if (url == null) {
            url = TaxmeConfig.getShorthelpFilePath("kurzhilfeDefault.html");
        }
        if (!url.equals(this.currentHelpUrl)) {
            this.currentHelpUrl = url;
            if (this.browser != null) {
                this.browser.setUrl(this.currentHelpUrl);
            }
        }
    }

    public void refresh() {
        if (this.browser != null) {
            this.browser.refresh();
        }
    }
}

