/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.util.ScrollingFocusListener;
import ch.dvbern.tax.common.presentation.cd.widgets.Button;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ButtonsPart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite {
    protected static ScrollingFocusListener focusListener = new ScrollingFocusListener();

    public ButtonsPart(Composite parent) {
        this(parent, 0);
    }

    public ButtonsPart(Composite parent, int style) {
        super(parent, style);
    }

    protected Button createButton(ActionBase action) {
        return this.createButton(action, OsSupport.isMacOs() ? 150 : 130);
    }

    protected Button createButton(final ActionBase action, int width) {
        final Button button = new Button(this, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                action.run(button.getData());
            }
        });
        button.addFocusListener(focusListener);
        button.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        if (action.getImageDescriptor() != null) {
            final Image img = action.getImageDescriptor().createImage();
            button.setImage(img);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent ev) {
                    if (!img.isDisposed()) {
                        img.dispose();
                    }
                }
            });
        }
        button.setText(Messages.getString(action.getNlsKey(), (Control)button));
        button.setToolTipText(action.getDescription());
        button.setData(action.getNlsKey());
        if (this.getLayout() instanceof GridLayout) {
            GridData gd = new GridData();
            if (width >= 0) {
                gd.widthHint = width;
            }
            if (OsSupport.isWindowsOs()) {
                gd.heightHint = 20;
            }
            if (gd.heightHint > 0) {
                gd.heightHint = GuiUtil.zoom(gd.heightHint) + 5;
            }
            if (gd.widthHint > 0) {
                gd.widthHint = GuiUtil.zoom(gd.widthHint);
            }
            button.setLayoutData(gd);
        }
        return button;
    }
}

