/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.layout;

import ch.dvbern.tax.common.presentation.cd.layout.SimpleBorderData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SimpleBorderLayout
extends Layout {
    static final int CENTER = 0;
    static final int EAST = 1;
    static final int WEST = 2;
    private final Control[] controls = new Control[3];
    private Point[] sizes;
    private int width;
    private int height;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (this.sizes == null || flushCache) {
            this.refreshSizes(composite.getChildren());
        }
        int w = wHint;
        int h = hHint;
        if (w == -1) {
            w = this.width;
        }
        if (h == -1) {
            h = this.height;
        }
        return new Point(w, h);
    }

    protected void layout(Composite composite, boolean flushCache) {
        int x;
        if (flushCache || this.sizes == null) {
            this.refreshSizes(composite.getChildren());
        }
        Rectangle clientArea = composite.getClientArea();
        if (this.controls[2] != null) {
            this.controls[2].setBounds(clientArea.x, clientArea.y, this.sizes[2].x, clientArea.height);
        }
        if (this.controls[0] != null) {
            x = (clientArea.width - this.sizes[0].x) / 2;
            x = Math.min(x, clientArea.width - this.sizes[1].x - this.sizes[0].x);
            x = Math.max(x, this.sizes[2].x);
            this.controls[0].setBounds(clientArea.x + x, clientArea.y, this.sizes[0].x, clientArea.height);
        }
        if (this.controls[1] != null) {
            x = clientArea.width - this.sizes[1].x;
            x = Math.max(x, this.sizes[2].x + this.sizes[0].x);
            this.controls[1].setBounds(clientArea.x + x, clientArea.y, this.sizes[1].x, clientArea.height);
        }
    }

    private void refreshSizes(Control[] children) {
        int i;
        for (i = 0; i < children.length; ++i) {
            Object layoutData = children[i].getLayoutData();
            if (layoutData == null || !(layoutData instanceof SimpleBorderData)) continue;
            SimpleBorderData borderData = (SimpleBorderData)layoutData;
            if (borderData.region < 0 && borderData.region > 2) continue;
            this.controls[borderData.region] = children[i];
        }
        if (this.sizes == null) {
            this.sizes = new Point[3];
        }
        for (i = 0; i < this.controls.length; ++i) {
            Control control = this.controls[i];
            this.sizes[i] = control == null ? new Point(0, 0) : control.computeSize(-1, -1, true);
        }
        this.width = Math.max(this.width, this.sizes[2].x + this.sizes[0].x + this.sizes[1].x);
        this.height = Math.max(this.sizes[2].y, this.sizes[1].y);
        this.height = Math.max(this.height, this.sizes[0].y);
    }
}

