/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.wizard;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.ITableItem;
import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.items.wizard.AWizardItem;
import ch.dvbern.tax.common.presentation.cd.items.wizard.WTableColumn;
import ch.dvbern.tax.common.presentation.cd.items.wizard.WTableRow;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.common.util.TableSortHelper;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WTableItem
extends AWizardItem
implements ITableItem {
    private WizardDisplayInfoDTO.TableItemDTO item;
    private List coldefs;
    private List rows;
    private ITableRow emptyRow;

    public WTableItem(WizardDisplayInfoDTO.TableItemDTO item) {
        this.item = item;
        this.coldefs = new ArrayList();
        Iterator it = item.getColdefs().iterator();
        while (it.hasNext()) {
            WizardDisplayInfoDTO.ColDefItemDTO element = (WizardDisplayInfoDTO.ColDefItemDTO)it.next();
            this.coldefs.add(new WTableColumn(element));
        }
        this.initRows();
    }

    private void initRows() {
        this.rows = new ArrayList();
        if (this.item.getRows() != null) {
            Iterator it = this.item.getRows().iterator();
            while (it.hasNext()) {
                WizardDisplayInfoDTO.RowItemDTO element = (WizardDisplayInfoDTO.RowItemDTO)it.next();
                this.rows.add(new WTableRow(element, false, this));
            }
        }
        if (this.item.getEmptyRow() != null) {
            this.emptyRow = new WTableRow(this.item.getEmptyRow(), true, this);
        }
    }

    public int getColspan() {
        return this.item.getColspan();
    }

    public int getRowspan() {
        return this.item.getRowspan();
    }

    public String getTitleKey() {
        return this.item.getHeader();
    }

    public String getAlign() {
        return this.item.getAlign();
    }

    public boolean isEditable() {
        return this.item.isEditable();
    }

    public Object getUID() {
        return this.item.getUniqueItemIdentifier();
    }

    public List getColdefs() {
        return this.coldefs;
    }

    public List getRows() {
        return this.rows;
    }

    public ITableRow getEmptyRow() {
        return this.emptyRow;
    }

    public boolean isFirstColumnStatus() {
        return true;
    }

    public int getRowHeigth() {
        return OsSupport.isMacOs() ? 22 : 0;
    }

    public boolean isVariableHeight() {
        return true;
    }

    public boolean isHeaderVisible() {
        return true;
    }

    public boolean isVisible() {
        return this.item.getState() != 11;
    }

    public WizardDisplayInfoDTO.TableItemDTO getItem() {
        return this.item;
    }

    public boolean isEnhanced() {
        return false;
    }

    public String getTableDmk() {
        return this.item.getDataModelKey();
    }

    public void applySorts(Map tableSorts) {
        LocalizationHelper locHelper = TaxmeController.getInstance().getLocalisationHelper();
        TableSortHelper.sortTable(this.item, locHelper, tableSorts);
        this.initRows();
    }

    public boolean isReadOnly() {
        return this.item.isReadOnly();
    }

    public List getLabelAddOns() {
        return this.item.getLabelAddOns();
    }
}

