/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.util;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ShortHelpMapping {
    private static Properties config = null;

    private static Properties getConfig() {
        try {
            if (config == null) {
                config = new Properties();
                String file_name = TaxmeConfig.getShorthelpDir() + "helpMapping.properties";
                File file = new File(file_name);
                if (!file.exists()) {
                    file.createNewFile();
                }
                config.load(new BufferedInputStream(new FileInputStream(file_name)));
            }
            return config;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getString(String key) {
        return ShortHelpMapping.getConfig().getProperty(key);
    }

    public static void setValue(String key, String value) {
        ShortHelpMapping.getConfig().setProperty(key, value);
    }

    public static void removeValue(String key) {
        ShortHelpMapping.getConfig().remove(key);
    }

    public static void saveMapping() {
        try {
            String file_name = TaxmeConfig.getShorthelpDir() + "helpMapping.properties";
            ShortHelpMapping.getConfig().store(new BufferedOutputStream(new FileOutputStream(file_name)), "Help Mapping");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getInt(String key) {
        return Integer.parseInt(ShortHelpMapping.getConfig().getProperty(key));
    }
}

