/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.parser;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpModel;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class HelpModelBuilder {
    private static HelpModelBuilder current = null;
    private Element rootElement;

    public static HelpModelBuilder singleton() {
        if (current == null) {
            return new HelpModelBuilder();
        }
        return current;
    }

    public void createRootElement(HelpModel model) {
        if (model != null) {
            this.rootElement = new Element("help");
            String nameFr = model.getNameFR();
            String nameDe = model.getNameDE();
            this.rootElement.setAttribute("nameFR", nameFr);
            this.rootElement.setAttribute("nameDE", nameDe);
            for (int i = 0; i < model.getRoots().size(); ++i) {
                this.addHelpRoot((HelpRoot)model.getRoots().get(i));
            }
            this.saveXMLFile();
        }
    }

    public void addHelpRoot(HelpRoot helpRoot) {
        Element helpRootElement = new Element("helpRoot");
        String nameFr = helpRoot.getNameFR();
        String nameDe = helpRoot.getNameDE();
        helpRootElement.setAttribute("nameFR", nameFr);
        helpRootElement.setAttribute("nameDE", nameDe);
        for (int i = 0; i < helpRoot.getItems().size(); ++i) {
            this.addHelpItem(helpRootElement, (HelpItem)helpRoot.getItems().get(i));
        }
        this.rootElement.addContent(helpRootElement);
    }

    public void addHelpItem(Element parentItem, HelpItem item) {
        Element helpItemElement = new Element("helpItem");
        String nameFr = item.getNameFR();
        String nameDe = item.getNameDE();
        String topic = item.getTopic();
        helpItemElement.setAttribute("nameFR", nameFr);
        helpItemElement.setAttribute("nameDE", nameDe);
        helpItemElement.setAttribute("topic", topic);
        for (int i = 0; i < item.getItems().size(); ++i) {
            this.addHelpItem(helpItemElement, (HelpItem)item.getItems().get(i));
        }
        parentItem.addContent(helpItemElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXMLFile() {
        Document doc = new Document(this.rootElement);
        XMLOutputter outputter = new XMLOutputter();
        File model = new File(TaxmeConfig.getMainhelpDir() + "help.xml");
        if (model.exists()) {
            model.delete();
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(model));
            outputter.output(doc, (OutputStream)out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

