/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.parser;

import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpModel;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HelpContentHandler
implements ContentHandler {
    private static final Logger log = Logger.getLogger((Class)HelpContentHandler.class);
    private static HelpModel model = null;
    private HelpRoot currentRoot = null;
    private ArrayList items = new ArrayList();
    private static HelpContentHandler current = null;

    public static HelpContentHandler singleton() {
        if (current == null) {
            return new HelpContentHandler();
        }
        return current;
    }

    private HelpContentHandler() {
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void endPrefixMapping(String arg0) throws SAXException {
    }

    public void skippedEntity(String arg0) throws SAXException {
    }

    public void setDocumentLocator(Locator arg0) {
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("helpRoot")) {
            model.addRootItem(this.currentRoot);
            this.currentRoot = null;
        } else if (qName.equals("helpItem")) {
            int nbrOfItems = this.items.size();
            HelpItem lastItem = (HelpItem)this.items.get(nbrOfItems - 1);
            if (nbrOfItems <= 1) {
                lastItem.setParent(this.currentRoot);
                this.currentRoot.addItem(lastItem);
            } else {
                HelpItem parentOfLastItem = (HelpItem)this.items.get(nbrOfItems - 2);
                lastItem.setParent(parentOfLastItem);
                parentOfLastItem.addItem(lastItem);
            }
            this.items.remove(nbrOfItems - 1);
        } else if (qName.equals("help")) {
            log.debug((Object)"Parsing terminated");
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("help")) {
            model = new HelpModel();
            model.setNameFR(atts.getValue("nameFR"));
            model.setNameDE(atts.getValue("nameDE"));
        } else if (qName.equals("helpRoot")) {
            this.currentRoot = new HelpRoot();
            this.currentRoot.setNameFR(atts.getValue("nameFR"));
            this.currentRoot.setNameDE(atts.getValue("nameDE"));
        } else if (qName.equals("helpItem")) {
            HelpItem item = new HelpItem();
            item.setNameFR(atts.getValue("nameFR"));
            item.setNameDE(atts.getValue("nameDE"));
            String topic = atts.getValue("topic");
            if (topic == null) {
                topic = "";
            }
            item.setTopic(topic);
            this.items.add(item);
        }
    }

    public static HelpModel getHelpModel() {
        return model;
    }
}

