/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.model;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.help.event.IModelChangedListener;
import ch.dvbern.tax.common.presentation.cd.help.model.IHelpTopic;
import java.util.ArrayList;
import java.util.List;

public class HelpItem
implements IHelpTopic {
    private String nameFR = null;
    private String nameDE = null;
    private String topic = null;
    private List items;
    private IHelpTopic parent;
    private ArrayList listeners;
    private final String HELP_DIRECTORY = "webapps/be/tmo-static.war/mainHelp/fr/";

    public HelpItem() {
        this.setNameDE("");
        this.setNameFR("");
        this.setTopic("");
        this.items = new ArrayList();
        this.listeners = new ArrayList();
    }

    public HelpItem(String nameDe, String nameFr, String topic) {
        this();
        this.setNameDE(nameDe);
        this.setNameFR(nameFr);
        this.setTopic(topic);
    }

    public String getNameDE() {
        return this.nameDE;
    }

    public void setNameDE(String nameDE) {
        this.nameDE = nameDE;
    }

    public String getNameFR() {
        return this.nameFR;
    }

    public void setNameFR(String nameFR) {
        this.nameFR = nameFR;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String pTopic) {
        String oldTopic = this.topic;
        this.topic = pTopic;
        this.fireModelChanged("topic", oldTopic, pTopic);
    }

    public String getHTMLPath() {
        return "webapps/be/tmo-static.war/mainHelp/fr/" + this.topic;
    }

    public void addItem(HelpItem item) {
        this.items.add(item);
        this.fireModelChanged("add");
    }

    public List getItems() {
        return this.items;
    }

    public String getName() {
        if (TaxmeController.getInstance().getLanguage().equals("fr")) {
            return this.getNameFR();
        }
        return this.getNameDE();
    }

    public void setName(String name) {
        String oldName = this.getName();
        if (TaxmeController.getInstance().getLanguage().equals("fr")) {
            this.setNameFR(name);
        } else {
            this.setNameDE(name);
        }
        this.fireModelChanged("name", oldName, this.getName());
    }

    public String getHelpDirectory() {
        return "webapps/be/tmo-static.war/mainHelp/fr/";
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if ((IModelChangedListener)this.listeners.get(i) != listener) continue;
            this.listeners.remove(listener);
        }
    }

    private void fireModelChanged(String property, String oldValue, String newValue) {
        if (newValue != null && oldValue != null && !oldValue.equals(newValue)) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((IModelChangedListener)this.listeners.get(i)).refreshView(this, property);
            }
        }
    }

    private void fireModelChanged(String action) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((IModelChangedListener)this.listeners.get(i)).refreshView(this, action);
        }
    }

    public IHelpTopic getParent() {
        return this.parent;
    }

    public void setParent(IHelpTopic parent) {
        this.parent = parent;
    }

    public void moveUp() {
        List itemsCommonToParent = this.getParent().getItems();
        for (int i = 0; i < itemsCommonToParent.size(); ++i) {
            if (!((HelpItem)itemsCommonToParent.get(i)).equals(this) || i <= 0) continue;
            itemsCommonToParent.add(i - 1, itemsCommonToParent.get(i));
            itemsCommonToParent.remove(i + 1);
            this.fireModelChanged("move");
            return;
        }
    }

    public void moveDown() {
        List itemsCommonToParent = this.getParent().getItems();
        for (int i = 0; i < itemsCommonToParent.size(); ++i) {
            if (!((HelpItem)itemsCommonToParent.get(i)).equals(this) || itemsCommonToParent.size() - i <= 1) continue;
            HelpItem itemToMoveDown = (HelpItem)itemsCommonToParent.get(i);
            itemsCommonToParent.remove(i);
            itemsCommonToParent.add(i + 1, itemToMoveDown);
            this.fireModelChanged("move");
            return;
        }
    }

    public void delete() {
        List itemsCommonToParent = this.getParent().getItems();
        for (int i = 0; i < itemsCommonToParent.size(); ++i) {
            if (!((HelpItem)itemsCommonToParent.get(i)).equals(this)) continue;
            itemsCommonToParent.remove(i);
            this.fireModelChanged("delete");
            return;
        }
    }

    public void newSubRoot(HelpItem item) {
        this.addItem(item);
    }
}

