/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.expertdisplay;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ExpertGuiUtil {
    private static final FontRegistry fontRegistry = new FontRegistry();
    private static final ColorRegistry colorRegistry = new ColorRegistry();

    public static Font getFont(ExpertDisplayInfoDTO.FontDTO fontDTO, float zoom) {
        if (fontDTO == null) {
            return Display.getCurrent().getSystemFont();
        }
        String fontId = fontDTO.toString();
        if (!fontRegistry.hasValueFor(fontId)) {
            FontData fd = new FontData();
            fd.setName(fontDTO.getName());
            fd.setHeight(Math.round(fontDTO.getSize() + (float)(TaxmeController.getInstance().isUseLargeFonts() ? 2 : 0)));
            int style = 0;
            if ((fontDTO.getStyle() & 1) != 0) {
                style |= 1;
            }
            if ((fontDTO.getStyle() & 2) != 0) {
                style |= 2;
            }
            fd.setStyle(style);
            fontRegistry.put(fontId, new FontData[]{fd});
        }
        return fontRegistry.get(fontId);
    }

    public static Color getColor(ExpertDisplayInfoDTO.ColorDTO colorDTO) {
        if (colorDTO == null) {
            return null;
        }
        String hexColor = colorDTO.toString();
        if (!colorRegistry.hasValueFor(hexColor)) {
            RGB rgb = new RGB(colorDTO.getRed(), colorDTO.getGreen(), colorDTO.getBlue());
            colorRegistry.put(hexColor, rgb);
        }
        return colorRegistry.get(hexColor);
    }

    public static String removeLastTableIndexPart(String formAccessKey) {
        if (formAccessKey == null) {
            return null;
        }
        int sharpPos = formAccessKey.indexOf("#");
        if (sharpPos < 0) {
            return formAccessKey;
        }
        int pointPos = formAccessKey.lastIndexOf(".");
        if (pointPos < sharpPos) {
            return formAccessKey.substring(0, sharpPos);
        }
        return formAccessKey.substring(0, pointPos);
    }
}

