/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.expertdisplay;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.builders.ControlBuilderFactory;
import ch.dvbern.tax.common.presentation.cd.builders.ControlPanelHolder;
import ch.dvbern.tax.common.presentation.cd.builders.Director;
import ch.dvbern.tax.common.presentation.cd.builders.IControlBuilder;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExpertFormDataPart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite {
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private float zoom = 1.3865546f;
    private ControlReuseUtil controlReuseUtil = new ControlReuseUtil();
    private List tabOrder;
    private Point bgSize;

    public ExpertFormDataPart(Composite parent) {
        super(parent, 0);
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
    }

    private void addToTabOrder(List controls) {
        if (controls != null) {
            this.tabOrder.addAll(controls);
        }
    }

    public boolean setFocus() {
        Control[] tabList = this.getTabList();
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                if (!tabList[i].setFocus()) continue;
                return true;
            }
        }
        return false;
    }

    public void setContent(ExpertDisplayInfoDTO expertInfoDTO) {
        this.tabOrder = new ArrayList();
        this.controlReuseUtil.start();
        this.generateContent(expertInfoDTO);
        this.controlReuseUtil.end();
        this.setTabList(this.tabOrder.toArray(new Control[this.tabOrder.size()]));
    }

    private void generateContent(ExpertDisplayInfoDTO expertInfoDTO) {
        this.setBackground(expertInfoDTO.getGuiBackground());
        Director director = new Director();
        ControlBuilderFactory cbf = ControlBuilderFactory.getInstance();
        ControlPanelHolder panel = new ControlPanelHolder(this, this.controlReuseUtil, this.zoom);
        List items = expertInfoDTO.getItems();
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            ExpertDisplayInfoDTO.ItemDTO itemDTO = (ExpertDisplayInfoDTO.ItemDTO)iter.next();
            IControlBuilder builder = cbf.createBuilder(itemDTO);
            director.init(builder, panel);
            director.createControl();
            this.addToTabOrder(builder.getTabOrder());
        }
    }

    private void setBackground(ExpertDisplayInfoDTO.ImageDTO imageDTO) {
        boolean hasImage;
        String bgImage = imageDTO != null ? imageDTO.getFileName() : null;
        boolean bl = hasImage = bgImage != null && bgImage.length() > 0;
        if (hasImage && this.getBackgroundImage() == null) {
            try {
                Image img = this.getImage(bgImage);
                this.setBackgroundImage(img);
                this.setBackgroundMode(1);
                Rectangle imgSize = img.getBounds();
                this.bgSize = new Point(imgSize.width, imgSize.height);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private Image getImage(String name) throws IOException {
        ImageSource is = TaxmeController.getInstance().getFormSource();
        return GuiUtil.getImage(is, name, imageRegistry);
    }

    public Point computeSize(int arg0, int arg1) {
        if (this.bgSize == null) {
            return super.computeSize(arg0, arg1);
        }
        return this.bgSize;
    }
}

