/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.dialog.TitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.Button;
import ch.dvbern.tax.common.presentation.common.util.TaxFile;
import ch.dvbern.tax.common.presentation.common.util.TaxFileAttachment;
import java.io.File;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class DossierDialog
extends TitleAreaDialog {
    private TaxFile taxFile;

    public DossierDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setTaxFile(TaxFile taxFile) {
        this.taxFile = taxFile;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("title.dialog.dossier"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("title.dialog.dossier"));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        this.getShell().setLayout((Layout)layout);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        GridData data = new GridData(32);
        data.widthHint = 500;
        data.heightHint = 100;
        final TableViewer tbv = new TableViewer(panel, 67600);
        tbv.getTable().setLayoutData((Object)data);
        tbv.setContentProvider((IContentProvider)new MyContentProvider());
        tbv.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        TableColumn column = new TableColumn(tbv.getTable(), 16384);
        column.setText(Messages.getString("table.dialog.dossier.name"));
        column.setWidth(200);
        column = new TableColumn(tbv.getTable(), 131072);
        column.setText(Messages.getString("table.dialog.dossier.size"));
        column.setWidth(100);
        column = new TableColumn(tbv.getTable(), 16384);
        column.setText(Messages.getString("table.dialog.dossier.comment"));
        column.setWidth(200);
        tbv.setInput((Object)this.taxFile.getAttachments());
        tbv.getTable().setHeaderVisible(true);
        Composite composite = new Composite((Composite)this.getShell(), 0);
        data = new GridData(32);
        composite.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        final Button buttonOpen = new Button(composite, 0);
        buttonOpen.setLayoutData(data);
        data = new GridData(1808);
        Button buttonInsert = new Button(composite, 0);
        buttonInsert.setLayoutData(data);
        data = new GridData(1808);
        final Button buttonDelete = new Button(composite, 0);
        buttonDelete.setLayoutData(data);
        data = new GridData(1808);
        final Button buttonComment = new Button(composite, 0);
        buttonComment.setLayoutData(data);
        data = new GridData(1808);
        Button buttonClose = new Button(composite, 0);
        buttonClose.setLayoutData(data);
        tbv.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                buttonDelete.setEnabled(true);
                buttonOpen.setEnabled(true);
                buttonComment.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonOpen.setText(Messages.getString("button.dialog.dossier.open"));
        buttonOpen.setEnabled(false);
        buttonOpen.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Program.launch((String)DossierDialog.this.taxFile.getAttachmentFile(((TaxFileAttachment)tbv.getElementAt(tbv.getTable().getSelectionIndex())).getFileName()).getAbsolutePath());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonInsert.setText(Messages.getString("button.dialog.dossier.insert"));
        buttonInsert.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialogInsert = new FileDialog(DossierDialog.this.getShell(), 4096);
                String fileName = dialogInsert.open();
                if (fileName != null) {
                    DossierDialog.this.taxFile.putAttachmentFile(new File(fileName), "");
                    tbv.setInput((Object)DossierDialog.this.taxFile.getAttachments());
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonDelete.setText(Messages.getString("button.dialog.dossier.delete"));
        buttonDelete.setEnabled(false);
        buttonDelete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int answer = DialogUtil.showYesNoCancelDialog(Messages.getString("message.dialog.dossier.delete"));
                if (answer == 0) {
                    DossierDialog.this.taxFile.removeAttachment(((TaxFileAttachment)tbv.getElementAt(tbv.getTable().getSelectionIndex())).getFileName());
                    buttonDelete.setEnabled(false);
                    buttonOpen.setEnabled(false);
                    buttonComment.setEnabled(false);
                    tbv.setInput((Object)DossierDialog.this.taxFile.getAttachments());
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonComment.setText(Messages.getString("button.dialog.dossier.add"));
        buttonComment.setEnabled(false);
        buttonComment.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                final Shell commentDialog = new Shell(DossierDialog.this.getShell(), 112);
                DossierDialog.this.configureShell(commentDialog);
                commentDialog.setLayout((Layout)new GridLayout(1, true));
                commentDialog.setSize(500, 160);
                commentDialog.setText(Messages.getString("title.dialog.dossier.comment"));
                Text title = new Text((Composite)commentDialog, 8);
                title.setText(Messages.getString("title.dialog.dossier.comment"));
                final Text comment = new Text((Composite)commentDialog, 2064);
                final TaxFileAttachment fileToOpen = (TaxFileAttachment)tbv.getElementAt(tbv.getTable().getSelectionIndex());
                Composite composite = new Composite((Composite)commentDialog, 0);
                GridData data = new GridData(32);
                data.heightHint = 50;
                data.widthHint = 450;
                composite.setLayoutData((Object)data);
                if (fileToOpen.getComment() != null) {
                    comment.setText(fileToOpen.getComment());
                } else {
                    comment.setText(Messages.getString("text.dialog.dossier.comment"));
                }
                comment.setLayoutData((Object)data);
                GridLayout layout = new GridLayout(2, true);
                composite.setLayout((Layout)layout);
                data = new GridData(32);
                Button buttonYes = new Button(composite, 0);
                buttonYes.setLayoutData(data);
                data = new GridData(32);
                Button buttonNo = new Button(composite, 0);
                buttonNo.setLayoutData(data);
                buttonYes.setText(Messages.getString("button.dialog.dossier.yes"));
                buttonNo.setText(Messages.getString("button.dialog.dossier.no"));
                commentDialog.open();
                buttonYes.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        DossierDialog.this.taxFile.setComment(fileToOpen.getFileName(), comment.getText());
                        commentDialog.close();
                        buttonOpen.setEnabled(false);
                        buttonComment.setEnabled(false);
                        buttonDelete.setEnabled(false);
                        tbv.setInput((Object)DossierDialog.this.taxFile.getAttachments());
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
                buttonNo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        buttonOpen.setEnabled(false);
                        buttonComment.setEnabled(false);
                        buttonDelete.setEnabled(false);
                        commentDialog.close();
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        buttonClose.setText(Messages.getString("button.dialog.dossier.close"));
        buttonClose.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DossierDialog.this.getShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return panel;
    }

    protected Control createButtonBar(Composite control) {
        return null;
    }

    public class MyLabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int column_index) {
            TaxFileAttachment myFile = (TaxFileAttachment)element;
            if (column_index == 0) {
                return myFile.getFileName();
            }
            if (column_index == 1) {
                return myFile.getSize() / 1024L + " KB";
            }
            if (column_index == 2) {
                return myFile.getComment();
            }
            return "";
        }

        public void addListener(ILabelProviderListener ilabelproviderlistener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void removeListener(ILabelProviderListener ilabelproviderlistener) {
        }

        public Image getColumnImage(Object element, int column_index) {
            return null;
        }
    }

    public class FileTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object element) {
            File[] kids = null;
            kids = ((File)element).listFiles();
            return kids == null ? new Object[]{} : kids;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old_object, Object new_object) {
        }
    }

    public class MyContentProvider
    implements IStructuredContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object file) {
            return ((List)file).toArray();
        }
    }
}

