/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.TitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChangePasswordDialog
extends TitleAreaDialog {
    private Label labelOldPassword;
    private Label labelNewPassword;
    private Label labelConfPassword;
    private Text textOldPassword;
    private Text textNewPassword;
    private Text textConfPassword;

    public ChangePasswordDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("title.password.change"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("title.password.change"));
        this.setMessage(Messages.getString("label.password.change.message"));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        this.labelOldPassword = new Label(panel, 0);
        this.labelOldPassword.setText(Messages.getString("label.password.change.old", (Control)this.labelOldPassword));
        this.textOldPassword = new Text(panel, 2048);
        this.textOldPassword.setEchoChar('*');
        this.textOldPassword.setLayoutData((Object)new GridData(768));
        this.textOldPassword.setFocus();
        this.labelNewPassword = new Label(panel, 0);
        this.labelNewPassword.setText(Messages.getString("label.password.change.new", (Control)this.labelNewPassword));
        this.textNewPassword = new Text(panel, 2048);
        this.textNewPassword.setEchoChar('*');
        this.textNewPassword.setLayoutData((Object)new GridData(768));
        this.labelConfPassword = new Label(panel, 0);
        this.labelConfPassword.setText(Messages.getString("label.password.change.confirm", (Control)this.labelConfPassword));
        this.textConfPassword = new Text(panel, 2048);
        this.textConfPassword.setEchoChar('*');
        this.textConfPassword.setLayoutData((Object)new GridData(768));
        return panel;
    }

    protected void okPressed() {
        if (!this.textNewPassword.getText().equals(this.textConfPassword.getText())) {
            DialogUtil.showErrorDialog(Messages.getString("message.password.change.confirm.invalid"));
        } else {
            try {
                TaxmeController.getInstance().getTmoSession().changePassword(this.textOldPassword.getText(), this.textNewPassword.getText());
                this.close();
            }
            catch (InvalidAuthenticationException ex) {
                DialogUtil.showErrorDialog(Messages.getString("message.password.change.old.invalid"));
            }
        }
    }
}

