/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.wizard;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.builders.common.AControlBuilder;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Control;

public class WSectionHeaderBuilder
extends AControlBuilder {
    private static final Logger logger = Logger.getLogger((Class)WSectionHeaderBuilder.class);
    private WizardDisplayInfoDTO.HeaderItemDTO headerItemDTO;
    private BorderedLabel label;
    private Integer width;

    public void init(WizardDisplayInfoDTO.HeaderItemDTO headerDTO, Integer width) {
        this.headerItemDTO = headerDTO;
        this.label = null;
        this.width = width;
    }

    public void createControl() {
        this.label = (BorderedLabel)this.controlReuseUtil.getControl(this.headerItemDTO.getUniqueItemIdentifier());
        if (this.label == null) {
            this.label = new BorderedLabel(this.parent, 2, 1, this.headerItemDTO.getColspan(), this.width, 64);
            this.controlReuseUtil.addControl(this.headerItemDTO.getUniqueItemIdentifier(), (Control)this.label);
            this.label.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.label.setFont(GuiUtil.getFontRegistry().getBold("font.header.section"));
        }
        String key = this.headerItemDTO.getName().toString();
        try {
            this.label.setText(this.headerItemDTO.getText(TaxmeController.getInstance().getLocalisationHelper()));
        }
        catch (FormRendererException e) {
            logger.error((Object)("could not retrieve header-addons for header " + key), (Throwable)e);
            this.label.setText(Messages.getString(key, (Control)this.label.getNestedLabel()));
        }
        this.label.setData(this.headerItemDTO.getName());
        if (this.headerItemDTO.getState() == 11) {
            this.label.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY));
        } else {
            this.label.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_BLACK));
        }
    }

    public Control getControl() {
        return this.label;
    }
}

