/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.wizard;

import ch.dvbern.tax.common.presentation.cd.builders.ControlPanelHolder;
import ch.dvbern.tax.common.presentation.cd.builders.Director;
import ch.dvbern.tax.common.presentation.cd.builders.IControlBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.common.AControlBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WButtonBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WLabelBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WSectionHeaderBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WSeparatorBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WTableBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WValueBuilder;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabelStyledText;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WSectionBuilder
extends AControlBuilder {
    private static final Logger log = Logger.getLogger((Class)WSectionBuilder.class);
    private static final Director director = new Director();
    private static final WSectionHeaderBuilder sectionHeaderBuilder = new WSectionHeaderBuilder();
    private static final WSeparatorBuilder separatorBuilder = new WSeparatorBuilder();
    private static final WLabelBuilder labelBuilder = new WLabelBuilder();
    private static final WButtonBuilder buttonBuilder = new WButtonBuilder();
    private static final WValueBuilder valueBuilder = new WValueBuilder();
    private static final WTableBuilder tableBuilder = new WTableBuilder();
    private BorderedLabelStyledText label;
    private WizardDisplayInfoDTO.SectionItemDTO sectionItemDTO;
    private ControlPanelHolder sectionHolder;
    private ControlReuseUtil.CompositeAndControlReuseUtil sectionCRU;
    private int[] columns;

    public void init(WizardDisplayInfoDTO.SectionItemDTO sectionDTO) {
        this.sectionItemDTO = sectionDTO;
        this.label = null;
        this.sectionHolder = null;
        this.sectionCRU = null;
        this.columns = null;
    }

    public Control getControl() {
        return this.label;
    }

    public void createControl() {
        this.createSectionCRU();
        this.sectionCRU.getControlReuseUtil().start();
        this.createColDefs();
        this.createHeaders();
        List listRows = this.sectionItemDTO.getRows();
        if (listRows != null) {
            Iterator itRows = listRows.iterator();
            while (itRows.hasNext()) {
                WizardDisplayInfoDTO.RowItemDTO rowItemDTO = (WizardDisplayInfoDTO.RowItemDTO)itRows.next();
                if (12 == rowItemDTO.getState()) continue;
                List gridRow = this.getGridRow(this.columns, rowItemDTO.getCols());
                List cols = rowItemDTO.getCols();
                if (cols == null) continue;
                for (int i = 0; i < cols.size(); ++i) {
                    WizardDisplayInfoDTO.AbstractItemDTO element = (WizardDisplayInfoDTO.AbstractItemDTO)cols.get(i);
                    Integer size = gridRow.get(i) != null ? (Integer)gridRow.get(i) : null;
                    this.createElement(element, size);
                }
            }
        }
        this.sectionCRU.getControlReuseUtil().end();
        this.sectionCRU.getComposite().layout();
    }

    private void createSectionCRU() {
        this.sectionCRU = this.controlReuseUtil.getCompositeAndControlReuseUtil(this.sectionItemDTO.getUniqueItemIdentifier());
        if (this.sectionCRU == null) {
            this.sectionCRU = this.controlReuseUtil.addComposite(this.sectionItemDTO.getUniqueItemIdentifier(), new Composite(this.parent, 0), new ControlReuseUtil());
            GridData gdSection = new GridData(768);
            this.sectionCRU.getComposite().setLayoutData((Object)gdSection);
            this.sectionCRU.getComposite().setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.sectionHolder = new ControlPanelHolder(this.sectionCRU.getComposite(), this.sectionCRU.getControlReuseUtil());
            separatorBuilder.init();
            this.buildControl(separatorBuilder);
        } else {
            this.sectionHolder = new ControlPanelHolder(this.sectionCRU.getComposite(), this.sectionCRU.getControlReuseUtil());
        }
    }

    private void createColDefs() {
        this.columns = this.getGridArray(this.sectionItemDTO.getColdefs());
        GridLayout layoutSection = new GridLayout(this.columns.length, false);
        layoutSection.horizontalSpacing = 2;
        layoutSection.verticalSpacing = 2;
        layoutSection.marginWidth = 0;
        this.sectionCRU.getComposite().setLayout((Layout)layoutSection);
        for (int i = 0; i < this.columns.length; ++i) {
            Label label = (Label)this.sectionCRU.getControlReuseUtil().getControl("SectionCol." + i);
            if (label == null) {
                label = new Label(this.sectionCRU.getComposite(), 64);
                label.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
                this.sectionCRU.getControlReuseUtil().addControl("SectionCol." + i, (Control)label);
            }
            GridData gd = new GridData();
            if (this.columns[i] != Integer.MAX_VALUE) {
                gd.widthHint = this.columns[i];
            } else {
                gd.grabExcessHorizontalSpace = true;
            }
            label.setLayoutData((Object)gd);
        }
    }

    private void createHeaders() {
        List listHeaders = this.sectionItemDTO.getHeaders();
        List gridHeaders = this.getGridHeader(this.columns, listHeaders);
        for (int i = 0; i < listHeaders.size(); ++i) {
            WizardDisplayInfoDTO.HeaderItemDTO header = (WizardDisplayInfoDTO.HeaderItemDTO)listHeaders.get(i);
            Integer width = gridHeaders.get(i) != null ? (Integer)gridHeaders.get(i) : null;
            sectionHeaderBuilder.init(header, width);
            this.buildControl(sectionHeaderBuilder);
        }
    }

    private void createElement(WizardDisplayInfoDTO.AbstractItemDTO element, Integer width) {
        if (element instanceof WizardDisplayInfoDTO.LabelItemDTO) {
            WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)element;
            labelBuilder.init(labelItemDTO, width);
            this.buildControl(labelBuilder);
        } else if (element instanceof WizardDisplayInfoDTO.ItemItemDTO) {
            WizardDisplayInfoDTO.ItemItemDTO itemItemDTO = (WizardDisplayInfoDTO.ItemItemDTO)element;
            valueBuilder.init(itemItemDTO, width);
            this.buildControl(valueBuilder);
        } else if (element instanceof WizardDisplayInfoDTO.ButtonDTO) {
            WizardDisplayInfoDTO.ButtonDTO buttonDTO = (WizardDisplayInfoDTO.ButtonDTO)element;
            buttonBuilder.init(buttonDTO);
            this.buildControl(buttonBuilder);
        } else if (element instanceof WizardDisplayInfoDTO.TableItemDTO) {
            WizardDisplayInfoDTO.TableItemDTO tableItemDTO = (WizardDisplayInfoDTO.TableItemDTO)element;
            tableBuilder.init(tableItemDTO, width);
        } else {
            log.warn((Object)("unsupported displayitem: " + element.getClass()));
        }
    }

    private int[] getGridArray(List coldefs) {
        if (coldefs == null) {
            return new int[]{Integer.MAX_VALUE};
        }
        int[] grid = new int[coldefs.size()];
        for (int i = 0; i < coldefs.size(); ++i) {
            WizardDisplayInfoDTO.ColDefItemDTO coldef = (WizardDisplayInfoDTO.ColDefItemDTO)coldefs.get(i);
            grid[i] = !"*".equals(coldef.getWidth()) ? Integer.parseInt(coldef.getWidth()) : Integer.MAX_VALUE;
        }
        return grid;
    }

    private List getGridHeader(int[] grid, List headers) {
        ArrayList<Integer> gridHeader = new ArrayList<Integer>();
        int iGrid = 0;
        for (int iHeader = 0; iHeader < headers.size(); ++iHeader) {
            WizardDisplayInfoDTO.HeaderItemDTO headerItemDTO = (WizardDisplayInfoDTO.HeaderItemDTO)headers.get(iHeader);
            int length = 0;
            if (headerItemDTO.getColspan() >= 1) {
                int i = 0;
                while (i < headerItemDTO.getColspan()) {
                    length = length != Integer.MAX_VALUE && grid[iGrid] != Integer.MAX_VALUE ? (length += grid[iGrid]) : Integer.MAX_VALUE;
                    ++i;
                    ++iGrid;
                }
            }
            gridHeader.add(length == Integer.MAX_VALUE ? null : new Integer(length));
        }
        return gridHeader;
    }

    private List getGridRow(int[] grid, List cols) {
        ArrayList<Integer> gridRow = new ArrayList<Integer>();
        int iGrid = 0;
        for (int iRow = 0; cols != null && iRow < cols.size(); ++iRow) {
            WizardDisplayInfoDTO.AbstractItemDTO element = (WizardDisplayInfoDTO.AbstractItemDTO)cols.get(iRow);
            int length = 0;
            if (element instanceof WizardDisplayInfoDTO.RowContent) {
                WizardDisplayInfoDTO.RowContent labelItemDTO = (WizardDisplayInfoDTO.RowContent)((Object)element);
                if (labelItemDTO.getColspan() >= 1) {
                    int i = 0;
                    while (i < labelItemDTO.getColspan()) {
                        length = length != Integer.MAX_VALUE && grid[iGrid] != Integer.MAX_VALUE ? (length += grid[iGrid]) : Integer.MAX_VALUE;
                        ++i;
                        ++iGrid;
                    }
                }
            } else {
                log.warn((Object)("unsupported displayitem: " + element.getClass()));
            }
            gridRow.add(length == Integer.MAX_VALUE ? null : new Integer(length));
        }
        return gridRow;
    }

    private void buildControl(IControlBuilder builder) {
        director.init(builder, this.sectionHolder);
        director.createControl();
    }
}

