/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.expert;

import ch.dvbern.tax.common.presentation.cd.builders.common.ValueBuilder;
import ch.dvbern.tax.common.presentation.cd.items.expert.EValueItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Control;

public class EValueBuilder
extends ValueBuilder {
    private ExpertDisplayInfoDTO.ValueItemDTO valueDTO;
    private List tabOrder;
    private List controls;

    public void init(ExpertDisplayInfoDTO.ValueItemDTO valueDTO) {
        this.valueDTO = valueDTO;
        this.tabOrder = null;
        this.controls = null;
    }

    public void createControl() {
        this.controls = this.createValuePart(this.valueDTO);
        this.tabOrder = new ArrayList();
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control ctrl = (Control)iter.next();
            if (this.valueDTO.isReadonly()) continue;
            this.tabOrder.add(ctrl);
        }
    }

    private List createValuePart(ExpertDisplayInfoDTO.ValueItemDTO valueItemDTO) {
        if (valueItemDTO.getModelItem() != null && valueItemDTO.getModelItem().getState() == 12) {
            return Collections.EMPTY_LIST;
        }
        Map valuePositions = valueItemDTO.getValuePositions();
        if (valuePositions == null || valuePositions.isEmpty()) {
            EValueItem item = new EValueItem(valueItemDTO, null, null, this.zoom, true);
            Control control = this.createValuePart(item);
            return Collections.singletonList(control);
        }
        ArrayList<Control> controls = new ArrayList<Control>();
        Iterator iter = valuePositions.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            ExpertDisplayInfoDTO.ValuePositionDTO position = (ExpertDisplayInfoDTO.ValuePositionDTO)valuePositions.get(key.toString());
            EValueItem item = new EValueItem(valueItemDTO, position, key, this.zoom, true);
            Control control = this.createValuePart(item);
            controls.add(control);
        }
        return controls;
    }

    public List getTabOrder() {
        return this.tabOrder;
    }

    public Control getControl() {
        if (this.controls == null || this.controls.isEmpty()) {
            return null;
        }
        return (Control)this.controls.get(0);
    }
}

