/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders;

import ch.dvbern.tax.common.presentation.cd.builders.IControlBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.common.ButtonBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.common.LabelBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.common.ValueBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.expert.EButtonBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.expert.EImageBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.expert.ELabelBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.expert.ELinkBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.expert.ETableBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.expert.EValueBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.expert.EWizardLinkBuilder;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.items.IItem;
import ch.dvbern.tax.common.presentation.cd.items.ILabelItem;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;

public class ControlBuilderFactory {
    private static ControlBuilderFactory instance = new ControlBuilderFactory();
    private ButtonBuilder buttonBuilder = new ButtonBuilder();
    private ValueBuilder valueBuilder = new ValueBuilder();
    private LabelBuilder labelBuilder = new LabelBuilder();
    private EButtonBuilder expertButtonBuilder = new EButtonBuilder();
    private EValueBuilder expertValueBuilder = new EValueBuilder();
    private ETableBuilder expertTableBuilder = new ETableBuilder();
    private EWizardLinkBuilder expertWizardLinkBuilder = new EWizardLinkBuilder();
    private EImageBuilder expertImageBuilder = new EImageBuilder();
    private ELabelBuilder expertLabelBuilder = new ELabelBuilder();
    private ELinkBuilder expertLinkBuilder = new ELinkBuilder();

    private ControlBuilderFactory() {
    }

    public static ControlBuilderFactory getInstance() {
        return instance;
    }

    public IControlBuilder createBuilder(ExpertDisplayInfoDTO.ItemDTO itemDTO) {
        if (itemDTO instanceof ExpertDisplayInfoDTO.WizardLinkDTO) {
            this.expertWizardLinkBuilder.init((ExpertDisplayInfoDTO.WizardLinkDTO)itemDTO);
            return this.expertWizardLinkBuilder;
        }
        if (itemDTO instanceof ExpertDisplayInfoDTO.LabelDTO) {
            this.expertLabelBuilder.init((ExpertDisplayInfoDTO.LabelDTO)itemDTO);
            return this.expertLabelBuilder;
        }
        if (itemDTO instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
            this.expertValueBuilder.init((ExpertDisplayInfoDTO.ValueItemDTO)itemDTO);
            return this.expertValueBuilder;
        }
        if (itemDTO instanceof ExpertDisplayInfoDTO.ImageDTO) {
            this.expertImageBuilder.init((ExpertDisplayInfoDTO.ImageDTO)itemDTO);
            return this.expertImageBuilder;
        }
        if (itemDTO instanceof ExpertDisplayInfoDTO.LinkItemDTO) {
            this.expertLinkBuilder.init((ExpertDisplayInfoDTO.LinkItemDTO)itemDTO);
            return this.expertLinkBuilder;
        }
        if (itemDTO instanceof ExpertDisplayInfoDTO.ButtonDTO) {
            this.expertButtonBuilder.init((ExpertDisplayInfoDTO.ButtonDTO)itemDTO);
            return this.expertButtonBuilder;
        }
        if (itemDTO instanceof ExpertDisplayInfoDTO.TableDTO) {
            this.expertTableBuilder.init((ExpertDisplayInfoDTO.TableDTO)itemDTO);
            return this.expertTableBuilder;
        }
        throw new RuntimeException("type not supported");
    }

    public IControlBuilder createBuilder(IItem itemDTO) {
        if (itemDTO instanceof IValueItem) {
            this.valueBuilder.init((IValueItem)itemDTO);
            return this.valueBuilder;
        }
        if (itemDTO instanceof ILabelItem) {
            this.labelBuilder.init((ILabelItem)itemDTO);
            return this.labelBuilder;
        }
        if (itemDTO instanceof IButtonItem) {
            this.buttonBuilder.init((IButtonItem)itemDTO);
            return this.buttonBuilder;
        }
        return null;
    }
}

