/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action.menu;

import ch.dvbern.lib.update.IProgressListener;
import ch.dvbern.lib.update.UpdateManager;
import ch.dvbern.lib.update.exception.CommunicationException;
import ch.dvbern.lib.update.type.UpdateConfig;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.dialog.ProgressMonitorDialog;
import ch.dvbern.tax.common.presentation.cd.dialog.UpdateCommunicationErrorDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.ImmediatelyCancelable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class UtilUpdateAction
extends ActionBase {
    public static final int USER_REQUEST = 0;
    public static final int STARTUP_REQUEST = 1;
    private static final Logger log = Logger.getLogger((Class)UtilUpdateAction.class);
    private int requestSource = 0;

    public UtilUpdateAction(String nameKey, int requestSource) {
        super(nameKey);
        this.requestSource = requestSource;
    }

    public void run() {
        if (!this.isUpdateNeeded()) {
            return;
        }
        Updater updater = null;
        try {
            updater = new Updater();
            if (!this.run(new UpdateSearch(updater))) {
                return;
            }
        }
        catch (InvocationTargetException e) {
            log.error((Object)"update search failed", (Throwable)e);
            if (this.requestSource == 0) {
                String msgKey = e.getCause() instanceof CommunicationException ? "label.application.update.error.communication" : "label.application.update.error";
                DialogUtil.showErrorDialog(Messages.getString(msgKey));
            } else {
                boolean showStartupUpdateErrorView = false;
                String sShowStartupUpdateErrorView = TaxmeConfig.getString("update.atStartup.showStartupUpdateErrorView");
                showStartupUpdateErrorView = Boolean.valueOf(sShowStartupUpdateErrorView);
                if (showStartupUpdateErrorView) {
                    UpdateCommunicationErrorDialog dialog = new UpdateCommunicationErrorDialog(Display.getCurrent().getActiveShell());
                    dialog.open();
                    int returnCode = dialog.getReturnCode();
                    TaxmeConfig.setValue("update.atStartup.showStartupUpdateErrorView", String.valueOf(dialog.isShowStartupUpdateErrorView()));
                    if (returnCode == 0) {
                        this.run();
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            log.error((Object)"update search failed", (Throwable)e);
            if (this.requestSource == 0) {
                DialogUtil.showErrorDialog(Messages.getString("label.application.update.error"));
            }
            return;
        }
        try {
            if (!updater.updateAvailable) {
                if (this.requestSource == 0) {
                    DialogUtil.showInfoDialog(Messages.getString("label.application.update.nothing"));
                }
                return;
            }
            if (DialogUtil.showConfirmDialog(Messages.getString("label.application.update.ask"))) {
                if (!this.run(new UpdateDownload(updater))) {
                    return;
                }
                DialogUtil.showInfoDialog(Messages.getString("label.application.update.finished"));
                TaxmeController.getInstance().close();
            }
        }
        catch (InvocationTargetException e) {
            log.error((Object)"update download failed", (Throwable)e);
            String msgKey = e.getCause() instanceof CommunicationException ? "label.application.update.error.communication" : "label.application.update.error";
            DialogUtil.showErrorDialog(Messages.getString(msgKey));
        }
        catch (Exception e) {
            log.error((Object)"update download failed", (Throwable)e);
            DialogUtil.showErrorDialog(Messages.getString("label.application.update.error"));
        }
    }

    private boolean isUpdateNeeded() {
        if (this.requestSource == 1) {
            long updateIntervalInHoursAsMiliseconds;
            long lNextUpdate;
            Date nextUpdate;
            int updateIntervalInHours = 5;
            String sUpdateIntervalInHours = TaxmeConfig.getString("update.atStartup.intervalInHours");
            try {
                updateIntervalInHours = Integer.parseInt(sUpdateIntervalInHours);
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"no correct update interval set", (Throwable)nfe);
            }
            long lLastUpdate = 0L;
            String sLastUpdate = TaxmeConfig.getString("update.atStartup.lastUpdate");
            if (sLastUpdate != null) {
                try {
                    lLastUpdate = Long.parseLong(sLastUpdate);
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)"last update date not set", (Throwable)nfe);
                }
            }
            Date actualDate = new Date();
            if (lLastUpdate > 0L && actualDate.before(nextUpdate = new Date(lNextUpdate = lLastUpdate + (updateIntervalInHoursAsMiliseconds = (long)(updateIntervalInHours * 60 * 60 * 1000))))) {
                return false;
            }
            TaxmeConfig.setValue("update.atStartup.lastUpdate", String.valueOf(actualDate.getTime()));
        }
        return true;
    }

    private boolean run(IRunnableWithProgress r) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        dlg.run(true, true, r);
        return !dlg.getProgressMonitor().isCanceled();
    }

    private static class Updater {
        private static final UpdateConfig updateConfig = new UpdateConfig(TaxmeConfig.getString("update.protocol"), TaxmeConfig.getString("update.server"), TaxmeConfig.getInt("update.port"), TaxmeConfig.getString("update.path"));
        private boolean updateAvailable;
        private final UpdateManager updateManager = new UpdateManager(updateConfig);

        private Updater() {
        }

        public boolean isUpdateAvailable() {
            return this.updateAvailable;
        }

        public void searchUpdate() throws Exception {
            this.updateAvailable = this.updateManager.isUpdateAvailable();
        }

        public void downloadUpdate(IProgressListener pl) throws Exception {
            if (pl != null) {
                this.updateManager.addProgressListener(pl);
            }
            this.updateManager.update();
        }

        public void cancel() {
            this.updateManager.cancel();
        }
    }

    private static class UpdateDownload
    extends ImmediatelyCancelable {
        private Updater updater;
        private int progress;

        public UpdateDownload(Updater updater) {
            this.updater = updater;
        }

        protected void runInternal(final IProgressMonitor mon) throws Exception {
            mon.beginTask(Messages.getString("label.application.update.downloading"), 100);
            this.progress = 0;
            IProgressListener pl = new IProgressListener(){

                public void updateProgress(String resource) {
                    mon.subTask(resource);
                }

                public void updateProgress(int percent) {
                    int advance = percent - UpdateDownload.this.progress;
                    if (advance > 0) {
                        mon.worked(advance);
                        UpdateDownload.this.progress = percent;
                    }
                }

                public void updateFinished() {
                    mon.done();
                }

                public void updateCancelled() {
                    mon.done();
                }
            };
            this.updater.downloadUpdate(pl);
        }

        protected void canceled() {
            this.updater.cancel();
        }
    }

    private static class UpdateSearch
    extends ImmediatelyCancelable {
        private Updater updater;

        public UpdateSearch(Updater updater) {
            this.updater = updater;
        }

        protected void runInternal(IProgressMonitor mon) throws Exception {
            mon.beginTask(Messages.getString("label.application.update.search"), -1);
            this.updater.searchUpdate();
            mon.done();
        }
    }
}

