/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action.menu;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.TaxmeLauncher;
import ch.dvbern.tax.common.presentation.cd.action.ActionBase;
import ch.dvbern.tax.common.presentation.cd.help.gui.HelpApplication;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;

public class HelpMainhelpAction
extends ActionBase {
    private HelpApplication helpApplication;
    private DisposeListener mainShellListener;

    public HelpMainhelpAction() {
        super("menu.help.mainhelp...", "F1", "icon.menu.help.mainhelp");
    }

    public void run() {
        try {
            if (this.helpApplication == null || this.helpApplication.getShell() != null && this.helpApplication.getShell().isDisposed()) {
                this.openHelpWindow();
            }
            this.refreshHelp();
        }
        catch (SWTError e) {
            this.helpApplication = null;
            e.printStackTrace();
            String msg = OsSupport.isLinuxOs() ? Messages.getString("error.browser.linux") : (OsSupport.isMacOs() ? Messages.getString("error.browser.mac") : Messages.getString("error.browser.general"));
            DialogUtil.showErrorDialog(msg);
        }
    }

    private void openHelpWindow() {
        this.helpApplication = new HelpApplication(null);
        this.helpApplication.setBlockOnOpen(false);
        this.helpApplication.create();
        this.helpApplication.open();
        this.mainShellListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent ev) {
                if (!(HelpMainhelpAction.this.helpApplication == null || HelpMainhelpAction.this.helpApplication.getShell() == null || HelpMainhelpAction.this.helpApplication.getShell().isDisposed() || !TaxmeLauncher.isRestart() && OsSupport.isMacOs())) {
                    HelpMainhelpAction.this.helpApplication.getShell().dispose();
                }
            }
        };
        TaxmeController.getInstance().getShell().addDisposeListener(this.mainShellListener);
        this.helpApplication.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent ev) {
                HelpMainhelpAction.this.helpApplication = null;
                if (HelpMainhelpAction.this.mainShellListener != null) {
                    Shell shell = TaxmeController.getInstance().getShell();
                    if (shell != null && !shell.isDisposed()) {
                        shell.removeDisposeListener(HelpMainhelpAction.this.mainShellListener);
                    }
                    HelpMainhelpAction.this.mainShellListener = null;
                }
            }
        });
    }

    private void refreshHelp() {
        this.helpApplication.showCurrent();
        Shell helpShell = this.helpApplication.getShell();
        if (helpShell.getMinimized()) {
            helpShell.setMinimized(false);
        }
        helpShell.setFocus();
    }
}

