/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.program.Program;

public class DocumentAction
extends Action {
    private String directory = null;
    private String filename = null;

    public DocumentAction(String filename, String menuname) {
        super(Messages.getString(menuname));
        this.filename = filename;
        this.directory = new File("").getAbsolutePath() + File.separator + TaxmeConfig.getString("doc.dir");
    }

    public void run() {
        this.execute();
    }

    public void execute() {
        File file = new File(this.directory + File.separator + this.filename);
        try {
            this.showPdf(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showPdf(File file) throws Exception {
        if (TaxmeConfig.getBoolean("acroread.path.use")) {
            String path = TaxmeConfig.getString("acroread.path");
            if (!new File(path).exists()) throw new Exception("PDF Viewer not found");
            try {
                Runtime.getRuntime().exec(path + " " + file.getAbsolutePath());
                return;
            }
            catch (IOException e) {
                throw new Exception("can't launch PDF Viewer", e);
            }
        } else {
            if (Program.launch((String)file.getAbsolutePath())) return;
            if (!new File(TaxmeConfig.getString("acroread.path")).exists()) throw new Exception("can't launch PDF Viewer");
            TaxmeConfig.setValue("acroread.path.use", "true");
            this.showPdf(file);
        }
    }
}

