/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.action.ButtonAddAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonDeleteAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonEditAction;
import ch.dvbern.tax.common.presentation.cd.action.PrintAllAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FilePrintAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;

public class ActionRegistry {
    public static final String PRINT = "print";
    public static final String INIT = "init";
    public static final String TREUHAND = "treuhand";
    public static final String DOCUMENTS = "documents";
    public static final String LAWS = "laws";
    public static final String TABLE_ADD = "table.add";
    public static final String TABLE_EDIT = "table.edit";
    public static final String TABLE_DELETE = "table.delete";
    public static final String LINK_WWW = "link.www";
    private static final ActionRegistry instance = new ActionRegistry();
    private List printActions = new ArrayList();
    private List documentActions = new ArrayList();
    private List lawActions = new ArrayList();
    private Map actions = new HashMap();

    private ActionRegistry() {
        this.printActions.add(new PrintAllAction());
        this.registerAction(PRINT, new FilePrintAction());
        this.registerAction(TABLE_ADD, new ButtonAddAction());
        this.registerAction(TABLE_EDIT, new ButtonEditAction());
        this.registerAction(TABLE_DELETE, new ButtonDeleteAction());
    }

    public static ActionRegistry getInstance() {
        return instance;
    }

    public void addPrintAction(Action action) {
        this.printActions.add(action);
    }

    public List getPrintActions() {
        return this.printActions;
    }

    public void addDocumentAction(Action action) {
        this.documentActions.add(action);
    }

    public List getDocumentActions() {
        return this.documentActions;
    }

    public void addLawActions(Action action) {
        this.lawActions.add(action);
    }

    public List getLawActions() {
        return this.lawActions;
    }

    public Action getAction(String id) {
        return (Action)this.actions.get(id);
    }

    public void registerAction(String id, Action action) {
        this.actions.put(id, action);
    }
}

