/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.presentation.cd.Autosave;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ButtonRecalculateAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonValorSearchAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FilePrintAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileStartAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilUpdateAction;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommands;
import ch.dvbern.tax.common.presentation.cd.util.ConnectionUtil;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.common.imports.ImportUtil;
import ch.dvbern.tax.common.presentation.common.print.FormRendererUtil;
import java.util.TimeZone;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class TaxmeLauncher {
    private static final String DEFAULT_TIMEZONE = "CET";
    private static boolean restart;
    private static boolean open;

    public static void launchTaxme() {
        TimeZone.setDefault(TimeZone.getTimeZone(DEFAULT_TIMEZONE));
        TaxmeConfig.check();
        ImportUtil.setConfig(TaxmeConfig.getImportConfig());
        ButtonCommands.register("/print.cmd", new FilePrintAction(), false);
        ButtonCommands.register("/valor.search.cmd", new ButtonValorSearchAction(), false);
        ButtonCommands.register("/recalc.cmd", new ButtonRecalculateAction(), false);
        BrowserUtil.registerBrowserAction("https://start.cmd/", new FileStartAction());
        ConnectionUtil.configure();
        FormRendererUtil.setApplicationVersion(TaxmeConfig.getApplicationVersion());
        do {
            restart = false;
            TaxmeLauncher.launchApplication();
        } while (restart);
        System.exit(0);
    }

    public static void setRestart(boolean newValue) {
        restart = newValue;
    }

    public static boolean isRestart() {
        return restart;
    }

    private static void launchApplication() {
        Display display = Display.getDefault();
        final Shell splash = new Shell(16384);
        splash.setText(Messages.getString("taxme.cd.title", (Control)splash));
        GridLayout layout = new GridLayout(1, false);
        splash.setLayout((Layout)layout);
        final Image image = new Image((Device)display, TaxmeConfig.getIconFilePath(TaxmeConfig.getString("splash.icon")));
        Label label = new Label((Composite)splash, 0);
        label.setImage(image);
        final ProgressBar bar = new ProgressBar((Composite)splash, 0);
        bar.setLayoutData((Object)new GridData(768));
        splash.pack();
        Rectangle splashRect = splash.getBounds();
        Rectangle displayRect = display.getBounds();
        int x = (displayRect.width - splashRect.width) / 2;
        int y = (displayRect.height - splashRect.height) / 2;
        splash.setLocation(x, y);
        splash.open();
        display.asyncExec(new Runnable(){

            public void run() {
                TaxmeController.getInstance().startup(bar);
                splash.close();
                image.dispose();
            }
        });
        TaxmeController controller = TaxmeController.getInstance();
        while (controller.getShell() == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        String updateAtStartupEnabled = TaxmeConfig.getString("update.atStartup.enabled");
        if (updateAtStartupEnabled != null && updateAtStartupEnabled.equals("true")) {
            new UtilUpdateAction("startup.update", 1).run();
        }
        String autosaveEnabled = TaxmeConfig.getString("autosave.enabled");
        String passwordEnabled = TaxmeConfig.getString("password.enabled");
        if (autosaveEnabled != null && autosaveEnabled.equals("true")) {
            if (passwordEnabled != null && passwordEnabled.equals("true")) {
                DialogUtil.showErrorDialog(Messages.getString("error.autosave.passwordActivated"));
            } else {
                Autosave.startAutosave();
            }
        }
        boolean bl = open = !controller.getShell().isDisposed();
        if (open) {
            controller.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent ev) {
                    open = false;
                }
            });
            while (open) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        Autosave.stopAutosave();
    }
}

