/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.presentation.bd.cd.TmoSessionImpl;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeLauncher;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.dialog.InputDialog;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertContentPart;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertNavigationPart;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertTabPart;
import ch.dvbern.tax.common.presentation.cd.help.parser.HelpParser;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.FileHistory;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.MessageControlMapper;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfigHelper;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardContentPart;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardNavigationPart;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardTabPart;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.ImportUtil;
import ch.dvbern.tax.common.presentation.common.util.FileImageSource;
import ch.dvbern.tax.common.presentation.common.util.IOUtil;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class TaxmeController {
    public static final int MODE_WIZARD = 1;
    public static final int MODE_EXPERT = 2;
    private String wizardLinkDmk;
    private static TaxmeController instance;
    private static final Logger logger;
    private Taxme taxme;
    private TmoSessionImpl tmoSession;
    private String dataModelKey;
    private String formAccessKey;
    private FileHistory fileHistory = new FileHistory(TaxmeConfig.getInt("file.history.size"));
    private LocalisationHelperImpl localisationHelper = new LocalisationHelperImpl();
    private ImageSource imageSource;
    private ImageSource formSource;
    private ImageSource iconSource;
    private WizardDisplayInfoDTO currentWizardDTO = null;
    private ExpertDisplayInfoDTO currentExpertDTO = null;
    private int mode;
    private Locale currentLocale = Locale.GERMAN;
    private boolean declarationOpen = false;

    private TaxmeController() {
    }

    public static synchronized TaxmeController getInstance() {
        if (instance == null) {
            instance = new TaxmeController();
        }
        return instance;
    }

    public void openFile(File file) {
        this.openFile(file, null);
    }

    public void importFile(File file) {
        this.openFile(null, file);
    }

    private void checkFileVersionToOpen() throws InvalidAuthenticationException {
        Map newModel = this.tmoSession.getTaxFile().readModel();
        if (!TaxFileConfigHelper.checkVersion(newModel)) {
            throw new RuntimeException("DataModel version check failed.");
        }
    }

    public void openFile(File file, File importFrom) {
        int rc;
        InputDialog dlg;
        if (!this.askForSave()) {
            return;
        }
        this.tmoSession.setFile(file);
        String password = "";
        boolean finished = false;
        while (!finished) {
            try {
                if (importFrom == null && file != null) {
                    this.checkFileVersionToOpen();
                }
                this.tmoSession.login("", password);
                if (!TaxFileConfigHelper.checkVersion(this.tmoSession.getDataModel())) {
                    throw new RuntimeException("DataModel version check failed.");
                }
                finished = true;
                this.fileHistory.addEntry(file);
                this.declarationOpen = true;
            }
            catch (InvalidAuthenticationException e) {
                dlg = new InputDialog(this.getShell(), Messages.getString("message.enterpassword"), Messages.getString("label.password"), null, null);
                rc = dlg.open();
                if (rc == 0) {
                    password = dlg.getValue();
                    continue;
                }
                finished = true;
                this.declarationOpen = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                DialogUtil.showErrorDialog(Messages.getString("error.open.unbekannt"));
                finished = true;
                this.declarationOpen = false;
            }
        }
        if (this.declarationOpen && importFrom != null) {
            password = "";
            finished = false;
            while (!finished) {
                try {
                    ImportUtil.doImport(new BufferedInputStream(new FileInputStream(importFrom)), this.tmoSession, password);
                    finished = true;
                }
                catch (InvalidAuthenticationException e) {
                    dlg = new InputDialog(this.getShell(), Messages.getString("message.enterpassword"), Messages.getString("label.password"), null, null);
                    rc = dlg.open();
                    if (rc == 0) {
                        password = dlg.getValue();
                        continue;
                    }
                    finished = true;
                }
                catch (ImportException ie) {
                    finished = true;
                    ie.printStackTrace();
                    DialogUtil.showErrorDialog(Messages.getString(ie.getMessage()));
                }
                catch (Exception e) {
                    finished = true;
                    e.printStackTrace();
                    DialogUtil.showErrorDialog(Messages.getString("error.import.unbekannt"));
                }
            }
        }
        if (this.declarationOpen && ActionRegistry.getInstance().getAction("init") != null) {
            ActionRegistry.getInstance().getAction("init").run();
        }
        this.setTitle();
        this.setStatusLine();
        this.dataModelKey = null;
        this.formAccessKey = null;
        this.wizardLinkDmk = null;
        if (this.mode == 2 && !this.isExpertModeEnabled()) {
            this.mode = 1;
        }
        this.taxme.rebuild();
        this.taxme.undoRedoStateChanged(false, false);
        this.update();
    }

    private void setTitle() {
        File file;
        String title = Messages.getString("taxme.cd.title");
        if (this.declarationOpen && (file = this.tmoSession.getFile()) != null) {
            title = title + " - " + file.getName();
        }
        this.getShell().setText(title);
    }

    private void setStatusLine() {
        Object value;
        ModelItemDTO modelItem;
        String status = "";
        Map model = this.tmoSession.getDataModel();
        if (model != null && (modelItem = (ModelItemDTO)model.get("Stammdaten.Dossiertraeger.NameDossiertraeger")) != null && (value = modelItem.getValue()) != null) {
            status = Messages.getString("label.ready") + " " + value.toString();
        }
        this.getApp().setStatus(status);
    }

    public File closeFile() {
        if (!this.askForSave()) {
            return this.tmoSession.getFile();
        }
        File toReturn = this.tmoSession.getFile();
        this.tmoSession.logout();
        this.declarationOpen = false;
        this.setTitle();
        this.setStatusLine();
        this.taxme.rebuild();
        return toReturn;
    }

    public boolean saveFile() {
        if (this.tmoSession.getFile() == null) {
            return this.saveFileAs();
        }
        try {
            this.tmoSession.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            DialogUtil.showErrorDialog(Messages.getString("error.save.unbekannt"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFileAs() {
        try {
            File newFile = null;
            block11: while (newFile == null) {
                newFile = this.showSaveDialog();
                if (newFile == null) {
                    boolean bl = false;
                    return bl;
                }
                if (newFile.exists()) {
                    switch (DialogUtil.showYesNoCancelDialog(Messages.getString("warning.save.replace"))) {
                        case 1: {
                            newFile = null;
                            continue block11;
                        }
                        case 2: {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (!newFile.equals(this.tmoSession.getFile())) {
                        newFile.delete();
                    }
                }
                if (this.tmoSession.getFile() != null) {
                    IOUtil.copy(this.tmoSession.getFile(), newFile);
                }
                this.tmoSession.setFile(newFile);
                this.tmoSession.save();
                this.fileHistory.addEntry(newFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DialogUtil.showErrorDialog(Messages.getString("error.save.unbekannt"));
            boolean bl = false;
            return bl;
        }
        finally {
            this.setTitle();
            this.setStatusLine();
        }
        return true;
    }

    private File showSaveDialog() {
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        if (this.tmoSession.getFile() != null) {
            File oldFile = this.tmoSession.getFile();
            File parent = oldFile.getParentFile();
            if (parent != null) {
                dlg.setFilterPath(parent.getAbsolutePath());
            }
            dlg.setFileName(oldFile.getName());
        } else {
            dlg.setFileName(this.getFilename());
            dlg.setFilterPath(TaxmeConfig.getSaveDir().getAbsolutePath());
        }
        String ext = TaxFileConfigHelper.getExtension();
        dlg.setFilterExtensions(new String[]{"*" + ext});
        String fileName = dlg.open();
        if (fileName == null) {
            return null;
        }
        if (fileName.length() <= ext.length()) {
            fileName = fileName + ext;
        }
        if (!fileName.endsWith(ext)) {
            int start = fileName.length() - ext.length();
            String s = fileName.substring(start);
            if (s.equalsIgnoreCase(ext)) {
                StringBuffer sb = new StringBuffer(fileName);
                sb.replace(start, start + ext.length(), ext);
                fileName = sb.toString();
            } else {
                fileName = fileName + ext;
            }
        }
        return new File(fileName);
    }

    private String getFilename() {
        return TaxFileConfigHelper.getFileName(this.tmoSession.getDataModel());
    }

    public boolean askForSave() {
        if (!this.tmoSession.changesSaved()) {
            boolean saved = false;
            block4: while (!saved) {
                int rc = DialogUtil.showYesNoCancelDialog(Messages.getString("message.asksave"));
                switch (rc) {
                    case 0: {
                        saved = this.saveFile();
                        continue block4;
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public Taxme getApp() {
        return this.taxme;
    }

    public TmoSessionImpl getTmoSession() {
        return this.tmoSession;
    }

    public String getDataModelKey() {
        return this.dataModelKey;
    }

    public void setDataModelKey(String newDmk) {
        if (this.dataModelKey != null && this.dataModelKey.equals(newDmk)) {
            return;
        }
        this.dataModelKey = newDmk;
        this.update();
    }

    public void openWizardLink(String newDmk) {
        this.dataModelKey = newDmk;
        this.wizardLinkDmk = newDmk;
        this.setMode(1);
    }

    public void setFormAccessKey(String newFormAccessKey) {
        if (this.formAccessKey != null && this.formAccessKey.equals(newFormAccessKey)) {
            return;
        }
        this.formAccessKey = newFormAccessKey;
        this.currentExpertDTO = null;
        this.update();
    }

    public void setExpertDisplayInfo(ExpertDisplayInfoDTO currentExpertDTO, String fak) {
        this.currentExpertDTO = currentExpertDTO;
        this.formAccessKey = fak;
        this.refresh();
    }

    public String getFormAccessKey() {
        return this.formAccessKey;
    }

    public WizardDisplayInfoDTO getWizardDisplayInfoDTO() {
        if (this.currentWizardDTO == null) {
            this.currentWizardDTO = this.tmoSession.getWizardDisplayInfo();
        }
        return this.currentWizardDTO;
    }

    public boolean hasCurrentExpertFormNewMessages() {
        ExpertDisplayInfoDTO fiDTO;
        boolean result = false;
        HashSet<String> existingMessages = new HashSet<String>();
        if (this.currentExpertDTO != null && this.currentExpertDTO.getMessages() != null) {
            Iterator i = this.currentExpertDTO.getMessages().iterator();
            while (i.hasNext()) {
                existingMessages.add(((MessageItemDTO)i.next()).getKey());
            }
        }
        if ((fiDTO = this.getExpertDisplayInfoDTO(this.formAccessKey, 1)).getMessages() != null) {
            Iterator i = fiDTO.getMessages().iterator();
            while (i.hasNext() && !result) {
                result = !existingMessages.contains(((MessageItemDTO)i.next()).getKey());
            }
        }
        if (result) {
            this.update();
        }
        return result;
    }

    public boolean hasCurrentWizardFormNewMessages() {
        boolean result = false;
        HashSet<String> existingMessages = new HashSet<String>();
        if (this.currentWizardDTO != null && this.currentWizardDTO.getFormItemDTO().getMessages() != null) {
            Iterator i = this.currentWizardDTO.getFormItemDTO().getMessages().iterator();
            while (i.hasNext()) {
                existingMessages.add(((MessageItemDTO)i.next()).getKey());
            }
        }
        WizardDisplayInfoDTO.FormItemDTO fiDTO = this.getWizardDisplayInfoDTO(this.dataModelKey, false).getFormItemDTO();
        WizardDisplayInfoDTO.collectMessagesOnWizardDisplayForm(fiDTO);
        if (fiDTO.getMessages() != null) {
            Iterator i = fiDTO.getMessages().iterator();
            while (i.hasNext() && !result) {
                result = !existingMessages.contains(((MessageItemDTO)i.next()).getKey());
            }
        }
        if (result) {
            this.update();
        }
        return result;
    }

    public WizardDisplayInfoDTO getWizardDisplayInfoDTO(String key, boolean autoEnable) {
        if (this.tmoSession == null) {
            return null;
        }
        return this.tmoSession.getWizardDisplayInfo(key, autoEnable);
    }

    public void setLocale(Locale locale) {
        if (locale.getLanguage().equals(this.currentLocale.getLanguage())) {
            return;
        }
        if (DialogUtil.showConfirmDialog(Messages.getString("message.language.change"))) {
            TaxmeConfig.setValue("language", locale.getLanguage());
            this.restart();
        }
    }

    public void setUseLargeFonts(boolean useLargeFonts) {
        if (useLargeFonts == GuiUtil.isUseLargeFonts()) {
            return;
        }
        if (DialogUtil.showConfirmDialog(Messages.getString("message.language.change"))) {
            TaxmeConfig.setValue("fonts.large", useLargeFonts);
            this.restart();
        }
    }

    private void restart() {
        this.close();
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.taxme = null;
            TaxmeLauncher.setRestart(true);
        }
    }

    public boolean isUseLargeFonts() {
        return GuiUtil.isUseLargeFonts();
    }

    public String getLanguage() {
        return this.currentLocale.getLanguage();
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public ImageSource getImageSource() {
        if (this.imageSource == null) {
            this.imageSource = new FileImageSource(new File(TaxmeConfig.getImageDir()));
        }
        return this.imageSource;
    }

    public ImageSource getFormSource() {
        if (this.formSource == null) {
            this.formSource = new FileImageSource(new File(TaxmeConfig.getFormImagesDir()));
        }
        return this.formSource;
    }

    public ImageSource getIconSource() {
        if (this.iconSource == null) {
            this.iconSource = new FileImageSource(new File(TaxmeConfig.getIconDir()));
        }
        return this.iconSource;
    }

    public void createModelSnapshot() {
        this.getTmoSession().createModelSnapshot();
    }

    public void backtoModelSnapshot() {
        String newDMK = this.getTmoSession().backtoModelSnapshot();
        if (newDMK != null) {
            this.setDataModelKey(newDMK);
        }
    }

    public void update() {
        if (this.mode == 2) {
            this.currentExpertDTO = this.getExpertDisplayInfoDTO(this.formAccessKey, 1);
            this.currentWizardDTO = null;
            if (this.currentExpertDTO != null) {
                this.expertUpdate();
                this.formAccessKey = this.currentExpertDTO.getAccessKey();
            }
        } else {
            this.currentWizardDTO = this.getWizardDisplayInfoDTO(this.dataModelKey, this.isInWizardLink());
            this.currentExpertDTO = null;
            if (this.currentWizardDTO != null) {
                this.dataModelKey = this.currentWizardDTO.getThisKey();
                this.wizardUpdate();
            }
        }
        this.taxme.setModeActionsState();
    }

    public void refresh() {
        if (this.mode == 2) {
            this.currentWizardDTO = null;
            if (this.currentExpertDTO != null) {
                this.expertUpdate();
            }
        } else {
            this.currentExpertDTO = null;
            if (this.currentWizardDTO != null) {
                this.wizardUpdate();
            }
        }
    }

    private void wizardUpdate() {
        WizardNavigationPart navPart = (WizardNavigationPart)this.taxme.getNavigationPart();
        WizardContentPart contentPart = (WizardContentPart)this.taxme.getContentPart();
        WizardTabPart tabPart = (WizardTabPart)this.taxme.getTabPart();
        MessageControlMapper.getInstance().reset();
        if (navPart != null) {
            WizardDisplayInfoDTO.NavigationDTO navDTO = this.currentWizardDTO.getNavigationDTO();
            navPart.setContent(navDTO);
        }
        if (contentPart != null) {
            contentPart.setContent(this.currentWizardDTO);
        }
        if (tabPart != null) {
            tabPart.setContent(this.currentWizardDTO.getFormItemDTO());
        }
    }

    private void expertUpdate() {
        ExpertContentPart contentPart = (ExpertContentPart)this.taxme.getContentPart();
        ExpertNavigationPart navPart = (ExpertNavigationPart)this.taxme.getNavigationPart();
        ExpertTabPart tabPart = (ExpertTabPart)this.taxme.getTabPart();
        MessageControlMapper.getInstance().reset();
        this.currentExpertDTO.refreshMessages();
        if (tabPart != null) {
            tabPart.setContent(this.currentExpertDTO);
        }
        if (navPart != null) {
            navPart.setContent(this.currentExpertDTO);
        }
        if (contentPart != null) {
            contentPart.setContent(this.currentExpertDTO);
        }
    }

    public ExpertDisplayInfoDTO getExpertDisplayInfoDTO() {
        return this.currentExpertDTO;
    }

    public ExpertDisplayInfoDTO getExpertDisplayInfoDTO(String key, int mode) {
        if (this.tmoSession == null) {
            return null;
        }
        return this.tmoSession.getExpertDisplayInfo(key, this.currentLocale, mode);
    }

    public void startup(ProgressBar bar) {
        String lastFile;
        bar.setMaximum(100);
        bar.setSelection(25);
        if (this.tmoSession == null) {
            this.tmoSession = new TmoSessionImpl(TaxmeConfig.getString("path.model.xml"), TaxmeConfig.getDataResource());
        }
        bar.setSelection(50);
        String lang = TaxmeConfig.getString("language");
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
            lang = "fr".equalsIgnoreCase(lang) ? "fr" : "de";
            TaxmeConfig.setValue("language", lang);
        }
        this.currentLocale = new Locale(lang, "CH");
        GuiUtil.initializeFontRegistry();
        this.imageSource = null;
        this.formSource = null;
        this.iconSource = null;
        this.mode = TaxmeConfig.getInt("view.mode");
        this.readFileHistory();
        this.initMainHelp();
        bar.setSelection(75);
        this.taxme = new Taxme();
        this.taxme.setFileHistory(this.fileHistory);
        this.tmoSession.addUndoRedoStateListener(this.taxme);
        this.taxme.setBlockOnOpen(false);
        this.taxme.create();
        CloseListener cli = new CloseListener();
        this.getShell().addListener(21, (Listener)cli);
        this.getShell().getDisplay().addListener(21, (Listener)cli);
        if (OsSupport.isLinuxOs()) {
            this.getShell().getDisplay().getSystemImage(2);
        }
        if (this.declarationOpen) {
            this.update();
        } else if (TaxmeConfig.getBoolean("lastfile.open") && (lastFile = TaxmeConfig.getString("lastfile.path")) != null) {
            this.openFile(new File(lastFile));
        }
        this.setTitle();
        this.setStatusLine();
        bar.setSelection(100);
        this.taxme.open();
    }

    public FileHistory getFileHistory() {
        return this.fileHistory;
    }

    public void close() {
        this.getShell().close();
    }

    public Shell getShell() {
        if (this.taxme == null) {
            return null;
        }
        return this.taxme.getShell();
    }

    private void readFileHistory() {
        for (int i = this.fileHistory.maxSize(); i >= 0; --i) {
            String path = TaxmeConfig.getString("file." + i + ".path");
            if (path == null) continue;
            this.fileHistory.addEntry(new File(path));
        }
    }

    private void saveFileHistory() {
        int i = 0;
        Iterator it = this.fileHistory.entries();
        while (it.hasNext()) {
            File file = (File)it.next();
            TaxmeConfig.setValue("file." + i + ".path", file.getAbsolutePath());
            ++i;
        }
    }

    public LocalizationHelper getLocalisationHelper() {
        return this.localisationHelper;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int newMode) {
        if (newMode != this.mode) {
            this.mode = newMode;
            if (this.mode == 2) {
                this.wizardLinkDmk = null;
            }
            this.taxme.rebuild();
            this.update();
        }
    }

    public boolean isDeclarationOpen() {
        return this.declarationOpen;
    }

    private void initMainHelp() {
        if (TaxmeConfig.getMainhelpDir() != null) {
            File model = new File(TaxmeConfig.getMainhelpDir() + "help.xml");
            if (!model.exists()) {
                logger.error((Object)("MainHelp not found: " + model.getAbsolutePath()));
                return;
            }
            HelpParser.parse(model);
        }
    }

    public boolean isInWizardLink() {
        return this.wizardLinkDmk != null;
    }

    public String getWizardLinkDmk() {
        return this.wizardLinkDmk;
    }

    public boolean isExpertModeEnabled() {
        if (!TaxmeConfig.isWizardModeEnabled()) {
            return true;
        }
        if (!TaxmeConfig.isExpertModeEnabled()) {
            return false;
        }
        TmoSessionImpl tmoSession = this.getTmoSession();
        if (tmoSession == null) {
            return false;
        }
        ModelItemDTO mi = tmoSession.getModelItem("Stammdaten.ExpertModeEnabled");
        if (mi == null || mi.getValue() == null || !(mi.getValue() instanceof Boolean)) {
            return false;
        }
        return (Boolean)mi.getValue();
    }

    public void reloadModel() {
        try {
            System.setProperty("model.xml.gen", "true");
            File lastFile = null;
            String key = null;
            if (this.isDeclarationOpen()) {
                lastFile = this.closeFile();
                if (this.isDeclarationOpen()) {
                    return;
                }
                key = this.mode == 2 ? this.formAccessKey : this.dataModelKey;
            }
            this.tmoSession = new TmoSessionImpl(TaxmeConfig.getString("path.model.xml"), TaxmeConfig.getDataResource());
            Messages.reload();
            if (lastFile != null) {
                this.openFile(lastFile);
                if (key != null) {
                    final String key2 = key;
                    this.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (TaxmeController.this.mode == 2) {
                                TaxmeController.this.setFormAccessKey(key2);
                            } else {
                                TaxmeController.this.setDataModelKey(key2);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            DialogUtil.showErrorDialog(Messages.getString("error.model.reload"));
            e.printStackTrace();
        }
    }

    static {
        logger = Logger.getLogger((Class)TaxmeController.class);
    }

    private class CloseListener
    implements Listener {
        private CloseListener() {
        }

        public void handleEvent(Event ev) {
            if (!TaxmeController.this.askForSave()) {
                ev.doit = false;
                return;
            }
            TaxmeController.this.taxme.saveConfiguration();
            TaxmeController.this.getShell().dispose();
            TaxmeController.this.saveFileHistory();
            TaxmeConfig.setValue("view.mode", TaxmeController.this.mode);
            File currentFile = TaxmeController.this.tmoSession.getFile();
            if (currentFile != null) {
                TaxmeConfig.setValue("lastfile.path", currentFile.getAbsolutePath());
            } else {
                TaxmeConfig.remove("lastfile.path");
            }
            TaxmeConfig.store();
            TaxmeController.this.tmoSession.removeUndoRedoStateListener(TaxmeController.this.taxme);
        }
    }

    private class LocalisationHelperImpl
    implements LocalizationHelper {
        private LocalisationHelperImpl() {
        }

        public Locale getCurrentLocale() {
            return TaxmeController.this.getLocale();
        }

        public String translate(String key, Object[] replacementArguments) {
            try {
                String str = Messages.getString(key);
                if (replacementArguments != null && replacementArguments.length > 0 && str.indexOf(123) >= 0 && str.indexOf(125) != -1) {
                    MessageFormat temp = new MessageFormat(str, this.getCurrentLocale());
                    return temp.format(replacementArguments);
                }
                return str;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "translation error: " + key;
            }
        }
    }
}

