/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.presentation.bd.cd.UndoRedoSnapshot;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.DocumentAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.EditRedoAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.EditUndoAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileChangePasswordAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileCloseAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileDossierAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileExitAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileHistoryOpenAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileImportAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileNewAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileOpenAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileSaveAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileSaveAsAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FontSizeContributionItem;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpAboutAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpShorthelpAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilProxySettingsAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilReloadModelAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilSelectLanguageAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilSetAcroreadPathAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilSetFontSizeAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilUpdateAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilWindowResizeAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.ViewSelectModeAction;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertContentPart;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertNavigationPart;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertTabPart;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import ch.dvbern.tax.common.presentation.cd.help.util.ShortHelpMapping;
import ch.dvbern.tax.common.presentation.cd.parts.HelpPart;
import ch.dvbern.tax.common.presentation.cd.parts.TabPart;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolEditOnMainHelpAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolEditOnShortHelpAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHelpMappingAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHtmlEditorSetAction;
import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.FileHistory;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardContentPart;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardNavigationPart;
import ch.dvbern.tax.common.presentation.cd.wizard.WizardTabPart;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Taxme
extends ApplicationWindow
implements IToolCommunicationGui,
UndoRedoSnapshot.UndoRedoStateListener {
    private static final Logger log = Logger.getLogger((Class)Taxme.class);
    private boolean showShorthelp = true;
    private int mode;
    private boolean modeSelectionEnabled = false;
    private SashForm sashForm1 = null;
    private SashForm sashForm2 = null;
    private Composite partNavigation = null;
    private Composite partContent = null;
    private TabPart partTab = null;
    private Browser welcome;
    private CoolBarManager coolBarManager;
    private FileNewAction fileNewAction = new FileNewAction();
    private FileOpenAction fileOpenAction = new FileOpenAction();
    private FileImportAction fileImportAction = new FileImportAction();
    private FileCloseAction fileCloseAction = new FileCloseAction();
    private FileSaveAction fileSaveAction = new FileSaveAction();
    private FileSaveAsAction fileSaveAsAction = new FileSaveAsAction();
    private Action filePrintAction = ActionRegistry.getInstance().getAction("print");
    private FileChangePasswordAction fileChangePasswordAction = new FileChangePasswordAction();
    private FileDossierAction fileDossierAction = new FileDossierAction();
    private EditUndoAction editUndoAction = new EditUndoAction();
    private EditRedoAction editRedoAction = new EditRedoAction();
    private ViewSelectModeAction viewExpertModeAction = new ViewSelectModeAction("menu.view.mode.expert", "icon.menu.view.mode.expert", 2);
    private ViewSelectModeAction viewWizardModeAction = new ViewSelectModeAction("menu.view.mode.wizard", "icon.menu.view.mode.wizard", 1);
    private UtilWindowResizeAction utilWindowResizeAction = new UtilWindowResizeAction();
    private UtilUpdateAction utilUpdateAction = new UtilUpdateAction("menu.util.update", 0);
    private UtilUpdateAction utilValorAction = new UtilUpdateAction("menu.util.valor", 0);
    private UtilSetAcroreadPathAction utilSetAcroreadPathAction = new UtilSetAcroreadPathAction();
    private UtilSetFontSizeAction largeFontsAction = new UtilSetFontSizeAction("menu.util.fontsize.large", true);
    private UtilSetFontSizeAction smallFontsAction = new UtilSetFontSizeAction("menu.util.fontsize.small", false);
    private UtilProxySettingsAction utilProxySettingsAction = new UtilProxySettingsAction();
    private HelpShorthelpAction helpShorthelpAction = new HelpShorthelpAction();
    private HelpMainhelpAction helpMainhelpAction = TaxmeConfig.getMainhelpDir() != null ? new HelpMainhelpAction() : null;
    private HelpAboutAction helpAboutAction = new HelpAboutAction();
    private UtilReloadModelAction reloadModelAction = Boolean.getBoolean("model.reload.enabled") ? new UtilReloadModelAction() : null;
    private ToolHelpMappingAction toolHelpMappingAction = null;
    private ToolEditOnMainHelpAction toolEditOnMainHelpAction = null;
    private ToolEditOnShortHelpAction toolEditOnShortHelpAction = null;
    private ToolHtmlEditorSetAction toolHtmlEditorSetAction = null;
    private MenuManager menuFile = new MenuManager(Messages.getString("menu.file"), "menu.file");
    private MenuManager menuEdit = new MenuManager(Messages.getString("menu.edit"), "menu.edit");
    private MenuManager menuView = new MenuManager(Messages.getString("menu.view"), "menu.view");
    private MenuManager menuViewMode = new MenuManager(Messages.getString("menu.view.mode"), "menu.view.mode");
    private MenuManager menuUtil = new MenuManager(Messages.getString("menu.util"), "menu.util");
    private MenuManager menuLanguage = new MenuManager(Messages.getString("menu.util.language"), "menu.util.language");
    private MenuManager menuFontSize = new MenuManager(Messages.getString("menu.util.fontsize"), "menu.util.fontsize");
    private MenuManager menuHelp = new MenuManager(Messages.getString("menu.help"), "menu.help");
    private MenuManager menuTools = null;
    private MenuManager menuDocuments = new MenuManager(Messages.getString("label.menu.documents"), "label.menu.documents");
    private MenuManager menuLaws = new MenuManager(Messages.getString("label.menu.law"), "label.menu.law");
    private List fileHistoryItems = new LinkedList();
    private Separator fileExitSepartor = new Separator();
    private ActionContributionItem fileExitItem = new ActionContributionItem((IAction)new FileExitAction());
    private List languageActions = new ArrayList();

    public Taxme() {
        super(null);
        this.mode = TaxmeController.getInstance().getMode();
        this.modeSelectionEnabled = TaxmeConfig.isExpertModeEnabled() && TaxmeConfig.isWizardModeEnabled();
        this.addMenuBar();
        this.addCoolBar(0);
        this.addStatusLine();
        if (!OsSupport.isMacOs()) {
            Taxme.setDefaultImage((Image)GuiUtil.getImageRegistry().get("icon.window.app"));
        }
    }

    protected void initializeBounds() {
        Rectangle bounds = this.getWindowBounds();
        if (bounds == null) {
            this.getShell().setMaximized(true);
        } else {
            this.getShell().setBounds(bounds);
        }
    }

    public Composite getNavigationPart() {
        return this.partNavigation;
    }

    public Composite getContentPart() {
        return this.partContent;
    }

    public TabPart getTabPart() {
        return this.partTab;
    }

    public int open() {
        this.getMenuBarManager().updateAll(true);
        this.getShell().forceFocus();
        return super.open();
    }

    public void setMenuState() {
        this.viewExpertModeAction.updateChecked();
        this.viewWizardModeAction.updateChecked();
        this.smallFontsAction.updateChecked();
        this.largeFontsAction.updateChecked();
        Iterator it = this.languageActions.iterator();
        while (it.hasNext()) {
            UtilSelectLanguageAction action = (UtilSelectLanguageAction)((Object)it.next());
            action.updateChecked();
        }
        boolean hasContent = TaxmeController.getInstance().isDeclarationOpen();
        this.fileCloseAction.setEnabled(hasContent);
        this.filePrintAction.setEnabled(hasContent);
        this.fileSaveAction.setEnabled(hasContent);
        this.fileSaveAsAction.setEnabled(hasContent);
        this.fileChangePasswordAction.setEnabled(hasContent);
        this.setModeActionsState();
        this.editRedoAction.setEnabled(hasContent);
        this.editUndoAction.setEnabled(hasContent);
        this.helpShorthelpAction.setEnabled(hasContent);
        if (this.fileDossierAction != null) {
            this.fileDossierAction.setEnabled(hasContent);
        }
    }

    public void setModeActionsState() {
        boolean hasContent = TaxmeController.getInstance().isDeclarationOpen();
        boolean inWizardLink = TaxmeController.getInstance().isInWizardLink();
        boolean expertEnabled = TaxmeController.getInstance().isExpertModeEnabled();
        this.viewExpertModeAction.setEnabled(hasContent && !inWizardLink && expertEnabled);
        this.viewWizardModeAction.setEnabled(hasContent && !inWizardLink);
    }

    protected Control createContents(Composite parent) {
        if (this.sashForm1 != null) {
            this.sashForm1.dispose();
            this.sashForm1 = null;
        }
        this.partContent = null;
        this.partNavigation = null;
        this.partTab = null;
        this.sashForm2 = null;
        this.welcome = null;
        this.sashForm1 = new SashForm(parent, 256);
        this.sashForm1.setLayout((Layout)new FillLayout());
        if (TaxmeController.getInstance().isDeclarationOpen()) {
            this.createDataContent();
        } else {
            this.createWelcomeContent();
        }
        return parent;
    }

    private void createWelcomeContent() {
        try {
            this.welcome = BrowserUtil.createBrowser((Composite)this.sashForm1);
            this.welcome.setUrl(TaxmeConfig.getWelcomeFilePath());
        }
        catch (BrowserNotSupportedException e) {
            e.printStackTrace();
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    String msg = OsSupport.isLinuxOs() ? Messages.getString("error.browser.linux") : (OsSupport.isMacOs() ? Messages.getString("error.browser.mac") : Messages.getString("error.browser.general"));
                    DialogUtil.showWarningDialog(msg);
                }
            });
        }
    }

    private void createDataContent() {
        this.partNavigation = this.expertMode() ? new ExpertNavigationPart((Composite)this.sashForm1) : new WizardNavigationPart((Composite)this.sashForm1);
        this.sashForm2 = new SashForm((Composite)this.sashForm1, 768);
        this.sashForm2.setLayout((Layout)new FillLayout());
        if (this.expertMode()) {
            this.partContent = new ExpertContentPart((Composite)this.sashForm2);
            this.partTab = new ExpertTabPart((Composite)this.sashForm2);
        } else {
            this.partContent = new WizardContentPart((Composite)this.sashForm2);
            this.partTab = new WizardTabPart((Composite)this.sashForm2);
        }
        this.sashForm1.setWeights(this.getSashWeights1());
        this.sashForm2.setWeights(this.getSashWeights2());
        this.showShortHelp(this.getShorthelpEnabled());
    }

    public void showShortHelp(boolean show) {
        if (this.sashForm2 == null) {
            return;
        }
        if (show) {
            this.sashForm2.setMaximizedControl(null);
        } else {
            this.sashForm2.setMaximizedControl((Control)this.partContent);
        }
        this.showShorthelp = show;
        this.helpShorthelpAction.setChecked(show);
    }

    protected MenuManager createMenuManager() {
        DocumentAction documentAction;
        int langCnt;
        boolean updateEnabled;
        this.setMenuState();
        MenuManager menuBar = new MenuManager();
        menuBar.add((IContributionItem)this.menuFile);
        this.menuFile.add((IAction)this.fileNewAction);
        this.menuFile.add((IAction)this.fileOpenAction);
        if (TaxmeConfig.getBoolean("window.show.import.menu")) {
            this.menuFile.add((IAction)this.fileImportAction);
        }
        this.menuFile.add((IAction)this.fileCloseAction);
        this.menuFile.add((IContributionItem)new Separator());
        this.menuFile.add((IAction)this.fileSaveAction);
        this.menuFile.add((IAction)this.fileSaveAsAction);
        this.menuFile.add((IContributionItem)new Separator());
        if (TaxmeConfig.getBoolean("window.show.print")) {
            this.menuFile.add((IAction)this.filePrintAction);
        }
        this.menuFile.add((IContributionItem)new Separator());
        this.menuFile.add((IContributionItem)new Separator());
        if (TaxmeConfig.getBoolean("window.show.dossier.menu")) {
            this.menuFile.add((IAction)this.fileDossierAction);
            this.menuFile.add((IContributionItem)new Separator());
        }
        this.menuFile.add((IContributionItem)this.fileExitSepartor);
        this.menuFile.add((IContributionItem)this.fileExitItem);
        menuBar.add((IContributionItem)this.menuEdit);
        this.menuEdit.add((IAction)this.editUndoAction);
        this.menuEdit.add((IAction)this.editRedoAction);
        if (this.modeSelectionEnabled) {
            menuBar.add((IContributionItem)this.menuView);
            this.menuView.add((IContributionItem)this.menuViewMode);
            this.menuViewMode.add((IAction)this.viewWizardModeAction);
            this.menuViewMode.add((IAction)this.viewExpertModeAction);
        }
        this.menuUtil.add((IAction)this.utilWindowResizeAction);
        boolean bl = updateEnabled = TaxmeConfig.getString("update.server") != null;
        if (updateEnabled) {
            this.menuUtil.add((IAction)this.utilUpdateAction);
            if (TaxmeConfig.getBoolean("window.show.update.valor.menu")) {
                this.menuUtil.add((IAction)this.utilValorAction);
            }
        }
        if (OsSupport.isLinuxOs() && !TaxmeConfig.getBoolean("window.show.fontsize.menu")) {
            this.menuUtil.add((IContributionItem)new Separator());
            this.menuUtil.add((IAction)this.utilSetAcroreadPathAction);
            this.menuFontSize.add((IAction)this.smallFontsAction);
            this.menuFontSize.add((IAction)this.largeFontsAction);
            this.menuUtil.add((IContributionItem)this.menuFontSize);
            this.menuUtil.add((IContributionItem)new Separator());
        }
        if (ActionRegistry.getInstance().getAction("treuhand") != null) {
            this.menuUtil.add((IAction)ActionRegistry.getInstance().getAction("treuhand"));
        }
        if ((langCnt = TaxmeConfig.getInt("language.count")) > 1) {
            this.menuUtil.add((IContributionItem)this.menuLanguage);
            for (int i = 0; i < langCnt; ++i) {
                Locale lang = new Locale(TaxmeConfig.getString("language." + i));
                String key = "menu.util.language." + lang.getLanguage().toLowerCase();
                UtilSelectLanguageAction selAction = new UtilSelectLanguageAction(key, lang);
                this.languageActions.add(selAction);
                this.menuLanguage.add((IAction)selAction);
            }
        }
        if (updateEnabled) {
            this.menuUtil.add((IAction)this.utilProxySettingsAction);
        }
        if (this.menuUtil.getItems() != null && this.menuUtil.getItems().length > 0) {
            menuBar.add((IContributionItem)this.menuUtil);
        }
        Iterator iter = ActionRegistry.getInstance().getLawActions().iterator();
        while (iter.hasNext()) {
            documentAction = (DocumentAction)((Object)iter.next());
            this.menuLaws.add((IAction)documentAction);
        }
        if (this.menuLaws.getItems() != null && this.menuLaws.getItems().length > 0) {
            menuBar.add((IContributionItem)this.menuLaws);
        }
        iter = ActionRegistry.getInstance().getDocumentActions().iterator();
        while (iter.hasNext()) {
            documentAction = (DocumentAction)((Object)iter.next());
            this.menuDocuments.add((IAction)documentAction);
        }
        if (this.menuDocuments.getItems() != null && this.menuDocuments.getItems().length > 0) {
            menuBar.add((IContributionItem)this.menuDocuments);
        }
        menuBar.add((IContributionItem)this.menuHelp);
        this.helpShorthelpAction.setChecked(true);
        this.menuHelp.add((IAction)this.helpShorthelpAction);
        if (this.helpMainhelpAction != null) {
            this.menuHelp.add((IContributionItem)new Separator());
            this.menuHelp.add((IAction)this.helpMainhelpAction);
        }
        this.menuHelp.add((IContributionItem)new Separator());
        this.menuHelp.add((IAction)this.helpAboutAction);
        String sToolsEnabled = TaxmeConfig.getString("ToolsEnabled");
        if (sToolsEnabled != null && sToolsEnabled.equals("true")) {
            this.menuTools = new MenuManager(Messages.getString("menu.tools"), "menu.tools");
            menuBar.add((IContributionItem)this.menuTools);
            this.toolHelpMappingAction = new ToolHelpMappingAction(this);
            this.menuTools.add((IAction)this.toolHelpMappingAction);
            this.toolEditOnMainHelpAction = new ToolEditOnMainHelpAction(this);
            this.menuTools.add((IAction)this.toolEditOnMainHelpAction);
            this.toolEditOnShortHelpAction = new ToolEditOnShortHelpAction(this);
            this.menuTools.add((IAction)this.toolEditOnShortHelpAction);
            this.toolHtmlEditorSetAction = new ToolHtmlEditorSetAction(this);
            this.menuTools.add((IAction)this.toolHtmlEditorSetAction);
        }
        return menuBar;
    }

    public void setFileHistory(FileHistory history) {
        this.refreshFileHistory(history);
        history.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                Taxme.this.refreshFileHistory((FileHistory)o);
            }
        });
    }

    public void rebuild() {
        this.saveConfiguration();
        this.mode = TaxmeController.getInstance().getMode();
        if (this.sashForm1 != null) {
            Composite parent = this.sashForm1.getParent();
            this.sashForm1.dispose();
            this.sashForm1 = null;
            this.createContents(parent);
            parent.layout();
            this.initializeBounds();
        }
        this.setMenuState();
    }

    private void refreshFileHistory(FileHistory history) {
        Iterator it = this.fileHistoryItems.iterator();
        while (it.hasNext()) {
            this.menuFile.remove((IContributionItem)((ActionContributionItem)it.next()));
        }
        this.menuFile.remove((IContributionItem)this.fileExitSepartor);
        this.menuFile.remove((IContributionItem)this.fileExitItem);
        this.fileHistoryItems.clear();
        it = history.entries();
        while (it.hasNext()) {
            File file = (File)it.next();
            FileHistoryOpenAction action = new FileHistoryOpenAction(file);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            this.menuFile.add((IContributionItem)item);
            this.fileHistoryItems.add(item);
        }
        this.menuFile.add((IContributionItem)this.fileExitSepartor);
        this.menuFile.add((IContributionItem)this.fileExitItem);
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager slm = new StatusLineManager();
        return slm;
    }

    protected CoolBarManager createCoolBarManager(int style) {
        this.coolBarManager = new CoolBarManager(style);
        this.fillCoolBarManager(this.coolBarManager);
        return this.coolBarManager;
    }

    private void fillCoolBarManager(CoolBarManager manager) {
        ToolBarManager tbm1 = new ToolBarManager(0x800040);
        tbm1.add((IAction)this.fileNewAction);
        tbm1.add((IAction)this.fileOpenAction);
        if (TaxmeConfig.getBoolean("window.show.import")) {
            tbm1.add((IAction)this.fileImportAction);
        }
        tbm1.add((IAction)this.fileSaveAction);
        tbm1.add((IAction)this.fileCloseAction);
        tbm1.add((IContributionItem)new Separator());
        if (TaxmeConfig.getBoolean("window.show.print")) {
            tbm1.add((IAction)this.filePrintAction);
        }
        tbm1.add((IContributionItem)new Separator());
        tbm1.add((IAction)this.editUndoAction);
        tbm1.add((IAction)this.editRedoAction);
        if (this.modeSelectionEnabled) {
            tbm1.add((IContributionItem)new Separator());
            tbm1.add((IAction)this.viewWizardModeAction);
            tbm1.add((IAction)this.viewExpertModeAction);
        }
        tbm1.add((IContributionItem)new Separator());
        if (TaxmeConfig.getBoolean("window.show.dossier")) {
            tbm1.add((IAction)this.fileDossierAction);
            tbm1.add((IContributionItem)new Separator());
        }
        tbm1.add((IAction)this.helpShorthelpAction);
        if (this.reloadModelAction != null) {
            tbm1.add((IAction)this.reloadModelAction);
        }
        if (TaxmeConfig.getBoolean("window.show.fontsize.menu")) {
            tbm1.add((IContributionItem)new Separator());
            tbm1.add((IContributionItem)new FontSizeContributionItem());
        }
        if (ActionRegistry.getInstance().getAction("link.www") != null) {
            tbm1.add((IAction)ActionRegistry.getInstance().getAction("link.www"));
        }
        manager.add((IToolBarManager)tbm1);
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }

    public void saveConfiguration() {
        int[] sashWeights2;
        int i;
        int[] sashWeights1;
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            if (this.getShell().getMaximized()) {
                this.saveWindowBounds(null);
            } else {
                this.saveWindowBounds(this.getShell().getBounds());
            }
        }
        if (this.sashForm1 != null && !this.sashForm1.isDisposed() && (sashWeights1 = this.sashForm1.getWeights()).length == 2) {
            for (i = 0; i < sashWeights1.length; ++i) {
                TaxmeConfig.setValue("window.sashweights1." + this.mode + "." + i, sashWeights1[i]);
            }
        }
        if (this.sashForm2 != null && !this.sashForm2.isDisposed() && (sashWeights2 = this.sashForm2.getWeights()).length == 2) {
            for (i = 0; i < sashWeights2.length; ++i) {
                TaxmeConfig.setValue("window.sashweights2." + this.mode + "." + i, sashWeights2[i]);
            }
        }
        TaxmeConfig.setValue("shorthelp.show." + this.mode, Boolean.toString(this.showShorthelp));
    }

    private HelpPart getHelpPart() {
        if (this.getTabPart() instanceof WizardTabPart) {
            return ((WizardTabPart)this.getTabPart()).getHelpPart();
        }
        return null;
    }

    public Map toolGetAllNlsErrorMessages() {
        return null;
    }

    public List toolGetAvailableLanguages() {
        return null;
    }

    public String toolGetCurrentFullHTMLFileName() {
        HelpPart hp = this.getHelpPart();
        if (hp != null) {
            return hp.getHtmlUrl();
        }
        return null;
    }

    public String toolGetCurrentLanguage() {
        return TaxmeController.getInstance().getLanguage();
    }

    public String toolGetCurrentMainHelpDirectory() {
        return TaxmeConfig.getMainhelpDir();
    }

    public String toolGetCurrentMainHelpFileName() {
        WizardDisplayInfoDTO wizardDisplayInfoDTO = TaxmeController.getInstance().getWizardDisplayInfoDTO();
        List children = wizardDisplayInfoDTO.getFormItemDTO().getChildren();
        Iterator it = children.iterator();
        boolean hasSection = false;
        while (it.hasNext()) {
            String value;
            Object obj = it.next();
            if (!(obj instanceof WizardDisplayInfoDTO.SectionItemDTO)) continue;
            hasSection = true;
            WizardDisplayInfoDTO.HelpItemDTO helpItemDTO = ((WizardDisplayInfoDTO.SectionItemDTO)obj).getHelp();
            if (helpItemDTO == null || (value = Messages.getString(helpItemDTO.getId())).substring(1, value.length() - 1).equals(helpItemDTO.getId())) continue;
            return Messages.getString(helpItemDTO.getId());
        }
        if (hasSection) {
            return "";
        }
        String value = Messages.getString("manual." + wizardDisplayInfoDTO.getThisKey());
        if (!value.substring(1, value.length() - 1).equals("manual." + wizardDisplayInfoDTO.getThisKey())) {
            return Messages.getString("manual." + wizardDisplayInfoDTO.getThisKey());
        }
        return "";
    }

    public String toolGetCurrentMainHelpName() {
        WizardDisplayInfoDTO wizardDisplayInfoDTO = TaxmeController.getInstance().getWizardDisplayInfoDTO();
        List children = wizardDisplayInfoDTO.getFormItemDTO().getChildren();
        Iterator it = children.iterator();
        WizardDisplayInfoDTO.HelpItemDTO helpItemDTO = null;
        while (it.hasNext() && helpItemDTO == null) {
            Object obj = it.next();
            if (!(obj instanceof WizardDisplayInfoDTO.SectionItemDTO) || (helpItemDTO = ((WizardDisplayInfoDTO.SectionItemDTO)obj).getHelp()) == null) continue;
            return helpItemDTO.getId();
        }
        return "manual." + wizardDisplayInfoDTO.getThisKey();
    }

    public List toolGetCurrentScreenErrorIds() {
        return null;
    }

    public String toolGetCurrentScreenName() {
        int mode = TaxmeController.getInstance().getMode();
        String key = "";
        if (mode == 1) {
            log.debug((Object)("Selected Navigation DTO = " + TaxmeController.getInstance().getWizardDisplayInfoDTO().getNavigationDTO().getThisKey()));
            key = TaxmeController.getInstance().getWizardDisplayInfoDTO().getFormItemDTO().getName();
        } else if (mode == 2) {
            key = TaxmeController.getInstance().getExpertDisplayInfoDTO().getName();
        }
        return key;
    }

    public String toolGetCurrentShortHelpDirectory() {
        return TaxmeConfig.getShorthelpDir();
    }

    public String toolGetCurrentShortHelpFileName() {
        int mode = TaxmeController.getInstance().getMode();
        String key = "";
        if (mode == 1) {
            WizardDisplayInfoDTO wizardDisplayInfoDTO = TaxmeController.getInstance().getWizardDisplayInfoDTO();
            key = wizardDisplayInfoDTO.getFormItemDTO().getName();
        } else if (mode == 2) {
            ExpertDisplayInfoDTO expertDisplayInfoDTO = TaxmeController.getInstance().getExpertDisplayInfoDTO();
            key = expertDisplayInfoDTO.getName();
        }
        String value = ShortHelpMapping.getString(key);
        if (value != null) {
            return value;
        }
        return "";
    }

    public String toolGetCurrentShortHelpFileNameOnField(String sKey) {
        String value = ShortHelpMapping.getString(sKey);
        if (value != null) {
            return value;
        }
        return "";
    }

    public String toolGetFullHtmlEditorName() {
        return TaxmeConfig.getString("ToolHtmlEditorName");
    }

    public List toolGetGuiModelAsVector(String sFileName) {
        return null;
    }

    public Hashtable toolGetGuiModelConfigEntries() {
        return null;
    }

    public HelpRoot toolGetMainHelpIndexModel() {
        return null;
    }

    public HelpRoot toolGetMainHelpModel() {
        return null;
    }

    public List toolGetNavigationFromFile() {
        return null;
    }

    public Hashtable toolGetNavigationNls() {
        return null;
    }

    public boolean toolIsErrorsWarningsEnabled() {
        return false;
    }

    public boolean toolIsGuiModelsEnabled() {
        return false;
    }

    public boolean toolIsHelpIndexEnabled() {
        return false;
    }

    public boolean toolIsHelpMappingEnabled() {
        String sShortHelpEnabled = TaxmeConfig.getString("ToolEditHelpMappingEnabled");
        return sShortHelpEnabled != null && sShortHelpEnabled.equals("true");
    }

    public boolean toolIsHelpTreestructureEnabled() {
        return false;
    }

    public boolean toolIsHtmlEditOnMainHelpEnabled() {
        return true;
    }

    public boolean toolIsHtmlEditOnMainPanelHelpEnabled() {
        String sMainPanelHelpEnabled = TaxmeConfig.getString("ToolEditMainPanelHelpEnabled");
        return sMainPanelHelpEnabled != null && sMainPanelHelpEnabled.equals("true");
    }

    public boolean toolIsHtmlEditOnShortHelpEnabled() {
        String sShortHelpEnabled = TaxmeConfig.getString("ToolEditShortHelpEnabled");
        return sShortHelpEnabled != null && sShortHelpEnabled.equals("true");
    }

    public boolean toolIsMainNavigationEnabled() {
        return false;
    }

    public void toolRefreshCurrentHTML() {
        HelpPart hp = this.getHelpPart();
        if (hp != null) {
            hp.refresh();
        }
        this.getShell().forceFocus();
    }

    public void toolRefreshErrorsWarnings() {
    }

    public void toolRefreshGuiModels() {
    }

    public void toolRefreshHelpMappings() {
        TaxmeController.getInstance().update();
    }

    public void toolRefreshNavigation() {
    }

    public void toolRefreshTreeSructures() {
    }

    public void toolSaveAllNlsErrorMessages(Map allNlsErrorMessages) {
    }

    public void toolSaveGuiModelFromVector(List vGuiModel, String sFileName) {
    }

    public void toolSaveHelpMapping(String mainHelp, String shortHelp) {
    }

    public void toolSaveHtmlEditorName(String sFile) {
        TaxmeConfig.setValue("ToolHtmlEditorName", sFile);
        TaxmeConfig.store();
    }

    public void toolSaveMainHelpIndexTree(HelpItem root) {
    }

    public void toolSaveMainHelpTrees(HelpItem root) {
    }

    public void toolSaveNavigationNls(Hashtable navigationNls) {
    }

    public Shell getCallBackShell() {
        return this.getShell();
    }

    private void saveWindowBounds(Rectangle windowBounds) {
        if (windowBounds == null) {
            windowBounds = new Rectangle(0, 0, 0, 0);
        }
        TaxmeConfig.setValue("window.bounds." + this.mode + ".x", windowBounds.x);
        TaxmeConfig.setValue("window.bounds." + this.mode + ".y", windowBounds.y);
        TaxmeConfig.setValue("window.bounds." + this.mode + ".width", windowBounds.width);
        TaxmeConfig.setValue("window.bounds." + this.mode + ".height", windowBounds.height);
    }

    private Rectangle getWindowBounds() {
        if (TaxmeConfig.getInt("window.bounds." + this.mode + ".width") == 0) {
            return null;
        }
        Rectangle rect = new Rectangle(TaxmeConfig.getInt("window.bounds." + this.mode + ".x"), TaxmeConfig.getInt("window.bounds." + this.mode + ".y"), TaxmeConfig.getInt("window.bounds." + this.mode + ".width"), TaxmeConfig.getInt("window.bounds." + this.mode + ".height"));
        if (OsSupport.isMacOs()) {
            rect.y = rect.y < 22 ? 22 : rect.y;
        }
        return rect;
    }

    private int[] getSashWeights1() {
        return new int[]{TaxmeConfig.getInt("window.sashweights1." + this.mode + ".0"), TaxmeConfig.getInt("window.sashweights1." + this.mode + ".1")};
    }

    public void resizeToDefault() {
        TaxmeConfig.remove("window.bounds." + this.mode + ".x");
        TaxmeConfig.remove("window.bounds." + this.mode + ".y");
        TaxmeConfig.remove("window.bounds." + this.mode + ".width");
        TaxmeConfig.remove("window.bounds." + this.mode + ".height");
        TaxmeConfig.remove("window.sashweights1." + this.mode + ".0");
        TaxmeConfig.remove("window.sashweights1." + this.mode + ".1");
        TaxmeConfig.remove("window.sashweights2." + this.mode + ".0");
        TaxmeConfig.remove("window.sashweights2." + this.mode + ".1");
        TaxmeConfig.remove("shorthelp.show." + this.mode);
        this.initializeBounds();
        if (TaxmeController.getInstance().isDeclarationOpen()) {
            this.sashForm2.setWeights(this.getSashWeights2());
            this.sashForm1.setWeights(this.getSashWeights1());
            this.showShortHelp(this.getShorthelpEnabled());
        }
    }

    private int[] getSashWeights2() {
        return new int[]{TaxmeConfig.getInt("window.sashweights2." + this.mode + ".0"), TaxmeConfig.getInt("window.sashweights2." + this.mode + ".1")};
    }

    private boolean getShorthelpEnabled() {
        String shorthelp = TaxmeConfig.getString("shorthelp.show." + this.mode);
        if (shorthelp == null || shorthelp.length() == 0) {
            return true;
        }
        return Boolean.valueOf(shorthelp);
    }

    private boolean expertMode() {
        return this.mode == 2;
    }

    public void undoRedoStateChanged(boolean isUndoable, boolean isRedoable) {
        this.editUndoAction.setEnabled(isUndoable);
        this.editRedoAction.setEnabled(isRedoable);
    }
}

