/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd;

import ch.dvbern.tax.common.presentation.bd.cd.TmoSessionImpl;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfigHelper;
import java.io.File;
import org.apache.log4j.Logger;

public class Autosave
implements Runnable {
    private static final Logger log = Logger.getLogger((Class)Autosave.class);
    private static Thread autosaveThread = null;
    private long autosaveInterval = 0L;
    private String autosaveDir = null;
    private String autosaveUsbDir = null;
    private String autosaveAboluteDir = null;

    public Autosave(long autosaveInterval, String autosaveDir, String autosaveUsbDir, String autosaveAbsoluteDir) {
        this.autosaveInterval = autosaveInterval;
        this.autosaveDir = autosaveDir;
        this.autosaveUsbDir = autosaveUsbDir;
        this.autosaveAboluteDir = autosaveAbsoluteDir;
    }

    public static void startAutosave() {
        Autosave.stopAutosave();
        String sAutosaveInterval = TaxmeConfig.getString("autosave.interval");
        long lAutosaveInterval = 30000L;
        try {
            lAutosaveInterval = Long.valueOf(sAutosaveInterval);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        String sAutosaveDir = TaxmeConfig.getString("autosave.savedir");
        String sAutosaveUsbDir = TaxmeConfig.getString("autosave.usb.savedir");
        String sAutosaveAbsoluteDir = TaxmeConfig.getString("autosave.absolute.savedir");
        if (sAutosaveDir == null && sAutosaveUsbDir == null && sAutosaveAbsoluteDir == null) {
            return;
        }
        autosaveThread = new Thread(new Autosave(lAutosaveInterval, sAutosaveDir, sAutosaveUsbDir, sAutosaveAbsoluteDir));
        autosaveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAutosave() {
        if (autosaveThread != null) {
            Class clazz = Autosave.class;
            synchronized (clazz) {
                autosaveThread.interrupt();
            }
            autosaveThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                Thread.sleep(this.autosaveInterval);
                Class clazz = class$ch$dvbern$tax$common$presentation$cd$Autosave == null ? Autosave.class$("ch.dvbern.tax.common.presentation.cd.Autosave") : class$ch$dvbern$tax$common$presentation$cd$Autosave;
                synchronized (clazz) {
                    this.doAutosave();
                }
            }
        }
        catch (InterruptedException ie) {
            log.debug((Object)"Autosaving has been interrupted");
            return;
        }
    }

    private void doAutosave() {
        try {
            TmoSessionImpl session = TaxmeController.getInstance().getTmoSession();
            String autosavePrefix = TaxFileConfigHelper.getAutosavePrefix(session.getDataModel());
            if (autosavePrefix == null) {
                return;
            }
            log.debug((Object)"Start autosaving");
            File[] autosaveFiles = this.getAutosaveDir().listFiles();
            File autosaveFile = null;
            String autosaveFilename = null;
            long autosaveLastModified = 0L;
            long autosaveLastModifiedCompare = 0L;
            int autosaveFileCounter = 0;
            String newAutosaveFilename = null;
            for (int i = 0; i < autosaveFiles.length; ++i) {
                autosaveFile = autosaveFiles[i];
                autosaveFilename = autosaveFile.getName();
                if (!autosaveFilename.startsWith(autosavePrefix)) continue;
                ++autosaveFileCounter;
                autosaveLastModified = autosaveFile.lastModified();
                if (autosaveLastModifiedCompare != 0L && autosaveLastModified >= autosaveLastModifiedCompare) continue;
                autosaveLastModifiedCompare = autosaveLastModified;
                newAutosaveFilename = autosaveFilename;
            }
            if (++autosaveFileCounter <= 5) {
                newAutosaveFilename = autosavePrefix + "_" + String.valueOf(autosaveFileCounter) + TaxFileConfigHelper.getAutosaveSuffix();
            }
            File newAutosaveFile = new File(this.getAutosaveDir(), newAutosaveFilename);
            session.autosave(newAutosaveFile);
            log.debug((Object)"Autosaving done");
        }
        catch (Exception e) {
            log.error((Object)"Autosave failed", (Throwable)e);
        }
    }

    public File getAutosaveDir() {
        File dir = null;
        dir = this.autosaveUsbDir != null ? new File(this.autosaveUsbDir) : (this.autosaveAboluteDir != null ? new File(this.autosaveAboluteDir) : new File(System.getProperty("user.home"), this.autosaveDir));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

