/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.bd.cd;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.EngineXML;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.integration.TmoIdentification;
import ch.dvbern.tax.common.presentation.bd.TmoSession;
import ch.dvbern.tax.common.presentation.bd.cd.UndoRedoSnapshot;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.common.util.TaxFile;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.TmoSessionStateDTO;
import ch.dvbern.tax.common.transfer.dto.UpdateResultDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class TmoSessionImpl
implements TmoSession {
    private Engine engine;
    private Map dataModel;
    private String currentDMK;
    private UndoRedoSnapshot undoRedoSnapshot = new UndoRedoSnapshot();
    private TaxFile file;
    private String password;
    private boolean changesSaved = true;
    private static Map specificInitValues = new HashMap();

    public TmoSessionImpl(String modelPath, DataResource dataResource) {
        this.initializeEngine(modelPath, dataResource);
    }

    public synchronized void addUndoRedoStateListener(UndoRedoSnapshot.UndoRedoStateListener listener) {
        this.undoRedoSnapshot.addUndoRedoStateListener(listener);
    }

    public synchronized void removeUndoRedoStateListener(UndoRedoSnapshot.UndoRedoStateListener listener) {
        this.undoRedoSnapshot.removeUndoRedoStateListener(listener);
    }

    public synchronized void setFile(File file) {
        this.file = file == null ? null : new TaxFile(file, this.password);
    }

    public synchronized File getFile() {
        return this.file == null ? null : this.file.getFile();
    }

    public synchronized TaxFile getTaxFile() {
        return this.file;
    }

    public synchronized void changePassword(String oldPw, String newPw) throws InvalidAuthenticationException {
        if (!this.password.equals(oldPw)) {
            throw new InvalidAuthenticationException();
        }
        this.setPassword(newPw);
        this.saveModel();
    }

    private synchronized void setPassword(String pw) {
        this.password = pw;
        if (this.file != null) {
            this.file.setPassword(pw);
        }
    }

    public synchronized void save() {
        this.saveModel();
        this.changesSaved = true;
    }

    public synchronized boolean changesSaved() {
        return this.changesSaved;
    }

    public synchronized Map getDataModel() {
        if (this.dataModel != null) {
            return Collections.unmodifiableMap(this.dataModel);
        }
        return null;
    }

    public synchronized ModelItemDTO getModelItem(String dmk) {
        if (this.dataModel == null) {
            return null;
        }
        return (ModelItemDTO)this.dataModel.get(dmk);
    }

    public synchronized void login(String id, String pwd) throws InvalidAuthenticationException {
        this.changesSaved = true;
        this.undoRedoSnapshot.clear();
        this.setPassword(pwd);
        if (this.file == null) {
            this.createDataModel();
        } else {
            this.readModel();
            this.recalculate();
        }
    }

    public synchronized void login(String caseId) throws InvalidAuthenticationException {
        throw new UnsupportedOperationException("login without password is not supported");
    }

    public synchronized void login(int mode, String guid, String address) throws InvalidAuthenticationException {
        throw new UnsupportedOperationException("IAP login is not supported");
    }

    public synchronized WizardDisplayInfoDTO getWizardDisplayInfo(String key) {
        return this.getWizardDisplayInfo(key, true, false);
    }

    public synchronized WizardDisplayInfoDTO getWizardDisplayInfoForPrinting(String key) {
        return this.getWizardDisplayInfo(key, false, false);
    }

    public synchronized WizardDisplayInfoDTO getWizardDisplayInfo(String key, boolean autoUpdate) {
        return this.getWizardDisplayInfo(key, true, autoUpdate);
    }

    private synchronized WizardDisplayInfoDTO getWizardDisplayInfo(String key, boolean updateHistory, boolean autoEnable) {
        if (this.dataModel == null) {
            return null;
        }
        try {
            Engine.WizardDisplayInfoDTOAndChanges wdiDTOac = this.engine.getWizardDisplayInfo(this.dataModel, key, false, false, false, 1, autoEnable);
            if (updateHistory) {
                this.undoRedoSnapshot.update(wdiDTOac.getUndoInformations(), this.currentDMK);
                this.currentDMK = key;
            }
            return wdiDTOac.getWizardDisplayInfoDTO();
        }
        catch (InvalidModelItemKeyException imk) {
            imk.printStackTrace();
            return null;
        }
    }

    public synchronized WizardDisplayInfoDTO getWizardDisplayInfo() {
        return this.getWizardDisplayInfo(null);
    }

    public synchronized ExpertDisplayInfoDTO getExpertDisplayInfo(String key, Locale locale, int mode) {
        if (this.dataModel == null) {
            return null;
        }
        try {
            return this.engine.getExpertDisplayInfo(this.dataModel, key, locale, mode).getExpertDisplayInfoDTO();
        }
        catch (InvalidModelItemKeyException imk) {
            imk.printStackTrace();
            return null;
        }
    }

    public synchronized List getExpertNavigationItems() {
        List result = null;
        try {
            result = this.engine.getExpertNavigationItems(this.dataModel);
        }
        catch (InvalidModelItemKeyException imk) {
            imk.printStackTrace();
        }
        return result;
    }

    public synchronized List getExpertDisplayInfos(List keys, Locale locale, int mode) {
        if (this.dataModel == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ExpertDisplayInfoDTO> result = new ArrayList<ExpertDisplayInfoDTO>(keys.size());
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            ExpertDisplayInfoDTO displayInfo = this.getExpertDisplayInfo(key, locale, mode);
            if (displayInfo == null) continue;
            result.add(displayInfo);
        }
        return result;
    }

    public synchronized void acceptUsageConditions(int importFlag) {
    }

    public synchronized TmoSessionStateDTO getTmoSessionState() {
        return new TmoSessionStateDTO(3);
    }

    public synchronized void reinitializeSession() {
    }

    public synchronized void delete(String dataModelKey) {
        try {
            Map undoInfos = this.engine.delete(this.dataModel, dataModelKey).getUndoInformations();
            this.undoRedoSnapshot.update(undoInfos, this.currentDMK);
            this.changesSaved = false;
        }
        catch (InvalidModelItemKeyException imike) {
            imike.printStackTrace();
        }
    }

    public synchronized WizardDisplayInfoDTO update(Map newValues, boolean errorForced, boolean deleteForced, String key) {
        WizardDisplayInfoDTO result = null;
        try {
            int tmoState = this.getTmoSessionState().getState();
            if (tmoState != 3) {
                throw new ApplicationException("invalid session state: " + tmoState);
            }
            UpdateResultDTO updateResultDTO = this.engine.update(this.dataModel, newValues, errorForced, deleteForced, key, false, false);
            if (updateResultDTO.getUndoInformations().size() > 0) {
                this.changesSaved = false;
            }
            this.undoRedoSnapshot.update(updateResultDTO.getUndoInformations(), this.currentDMK);
            this.currentDMK = key;
            result = updateResultDTO.getWizardDisplayInfoDTO();
        }
        catch (InvalidModelItemKeyException imike) {
            imike.printStackTrace();
        }
        return result;
    }

    public synchronized int touchCompleteModel() {
        int result = 1;
        try {
            int tmoState = this.getTmoSessionState().getState();
            if (tmoState != 3) {
                throw new ApplicationException("invalid session state: " + tmoState);
            }
            UpdateResultDTO urDTO = this.engine.touchCompleteModel(this.dataModel);
            this.undoRedoSnapshot.update(urDTO.getUndoInformations(), this.currentDMK);
            ExpertDisplayInfoDTO ediDTO = urDTO.getExpertDisplayInfoDTO();
            if (ediDTO != null) {
                result = ediDTO.getState();
            }
        }
        catch (InvalidModelItemKeyException imike) {
            imike.printStackTrace();
        }
        return result;
    }

    public synchronized void updateSilent(Map newValues) {
        int tmoState = this.getTmoSessionState().getState();
        if (tmoState != 3) {
            throw new ApplicationException("invalid session state: " + tmoState);
        }
        this.engine.update(this.dataModel, newValues, true);
    }

    public synchronized void update(Map newValues, boolean allowDelete) {
        int tmoState = this.getTmoSessionState().getState();
        if (tmoState != 3) {
            throw new ApplicationException("invalid session state: " + tmoState);
        }
        UpdateResultDTO updateResultDTO = this.engine.update(this.dataModel, newValues, allowDelete);
        if (updateResultDTO.getUndoInformations().size() > 0) {
            this.changesSaved = false;
        }
        this.undoRedoSnapshot.update(updateResultDTO.getUndoInformations(), this.currentDMK);
    }

    public void importData(Map newValues, boolean allowDelete) {
        int tmoState = this.getTmoSessionState().getState();
        if (tmoState != 3) {
            throw new ApplicationException("invalid session state: " + tmoState);
        }
        UpdateResultDTO updateResultDTO = this.engine.importData(this.dataModel, newValues, allowDelete);
        if (updateResultDTO.getUndoInformations().size() > 0) {
            this.changesSaved = false;
        }
        this.undoRedoSnapshot.update(updateResultDTO.getUndoInformations(), this.currentDMK);
    }

    public synchronized String undo() {
        if (!this.undoRedoSnapshot.isUndoable()) {
            return null;
        }
        this.changesSaved = false;
        UndoRedoSnapshot.UndoRedoSnapshotDTO result = this.undoRedoSnapshot.undo(this.dataModel, this.currentDMK);
        if (result != null) {
            this.dataModel = result.getDataModel();
            return result.getDmk();
        }
        return null;
    }

    public synchronized String redo() {
        if (!this.undoRedoSnapshot.isRedoable()) {
            return null;
        }
        this.changesSaved = false;
        UndoRedoSnapshot.UndoRedoSnapshotDTO result = this.undoRedoSnapshot.redo(this.dataModel, this.currentDMK);
        if (result != null) {
            this.dataModel = result.getDataModel();
            return result.getDmk();
        }
        return null;
    }

    public synchronized void createModelSnapshot() {
        this.undoRedoSnapshot.createModelSnapshot(this.dataModel, this.currentDMK);
    }

    public synchronized String backtoModelSnapshot() {
        UndoRedoSnapshot.UndoRedoSnapshotDTO result = this.undoRedoSnapshot.backtoModelSnapshot(this.dataModel, this.currentDMK);
        if (result != null) {
            this.dataModel = result.getDataModel();
            return result.getDmk();
        }
        return null;
    }

    public synchronized WizardDisplayInfoDTO release(String key, Locale userLocale) {
        return null;
    }

    public synchronized void logout() {
        this.setFile(null);
        this.dataModel = null;
        this.password = null;
        this.changesSaved = true;
        this.undoRedoSnapshot.clear();
    }

    public synchronized void completeReset() {
        this.createDataModel();
    }

    public synchronized void completeReset(Map dataModel) {
        this.dataModel = dataModel;
        this.initializeDataModel();
    }

    private synchronized void saveModel() {
        if (this.dataModel == null) {
            throw new IllegalStateException("can't save. dataModel must not be null");
        }
        if (this.file == null) {
            throw new IllegalStateException("can't save. file must not be null");
        }
        this.file.saveModel(this.dataModel);
        this.changesSaved = true;
    }

    public synchronized void autosave(File autosaveFile) {
        if (this.dataModel == null) {
            return;
        }
        if (autosaveFile == null) {
            throw new IllegalStateException("can't save. file must not be null");
        }
        TaxFile taxFile = new TaxFile(autosaveFile, null);
        taxFile.saveModel(this.dataModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readModel() throws InvalidAuthenticationException {
        if (this.file == null) {
            throw new IllegalStateException("can't read. file must not be null");
        }
        boolean readDone = false;
        try {
            this.dataModel = this.file.readModel();
            this.initializeDataModel();
            this.engine.initializeDefaultValues(this.dataModel);
            readDone = true;
        }
        finally {
            if (!readDone) {
                this.dataModel = null;
            }
        }
    }

    private synchronized void initializeEngine(String modelPath, DataResource dataResource) {
        if (Boolean.getBoolean("model.xml.gen")) {
            new EngineXML(".", TaxmeConfig.getString("path.xml.conf"), TaxmeConfig.getString("path.model.xml"));
        }
        BufferedReader br = null;
        StringBuffer xmlStructure = new StringBuffer();
        try {
            GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(new FileInputStream(modelPath)));
            br = new BufferedReader(new InputStreamReader((InputStream)is, "ISO-8859-1"));
            String line = br.readLine();
            while (line != null) {
                xmlStructure.append(line);
                line = br.readLine();
            }
            this.engine = Engine.createEngine(xmlStructure.toString(), dataResource, false);
            this.dataModel = new HashMap();
        }
        catch (IOException e) {
            throw new ApplicationException("can't initialize engine", e);
        }
        catch (ConstructionException e) {
            e.printStackTrace();
            throw new ApplicationException("can't initialize engine", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static synchronized void setSpecificInitValues(Map values) {
        specificInitValues = values;
    }

    private synchronized void initializeDataModel() {
        HashMap changes = new HashMap();
        changes.putAll(specificInitValues);
        this.engine.update(this.dataModel, changes, false);
    }

    private synchronized void createDataModel() {
        this.dataModel = new HashMap();
        this.engine.initializeDefaultValues(this.dataModel);
        this.initializeDataModel();
    }

    public synchronized ExpertDisplayInfoDTO expertUpdate(Map newValues, boolean errorForced, boolean deleteForced, String key, Locale locale, boolean touchItems) {
        try {
            UpdateResultDTO result = this.engine.expertUpdate(this.dataModel, newValues, errorForced, deleteForced, key, locale, touchItems);
            if (result.getUndoInformations().size() > 0) {
                this.changesSaved = false;
            }
            this.undoRedoSnapshot.update(result.getUndoInformations(), this.currentDMK);
            return result.getExpertDisplayInfoDTO();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized Map getOptions(String code, Object arg2) {
        return null;
    }

    public Map getOptionsLocalized(String code, Object arg2) {
        return null;
    }

    public synchronized boolean isImportable(String dataModelKey) {
        return this.engine.isImportable(dataModelKey, false);
    }

    public synchronized TmoIdentification getTmoIdentification() {
        return null;
    }

    public synchronized void recalculate() {
        this.engine.recalculate(this.dataModel);
    }

    public byte[] generateBarcode(Barcode2DGenerator generator) {
        return this.engine.generateBarcode(this.dataModel, generator);
    }

    public String getImageVariant() {
        ModelItemDTO imageVariantDTO;
        if (this.dataModel != null && (imageVariantDTO = (ModelItemDTO)this.dataModel.get("Stammdaten.ImageVariant")) != null) {
            return (String)imageVariantDTO.getValue();
        }
        return null;
    }

    public void exitForm() {
    }
}

