/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.integration.util.failure.IntegrityConstraintException;
import ch.dvbern.tax.common.integration.util.failure.StorageException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SQLCall {
    private PreparedStatement stmt;
    private Connection sqlConnection;
    private ResultSet result;
    private int currentPosition = 1;

    public SQLCall(Connection sqlConnection, String statement) throws StorageException {
        this.sqlConnection = sqlConnection;
        try {
            this.stmt = sqlConnection.prepareStatement(statement);
        }
        catch (SQLException se) {
            try {
                sqlConnection.close();
            }
            catch (SQLException se2) {
                se2.printStackTrace();
            }
            throw new StorageException("could not create statement:" + statement, se);
        }
    }

    public void addString(String value) throws StorageException {
        try {
            if (value != null) {
                this.stmt.setString(this.currentPosition++, value);
            } else {
                this.stmt.setNull(this.currentPosition++, 12);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1), se);
        }
    }

    public void addInt(int value) throws StorageException {
        try {
            this.stmt.setInt(this.currentPosition++, value);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1), se);
        }
    }

    public void addInteger(Integer value) throws StorageException {
        try {
            if (value != null) {
                this.stmt.setInt(this.currentPosition++, value);
            } else {
                this.stmt.setNull(this.currentPosition++, 4);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1), se);
        }
    }

    public void addLong(Long value) throws StorageException {
        try {
            if (value != null) {
                this.stmt.setLong(this.currentPosition++, value);
            } else {
                this.stmt.setNull(this.currentPosition++, -5);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1), se);
        }
    }

    public void addDoubleObject(Double value) throws StorageException {
        try {
            if (value != null) {
                this.stmt.setDouble(this.currentPosition++, value);
            } else {
                this.stmt.setNull(this.currentPosition++, 8);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting string at position " + (this.currentPosition - 1), se);
        }
    }

    public void addNumber(Number value) throws StorageException {
        try {
            if (value != null && value instanceof Integer) {
                this.stmt.setInt(this.currentPosition++, value.intValue());
            } else if (value != null && value instanceof Long) {
                this.stmt.setLong(this.currentPosition++, value.longValue());
            } else if (value != null && value instanceof Float) {
                this.stmt.setFloat(this.currentPosition++, value.floatValue());
            } else if (value != null && value instanceof Double) {
                this.stmt.setDouble(this.currentPosition++, value.doubleValue());
            } else {
                this.stmt.setNull(this.currentPosition++, 8);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting Number at position " + (this.currentPosition - 1), se);
        }
    }

    public void addObject(Object value) throws StorageException {
        try {
            this.stmt.setObject(this.currentPosition++, value);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting object at position " + (this.currentPosition - 1), se);
        }
    }

    public void addDate(java.sql.Date value) throws StorageException {
        try {
            if (value != null) {
                java.sql.Date d = new java.sql.Date(value.getTime());
                this.stmt.setDate(this.currentPosition++, d);
            } else {
                this.stmt.setNull(this.currentPosition++, 91);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting date at position " + (this.currentPosition - 1) + " value=" + value, se);
        }
    }

    public void addTimestamp(Date dateTime) throws StorageException {
        try {
            if (dateTime != null) {
                Timestamp t = new Timestamp(dateTime.getTime());
                this.stmt.setTimestamp(this.currentPosition++, t);
            } else {
                this.stmt.setNull(this.currentPosition++, 93);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting date at position " + (this.currentPosition - 1), se);
        }
    }

    public void addDouble(double value) throws StorageException {
        try {
            this.stmt.setDouble(this.currentPosition++, value);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting double at position " + (this.currentPosition - 1), se);
        }
    }

    public void addBigDecimal(BigDecimal value) throws StorageException {
        try {
            this.stmt.setBigDecimal(this.currentPosition++, value);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting bigdecimal at position " + (this.currentPosition - 1), se);
        }
    }

    public void addBoolean(boolean value) throws StorageException {
        try {
            String s = value ? "1" : "0";
            this.stmt.setString(this.currentPosition++, s);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting boolean at position " + (this.currentPosition - 1), se);
        }
    }

    public void addBooleanObject(Boolean value) throws StorageException {
        if (value == null) {
            try {
                this.stmt.setNull(this.currentPosition++, 12);
            }
            catch (SQLException se) {
                this.cleanup();
                throw new StorageException("exception while setting boolean at position " + (this.currentPosition - 1), se);
            }
        } else {
            this.addBoolean(value);
        }
    }

    public void addBytes(byte[] value) {
        try {
            if (value == null) {
                this.stmt.setNull(this.currentPosition++, 2004);
            } else {
                this.stmt.setBytes(this.currentPosition++, value);
            }
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while setting bindary data at position " + (this.currentPosition - 1), se);
        }
    }

    public int executeDelete() throws StorageException, IntegrityConstraintException {
        try {
            int ret = this.stmt.executeUpdate();
            return ret;
        }
        catch (SQLException se) {
            String sqlState = se.getSQLState();
            if ("23000".equals(sqlState)) {
                throw new IntegrityConstraintException("data can not be removed");
            }
            throw new StorageException("exception while executing update", se);
        }
    }

    public int executeUpdate() throws StorageException {
        try {
            int ret = this.stmt.executeUpdate();
            return ret;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while executing update", se);
        }
    }

    public void executeSelect() throws StorageException {
        try {
            this.result = this.stmt.executeQuery();
            this.currentPosition = 1;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while executing update", se);
        }
    }

    public boolean next() throws StorageException {
        try {
            boolean next = this.result.next();
            if (!next) {
                this.cleanup();
            }
            this.currentPosition = 1;
            return next;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while executing update", se);
        }
    }

    public List getLine() throws StorageException {
        try {
            int cols = this.result.getMetaData().getColumnCount();
            ArrayList<Object> ret = new ArrayList<Object>(cols);
            for (int i = 1; i < cols + 1; ++i) {
                ret.add(this.result.getObject(i));
            }
            return ret;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while retreiving objects", se);
        }
    }

    public String getString() throws StorageException {
        try {
            String s = this.result.getString(this.currentPosition++);
            return s != null ? s.trim() : s;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting string at position " + (this.currentPosition - 1), se);
        }
    }

    public String getString(String name) throws StorageException {
        try {
            String s = this.result.getString(name);
            return s != null ? s.trim() : s;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting string with columnname " + name, se);
        }
    }

    public int getInt() throws StorageException {
        try {
            return this.result.getInt(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int at position " + (this.currentPosition - 1), se);
        }
    }

    public int getInt(String name) throws StorageException {
        try {
            return this.result.getInt(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int with columnname " + name, se);
        }
    }

    public Integer getInteger() throws StorageException {
        try {
            int res = this.result.getInt(this.currentPosition++);
            if (!this.result.wasNull()) {
                return new Integer(res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int at position " + (this.currentPosition - 1), se);
        }
    }

    public Integer getInteger(String name) throws StorageException {
        try {
            int res = this.result.getInt(name);
            if (!this.result.wasNull()) {
                return new Integer(res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int with columnname " + name, se);
        }
    }

    public Long getLong() throws StorageException {
        try {
            long res = this.result.getLong(this.currentPosition++);
            if (!this.result.wasNull()) {
                return new Long(res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int at position " + (this.currentPosition - 1), se);
        }
    }

    public Long getLong(String name) throws StorageException {
        try {
            long res = this.result.getLong(name);
            if (!this.result.wasNull()) {
                return new Long(res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting int with columnname " + name, se);
        }
    }

    public Float getFloatObject() throws StorageException {
        try {
            double res = this.result.getDouble(this.currentPosition++);
            if (!this.result.wasNull()) {
                return new Float(res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting float at position " + (this.currentPosition - 1), se);
        }
    }

    public Float getFloatObject(String name) throws StorageException {
        try {
            double res = this.result.getDouble(name);
            if (!this.result.wasNull()) {
                return new Float(res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting float with columnname " + name, se);
        }
    }

    public Double getDoubleObject() throws StorageException {
        try {
            double res = this.result.getDouble(this.currentPosition++);
            if (!this.result.wasNull()) {
                return new Double(res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting double at position " + (this.currentPosition - 1), se);
        }
    }

    public Double getDoubleObject(String name) throws StorageException {
        try {
            double res = this.result.getDouble(name);
            if (!this.result.wasNull()) {
                return new Double(res);
            }
            return null;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting double with columnname " + name, se);
        }
    }

    public java.sql.Date getDate() throws StorageException {
        try {
            java.sql.Date res = this.result.getDate(this.currentPosition++);
            if (res == null) {
                return null;
            }
            return new java.sql.Date(res.getTime());
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date at position " + (this.currentPosition - 1), se);
        }
    }

    public java.sql.Date getDate(String name) throws StorageException {
        try {
            java.sql.Date res = this.result.getDate(name);
            if (res == null) {
                return null;
            }
            return new java.sql.Date(res.getTime());
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date with columnname " + name, se);
        }
    }

    public Boolean getBooleanObject() throws StorageException {
        try {
            if ("1".equals(this.result.getString(this.currentPosition++))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date at position " + (this.currentPosition - 1), se);
        }
    }

    public Boolean getBooleanObject(String name) throws StorageException {
        try {
            if ("1".equals(this.result.getString(name))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date with columnname " + name, se);
        }
    }

    public Object getObject() throws StorageException {
        try {
            return this.result.getObject(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting object at position " + (this.currentPosition - 1), se);
        }
    }

    public Object getObject(String name) throws StorageException {
        try {
            return this.result.getObject(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting object with columnname " + name, se);
        }
    }

    public Date getTimestamp() throws StorageException {
        try {
            Timestamp res = this.result.getTimestamp(this.currentPosition++);
            if (res == null) {
                return null;
            }
            return new Date(res.getTime());
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date at position " + (this.currentPosition - 1), se);
        }
    }

    public Date getTimestamp(String name) throws StorageException {
        try {
            Timestamp res = this.result.getTimestamp(name);
            if (res == null) {
                return null;
            }
            return new Date(res.getTime());
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting date with columnname " + name, se);
        }
    }

    public float getFloat() throws StorageException {
        try {
            return this.result.getFloat(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting float at position " + (this.currentPosition - 1), se);
        }
    }

    public float getFloat(String name) throws StorageException {
        try {
            return this.result.getFloat(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting float with columnname " + name, se);
        }
    }

    public double getDouble() throws StorageException {
        try {
            return this.result.getDouble(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting double at position " + (this.currentPosition - 1), se);
        }
    }

    public double getDouble(String name) throws StorageException {
        try {
            return this.result.getDouble(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting double with columnname " + name, se);
        }
    }

    public boolean getBoolean() throws StorageException {
        try {
            return "1".equals(this.result.getString(this.currentPosition++));
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting boolean at position " + (this.currentPosition - 1), se);
        }
    }

    public boolean getBoolean(String name) throws StorageException {
        try {
            return "1".equals(this.result.getString(name));
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting boolean with columnname " + name, se);
        }
    }

    public byte[] getBytes() {
        try {
            return this.result.getBytes(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting binary data at position " + (this.currentPosition - 1), se);
        }
    }

    public BigDecimal getBigDecimal() throws StorageException {
        try {
            return this.result.getBigDecimal(this.currentPosition++);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting bigdecimal at position " + (this.currentPosition - 1), se);
        }
    }

    public BigDecimal getBigDecimal(String name) throws StorageException {
        try {
            return this.result.getBigDecimal(name);
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while getting bigdecimal with columnname " + name, se);
        }
    }

    public boolean wasNull() throws StorageException {
        try {
            return this.result.wasNull();
        }
        catch (SQLException se) {
            this.cleanup();
            throw new StorageException("exception while testing on null " + this.currentPosition, se);
        }
    }

    private void cleanup() {
        block8: {
            try {
                if (this.sqlConnection == null || this.sqlConnection.isClosed()) break block8;
                if (this.result != null) {
                    try {
                        this.result.close();
                        this.result = null;
                    }
                    catch (SQLException se) {
                        se.printStackTrace();
                    }
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                        this.stmt = null;
                    }
                    catch (SQLException se) {
                        se.printStackTrace();
                    }
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
                throw new RuntimeException(se);
            }
        }
    }

    public void close() {
        this.cleanup();
    }

    protected void finalize() {
        this.cleanup();
    }
}

