/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class ConfigHelper {
    private static final String PROJECT = "tmo";
    private static Properties props = System.getProperties();
    private static Logger log = Logger.getLogger((Class)ConfigHelper.class);

    private ConfigHelper() {
    }

    public static void setConfiguration(Properties conf) {
        if (conf == null) {
            throw new NullPointerException("conf must not be null");
        }
        props = conf;
    }

    public static String getStringEntry(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        String value = props.getProperty("tmo." + name);
        return value == null ? (String)ConfigHelper.lookupEnvEntry(name) : value;
    }

    public static Integer getIntegerEntry(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        String value = props.getProperty("tmo." + name);
        return value == null ? (Integer)ConfigHelper.lookupEnvEntry(name) : Integer.valueOf(value);
    }

    public static Object lookupEnvEntry(String name) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object obj = ctx.lookup("java:comp/env/" + name);
            if (obj == null) {
                throw new ApplicationException("env-entry not defined in web.xml: " + name);
            }
            Object object = obj;
            return object;
        }
        catch (NamingException e) {
            throw new ApplicationException("error during env-entry lookup: " + name, e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    log.warn((Object)"can't close naming context", (Throwable)e);
                }
            }
        }
    }

    public static Object createImplementation(Class interfaceClass) {
        Class c = ConfigHelper.getImplementation(interfaceClass);
        try {
            Object obj = c.newInstance();
            if (obj == null) {
                throw new ApplicationException("instance was not constructed");
            }
            return obj;
        }
        catch (InstantiationException e) {
            throw new ApplicationException("could not instatinate class: " + c.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationException("could not instatinate class: " + c.getName(), e);
        }
    }

    public static Class getImplementation(Class interfaceClass) {
        if (interfaceClass == null) {
            throw new NullPointerException("interfaceClass must not be null");
        }
        String type = null;
        try {
            type = ConfigHelper.getStringEntry(interfaceClass.getName());
            Class<?> c = Class.forName(type);
            if (!interfaceClass.isAssignableFrom(c)) {
                throw new ApplicationException(c.getName() + " cannot be assigned to " + interfaceClass);
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationException("could not instatinate class: " + type, e);
        }
    }
}

