/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.BooleanConverter;
import ch.dvbern.tax.common.transfer.dto.convert.ComboboxConverter;
import ch.dvbern.tax.common.transfer.dto.convert.CurrencyConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DateConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DayMonthConverter;
import ch.dvbern.tax.common.transfer.dto.convert.FirstLetterConverter;
import ch.dvbern.tax.common.transfer.dto.convert.Float1Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float2Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float3Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float4Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float5Converter;
import ch.dvbern.tax.common.transfer.dto.convert.IntConverter;
import ch.dvbern.tax.common.transfer.dto.convert.IntSimpleConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import ch.dvbern.tax.common.transfer.dto.convert.PrintZeroConverter;
import ch.dvbern.tax.common.transfer.dto.convert.RadioConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;

public class WizardDisplayUtil {
    public static TypeAndConverter parseInputType(Element element, AbstractConverter converter) throws ElementParserException {
        String inputType = element.getAttributeValue("type");
        if (inputType != null) {
            inputType = inputType.toLowerCase();
        }
        TypeAndConverter result = new TypeAndConverter();
        result.alignment = element.getAttributeValue("align");
        if (inputType == null || inputType.length() == 0) {
            int maxlength = 100;
            if (element.getAttribute("maxlength") != null) {
                maxlength = Integer.parseInt(element.getAttributeValue("maxlength"));
            }
            result.type = 0;
            result.converter = converter != null ? converter : new TextConverter(maxlength);
        } else if (inputType.equals("text")) {
            int maxlength = 100;
            if (element.getAttribute("maxlength") != null) {
                maxlength = Integer.parseInt(element.getAttributeValue("maxlength"));
            }
            result.type = 0;
            result.converter = converter != null ? converter : new TextConverter(maxlength);
        } else if (inputType.equals("int")) {
            result.type = 0;
            boolean printZeroIfReadonly = Boolean.valueOf(element.getAttributeValue("printZeroIfReadonly"));
            AbstractConverter abstractConverter = result.converter = converter != null ? converter : new IntConverter(11, printZeroIfReadonly);
            if (result.alignment == null) {
                result.alignment = "right";
            }
        } else if (inputType.equals("float-1")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            AbstractConverter abstractConverter = result.converter = converter != null ? converter : new Float1Converter(14, dynamicFP);
            if (result.alignment == null) {
                result.alignment = "right";
            }
        } else if (inputType.equals("float-2")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            AbstractConverter abstractConverter = result.converter = converter != null ? converter : new Float2Converter(14, dynamicFP);
            if (result.alignment == null) {
                result.alignment = "right";
            }
        } else if (inputType.equals("float-3")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            AbstractConverter abstractConverter = result.converter = converter != null ? converter : new Float3Converter(15, dynamicFP);
            if (result.alignment == null) {
                result.alignment = "right";
            }
        } else if (inputType.equals("float-4")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            AbstractConverter abstractConverter = result.converter = converter != null ? converter : new Float4Converter(16, dynamicFP);
            if (result.alignment == null) {
                result.alignment = "right";
            }
        } else if (inputType.equals("float-5")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            AbstractConverter abstractConverter = result.converter = converter != null ? converter : new Float5Converter(17, dynamicFP);
            if (result.alignment == null) {
                result.alignment = "right";
            }
        } else if (inputType.equals("currency")) {
            result.type = 0;
            AbstractConverter abstractConverter = result.converter = converter != null ? converter : new CurrencyConverter(14);
            if (result.alignment == null) {
                result.alignment = "right";
            }
        } else if (inputType.equals("date")) {
            result.type = 0;
            result.converter = converter != null ? converter : new DateConverter();
        } else if (inputType.equals("boolean")) {
            result.type = 3;
            result.converter = converter != null ? converter : new BooleanConverter();
        } else if (inputType.equals("radio")) {
            result.type = 1;
            result.converter = converter != null ? converter : new RadioConverter();
        } else if (inputType.equals("combobox")) {
            result.type = 2;
            result.converter = converter != null ? converter : new ComboboxConverter(false);
        } else if (inputType.equals("combobox-short")) {
            result.type = 2;
            result.converter = converter != null ? converter : new ComboboxConverter(true);
        } else if (inputType.equals("int-simple")) {
            result.type = 0;
            AbstractConverter abstractConverter = result.converter = converter != null ? converter : new IntSimpleConverter(11);
            if (result.alignment == null) {
                result.alignment = "right";
            }
        } else if (inputType.equals("day-month")) {
            String s = element.getAttributeValue("year");
            try {
                Long year = new Long(s);
                result.type = 0;
                result.converter = converter != null ? converter : new DayMonthConverter(year);
            }
            catch (Throwable t) {
                throw new ElementParserException("missing or invalid year reference for day-month input type in " + element.getName(), t);
            }
        } else if (inputType.equals("first-letter")) {
            result.type = 0;
            String s = element.getAttributeValue("chars");
            int chars = 1;
            if (s != null && s.length() > 0) {
                chars = Integer.parseInt(s);
            }
            result.converter = converter != null ? converter : new FirstLetterConverter(chars);
        } else if (inputType.equals("hidden")) {
            int maxlength = 100;
            if (element.getAttribute("maxlength") != null) {
                maxlength = Integer.parseInt(element.getAttributeValue("maxlength"));
            }
            result.type = 100;
            result.converter = converter != null ? converter : new TextConverter(maxlength);
        } else {
            throw new RuntimeException("invalid inputType: '" + inputType + "'");
        }
        if (result.alignment == null) {
            result.alignment = "left";
        }
        if ("true".equalsIgnoreCase(element.getAttributeValue("printZero"))) {
            PrintZeroConverter printZeroConverter = new PrintZeroConverter((NumberConverter)result.converter, true);
            result.converter = printZeroConverter;
        }
        if ("false".equalsIgnoreCase(element.getAttributeValue("printZero"))) {
            PrintZeroConverter printZeroConverter = new PrintZeroConverter((NumberConverter)result.converter, false);
            result.converter = printZeroConverter;
        }
        return result;
    }

    public static boolean getBoolean(String s, boolean defaultValue) {
        return ExpertDisplayUtil.getBoolean(s, defaultValue);
    }

    public static String getString(String s, String defaultValue) {
        return ExpertDisplayUtil.getString(s, defaultValue);
    }

    public static int getInt(String s, int defaultValue) {
        return ExpertDisplayUtil.getInt(s, defaultValue);
    }

    public static class TypeAndConverter {
        public int type;
        public String alignment;
        public AbstractConverter converter;
    }
}

