/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Col;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowIterator;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Table
extends WizardDisplayModelItem {
    private String name;
    private LogicModelItem.TableItem tableItem;
    private String header;
    private List headerAddOns;
    private List coldefs;
    private List cols;
    private Help help;
    private String stateKey;
    private boolean isSubnavigation;
    private Integer sortCol;
    private Comparator rowComparator;
    private String align;
    private int colspan;
    private int rowspan;
    private String viewId;
    private int rowsPerPage;
    private boolean readonly;
    private boolean editable;
    private boolean addRowEnabled;
    private boolean deleteRowEnabled;
    private boolean filter;
    private String excludeKey;
    private LogicModelItem excludeRef;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$items$Table;

    public Table(String name, String header, List headerAddOns, String stateKey, List coldefs, Help help, List cols, String sort, boolean editable, boolean addRowEnabled, boolean deleteRowEnabled, String excludeKey, String align, int colspan, int rowspan, boolean readonly, String viewId, int rowsPerPage, boolean filter) {
        this.name = name;
        this.help = help;
        this.cols = cols;
        this.header = header;
        this.stateKey = stateKey;
        this.coldefs = coldefs;
        if (sort != null) {
            this.sortCol = new Integer(Integer.parseInt(sort) + 1);
        }
        this.editable = editable;
        this.addRowEnabled = addRowEnabled;
        this.deleteRowEnabled = deleteRowEnabled;
        this.excludeKey = excludeKey;
        this.align = align;
        this.colspan = colspan;
        this.rowspan = rowspan;
        this.readonly = readonly;
        this.viewId = viewId;
        this.headerAddOns = headerAddOns;
        this.rowsPerPage = rowsPerPage;
        this.filter = filter;
        this.initializeParent();
    }

    public List getChildren() {
        ArrayList<Help> result = new ArrayList<Help>();
        if (this.help != null) {
            result.add(this.help);
        }
        if (this.cols != null) {
            result.addAll(this.cols);
        }
        if (this.coldefs != null) {
            result.addAll(this.coldefs);
        }
        if (result.size() == 0) {
            result = null;
        }
        return result;
    }

    public List getColdefs() {
        return this.coldefs;
    }

    public List getCols() {
        return this.cols;
    }

    public String getName() {
        return this.name;
    }

    public String getStateItem() {
        return this.stateKey;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        if (this.stateKey != null && logicModelItems.get(this.stateKey) == null) {
            throw new InvalidModelException("invalid state-reference in table: " + this.header);
        }
        if (this.name == null || !(logicModelItems.get(this.name) instanceof LogicModelItem.TableItem)) {
            throw new InvalidModelException("invalid name-reference in table: " + this.name);
        }
        this.tableItem = (LogicModelItem.TableItem)logicModelItems.get(this.name);
        Iterator iter = ((LogicModelItem)((Object)this.tableItem)).getChildren().iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof LogicModelItem.ModuleItem)) continue;
            this.isSubnavigation = true;
        }
        if (this.tableItem == null) {
            throw new InvalidModelException("invalid table reference (" + this.name + ") in " + this.getClass().getName());
        }
        if (this.sortCol != null && (this.cols == null || this.sortCol >= this.cols.size())) {
            throw new InvalidModelException("invalid sort column index (out of range)");
        }
        this.rowComparator = new RowIterator.RowDTOComparator(this.sortCol);
        if (logicModelItems.get(this.excludeKey) != null) {
            this.excludeRef = (LogicModelItem)logicModelItems.get(this.excludeKey);
        }
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        Object formInfo;
        ArrayList<Object> labelAddOnDTOs = new ArrayList<Object>();
        if (this.headerAddOns != null) {
            Iterator iter = this.headerAddOns.iterator();
            while (iter.hasNext()) {
                LabelAddOn element = (LabelAddOn)iter.next();
                Object formInfo2 = element.getFormInfo(dataModel, key);
                if (formInfo2 == null) continue;
                labelAddOnDTOs.add(formInfo2);
            }
        }
        if (labelAddOnDTOs.size() == 0) {
            labelAddOnDTOs = null;
        }
        ArrayList<Object> coldefDTOs = new ArrayList<Object>();
        Iterator iter = this.coldefs.iterator();
        while (iter.hasNext()) {
            WizardDisplayModelItem element = (WizardDisplayModelItem)iter.next();
            Object formInfo3 = element.getFormInfo(dataModel, key);
            if (formInfo3 == null) continue;
            coldefDTOs.add(formInfo3);
        }
        if (coldefDTOs.size() == 0) {
            coldefDTOs = null;
        }
        String excludeIdx = null;
        if (this.excludeRef != null) {
            ModelItemDTO excludeDTO = dataModel.get(EngineUtil.mergeModelKey(this.excludeRef.getName(), key));
            if (excludeDTO == null || excludeDTO.getValue() == null) {
                return null;
            }
            excludeIdx = excludeDTO.getValue().toString();
        }
        WizardDisplayInfoDTO.RowItemDTO toRemove = null;
        ArrayList<WizardDisplayInfoDTO.RowItemDTO> rowDTOs = new ArrayList<WizardDisplayInfoDTO.RowItemDTO>();
        Iterator iter2 = this.cols.iterator();
        while (iter2.hasNext()) {
            Col col = (Col)iter2.next();
            WizardDisplayInfoDTO.ColItemDTO colDTO = (WizardDisplayInfoDTO.ColItemDTO)col.getFormInfo(dataModel, key);
            for (int i = 0; colDTO != null && colDTO.getItems() != null && i < colDTO.getItems().size(); ++i) {
                WizardDisplayInfoDTO.ItemItemDTO itemDTO = (WizardDisplayInfoDTO.ItemItemDTO)colDTO.getItems().get(i);
                if (rowDTOs.size() <= i) {
                    String tableRowDMK = EngineUtil.removeLastKeyPart(itemDTO.getDataModelKey());
                    while (!EngineUtil.endsWithTableIndex(tableRowDMK)) {
                        tableRowDMK = EngineUtil.removeLastKeyPart(tableRowDMK);
                    }
                    ModelItemDTO miDTO = dataModel.get(tableRowDMK);
                    ArrayList<WizardDisplayInfoDTO.StateItemDTO> children = new ArrayList<WizardDisplayInfoDTO.StateItemDTO>();
                    int state = miDTO == null ? 3 : miDTO.getState();
                    children.add(new WizardDisplayInfoDTO.StateItemDTO(this.getUniqueItemIdentifier() + tableRowDMK + ".row-state", state));
                    WizardDisplayInfoDTO.RowItemDTO row = new WizardDisplayInfoDTO.RowItemDTO(this.getUniqueItemIdentifier() + tableRowDMK, state, tableRowDMK, children, null, this.deleteRowEnabled, null);
                    rowDTOs.add(row);
                    if (excludeIdx != null && EngineUtil.getLastKeyPart(tableRowDMK).equals(excludeIdx)) {
                        toRemove = row;
                    }
                }
                ((WizardDisplayInfoDTO.RowItemDTO)rowDTOs.get(i)).addChild(itemDTO);
            }
        }
        if (toRemove != null) {
            rowDTOs.remove(toRemove);
        }
        Collections.sort(rowDTOs, this.rowComparator);
        if (rowDTOs.size() == 0) {
            rowDTOs = null;
        }
        WizardDisplayInfoDTO.HelpItemDTO helpDTO = null;
        if (this.help != null && (formInfo = this.help.getFormInfo(dataModel, key)) != null) {
            helpDTO = (WizardDisplayInfoDTO.HelpItemDTO)formInfo;
        }
        WizardDisplayInfoDTO.RowItemDTO emptyRow = null;
        if (this.addRowEnabled) {
            emptyRow = this.getEmptyRow(dataModel, key);
        }
        String newName = EngineUtil.mergeModelKey(this.getName(), key);
        int state = dataModel.getTable(newName).getState();
        if (this.stateKey != null) {
            state = dataModel.getWithoutTouch(EngineUtil.mergeModelKey(this.stateKey, key)).getState();
            if (state == 12) {
                return null;
            }
            return new WizardDisplayInfoDTO.TableItemDTO(this.getUniqueItemIdentifier(), state, newName, this.header, labelAddOnDTOs, coldefDTOs, rowDTOs, helpDTO, this.isSubnavigation, this.editable, emptyRow, this.align, this.colspan, this.rowspan, this.readonly, this.viewId, this.rowsPerPage, this.filter);
        }
        return new WizardDisplayInfoDTO.TableItemDTO(this.getUniqueItemIdentifier(), state, newName, this.header, labelAddOnDTOs, coldefDTOs, rowDTOs, helpDTO, this.isSubnavigation, this.editable, emptyRow, this.align, this.colspan, this.rowspan, this.readonly, this.viewId, this.rowsPerPage, this.filter);
    }

    private WizardDisplayInfoDTO.RowItemDTO getEmptyRow(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        int nextKey = EngineUtil.getNextTableItemIndex(dataModel, this.tableItem, key);
        String mergedName = EngineUtil.mergeModelKey(this.getName(), key);
        String newRowDmk = mergedName + "." + nextKey;
        ArrayList<WizardDisplayInfoDTO.AbstractItemDTO> emptyCols = new ArrayList<WizardDisplayInfoDTO.AbstractItemDTO>();
        emptyCols.add(new WizardDisplayInfoDTO.StateItemDTO(this.getUniqueItemIdentifier() + newRowDmk + ".row-state", 3));
        Iterator iter = this.cols.iterator();
        while (iter.hasNext()) {
            Col col = (Col)iter.next();
            String newDmk = EngineUtil.mergeModelKey(col.getDataModelKey(), newRowDmk);
            ModelItemDTO miDTO = new ModelItemDTO(null, 3);
            OptionItemsDTO optionItems = null;
            if (col.getValueModelItem() instanceof LogicModelItem.SelectItem) {
                optionItems = ((LogicModelItem.SelectItem)((Object)col.getValueModelItem())).getOptionItems(dataModel, newDmk);
            }
            emptyCols.add(new WizardDisplayInfoDTO.ItemItemDTO(col.getUniqueItemIdentifier() + newDmk, miDTO.getState(), col.getType(), newDmk, null, 1, optionItems, new ArrayList(), col.isReadonly(), col.getAlign(), col.getStyle(), null, col.isNegative(), col.getRendererAndValidator(), false, col.getValueKey(), null, null));
        }
        return new WizardDisplayInfoDTO.RowItemDTO(this.getUniqueItemIdentifier() + newRowDmk, 3, newRowDmk, emptyCols, null, false, null);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Object> coldefs = new ArrayList<Object>();
            ArrayList<Object> cols = new ArrayList<Object>();
            ArrayList<Object> labelAddOns = new ArrayList<Object>();
            Help help = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Help) {
                        help = (Help)ref;
                        continue;
                    }
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add(ref);
                        continue;
                    }
                    if (ref instanceof ColDef) {
                        coldefs.add(ref);
                        continue;
                    }
                    if (ref instanceof Col) {
                        cols.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            if (labelAddOns.size() == 0 && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.size() == 0) {
                labelAddOns = null;
            }
            for (int i2 = 0; i2 < cols.size(); ++i2) {
                if (coldefs.size() <= i2) continue;
                ((ColDef)coldefs.get(i2)).setAlign(((Col)cols.get(i2)).getAlign());
            }
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            int rowsPerPage = 0;
            if (element.getAttribute("rows-per-page") != null) {
                rowsPerPage = Integer.parseInt(element.getAttribute("rows-per-page"));
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$Table == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$Table = Table.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.Table")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$Table, new Table(element.getAttributeValue("name"), element.getAttributeValue("header"), labelAddOns, element.getAttributeValue("state"), coldefs.size() > 0 ? coldefs : null, help, cols.size() > 0 ? cols : null, element.getAttributeValue("sort"), WizardDisplayUtil.getBoolean(element.getAttributeValue("editable"), false), WizardDisplayUtil.getBoolean(element.getAttributeValue("delete-rows"), true), WizardDisplayUtil.getBoolean(element.getAttributeValue("add-rows"), true), element.getAttributeValue("exclude-ref"), WizardDisplayUtil.getString(element.getAttributeValue("align"), "fill"), WizardDisplayUtil.getInt(element.getAttributeValue("colspan"), 1), WizardDisplayUtil.getInt(element.getAttributeValue("rowspan"), 1), WizardDisplayUtil.getBoolean(element.getAttributeValue("readonly"), false), element.getAttributeValue("viewId"), rowsPerPage, WizardDisplayUtil.getBoolean(element.getAttributeValue("filter"), false)));
        }
    }
}

