/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RowIterator
extends WizardDisplayModelItem {
    private String tableName;
    private LogicModelItem table;
    private List children;
    private Integer sortCol;
    private String emptyLabelKey;
    private Comparator rowComparator;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$wizarddisplay$items$RowIterator;

    public RowIterator(List rows, String tableName, String sort, String emptyLabelKey) {
        this.children = rows;
        this.tableName = tableName;
        if (sort != null) {
            this.sortCol = new Integer(sort);
        }
        this.emptyLabelKey = emptyLabelKey;
    }

    public List getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return null;
        }
        return this.children;
    }

    public void additionalInitializeWizardDisplayModel(Map logicModelItems) throws InvalidModelException {
        if (this.children == null || this.children.size() == 0) {
            throw new InvalidModelException("missing nested Row instances in RowIterator instance");
        }
        Iterator r = this.children.iterator();
        while (r.hasNext()) {
            Object child = r.next();
            if (child instanceof Row || child instanceof RowIterator) continue;
            throw new InvalidModelException("invalid nested element in RowIterator instance (not instance of Row or RowIterator)");
        }
        if (this.sortCol != null && this.children.get(0) instanceof Row && this.sortCol >= ((Row)this.children.get(0)).getCols().size()) {
            throw new InvalidModelException("invalid sort column index (out of range)");
        }
        this.rowComparator = new RowDTOComparator(this.sortCol);
        if (this.tableName == null || this.tableName.length() == 0) {
            throw new InvalidModelException("missing table reference in RowIterator instance");
        }
        Object o = logicModelItems.get(this.tableName);
        if (!(o instanceof LogicModelItem.TableItem)) {
            throw new InvalidModelException("invalid table reference(" + this.tableName + ") in RowIterator instance");
        }
        this.table = (LogicModelItem)o;
        if (this.getChildren() != null) {
            Iterator i = this.getChildren().iterator();
            while (i.hasNext()) {
                WizardDisplayModelItem mi = (WizardDisplayModelItem)i.next();
                mi.setParent(this.getParent());
                if (!(mi instanceof RowIterator)) continue;
                RowIterator it = (RowIterator)mi;
                it.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    public Object getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        ArrayList<Object> result = new ArrayList<Object>();
        String tableKey = EngineUtil.mergeModelKey(this.table.getName(), key);
        ModelItemDTO miDTO = dataModel.get(tableKey);
        if (miDTO == null || miDTO.getValue() == null) {
            return null;
        }
        if (miDTO.getValue() instanceof Set && ((Set)miDTO.getValue()).size() > 0) {
            Iterator i = ((Set)miDTO.getValue()).iterator();
            while (i.hasNext()) {
                String rowKey = tableKey + "." + i.next();
                Iterator r = this.children.iterator();
                while (r.hasNext()) {
                    RowIterator rowIterator;
                    List rows;
                    Object child = r.next();
                    if (child instanceof Row) {
                        Row row = (Row)child;
                        Object formInfo = row.getFormInfo(dataModel, rowKey);
                        if (formInfo == null) continue;
                        result.add(formInfo);
                        continue;
                    }
                    if (!(child instanceof RowIterator) || (rows = (List)(rowIterator = (RowIterator)child).getFormInfo(dataModel, rowKey)) == null) continue;
                    result.addAll(rows);
                }
            }
        } else if (this.emptyLabelKey != null && this.getParent() instanceof Section) {
            Section p = (Section)this.getParent();
            int colspan = p.getColdefs().size();
            ArrayList<WizardDisplayInfoDTO.LabelItemDTO> colDTOs = new ArrayList<WizardDisplayInfoDTO.LabelItemDTO>();
            colDTOs.add(new WizardDisplayInfoDTO.LabelItemDTO(this.getUniqueItemIdentifier(), 1, this.emptyLabelKey, colspan, "left", null, null, null));
            result.add(new WizardDisplayInfoDTO.RowItemDTO(new Long(this.getUniqueItemIdentifier()), 1, null, colDTOs, null, false, null));
        }
        if (this.rowComparator != null) {
            Collections.sort(result, this.rowComparator);
        }
        return result;
    }

    protected void print() {
        System.out.println("RowIterator - table=" + this.tableName);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            ArrayList<Object> children = new ArrayList<Object>();
            List elements = element.getChildren();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Row) {
                        children.add(ref);
                        continue;
                    }
                    if (ref instanceof RowIterator) {
                        children.add(ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$wizarddisplay$items$RowIterator == null ? (class$ch$dvbern$tax$common$engine$wizarddisplay$items$RowIterator = RowIterator.class$("ch.dvbern.tax.common.engine.wizarddisplay.items.RowIterator")) : class$ch$dvbern$tax$common$engine$wizarddisplay$items$RowIterator, new RowIterator(children, element.getAttributeValue("table"), element.getAttributeValue("sort"), element.getAttributeValue("empty")));
        }
    }

    static class RowDTOComparator
    implements Comparator {
        private Integer sortCol = null;

        public RowDTOComparator(Integer sortCol) {
            this.sortCol = sortCol;
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof WizardDisplayInfoDTO.RowItemDTO && arg1 instanceof WizardDisplayInfoDTO.RowItemDTO) {
                int result = 0;
                WizardDisplayInfoDTO.RowItemDTO riDTO_0 = (WizardDisplayInfoDTO.RowItemDTO)arg0;
                WizardDisplayInfoDTO.RowItemDTO riDTO_1 = (WizardDisplayInfoDTO.RowItemDTO)arg1;
                if (this.sortCol != null) {
                    Object o_1;
                    Object o_0 = riDTO_0.getCols().size() > this.sortCol ? riDTO_0.getCols().get(this.sortCol) : null;
                    Object v0 = o_1 = riDTO_0.getCols().size() > this.sortCol ? riDTO_1.getCols().get(this.sortCol) : null;
                    if (o_0 instanceof WizardDisplayInfoDTO.ItemItemDTO && o_1 instanceof WizardDisplayInfoDTO.ItemItemDTO) {
                        Object v_0 = ((WizardDisplayInfoDTO.ItemItemDTO)o_0).getValue();
                        Object v_1 = ((WizardDisplayInfoDTO.ItemItemDTO)o_1).getValue();
                        if (v_0 == null && v_1 == null) {
                            result = 0;
                        } else if (v_0 == null && v_1 != null) {
                            result = -1;
                        } else if (v_0 != null && v_1 == null) {
                            result = 1;
                        } else if (v_0 instanceof String && v_1 instanceof String) {
                            result = ((String)v_0).toUpperCase().compareTo(((String)v_1).toUpperCase());
                        } else if (v_0 instanceof Comparable && v_1 instanceof Comparable) {
                            result = ((Comparable)v_0).compareTo(v_1);
                        }
                    }
                    return result;
                }
                if (EngineUtil.endsWithTableIndex(riDTO_0.getDmkTableEntry()) && EngineUtil.endsWithTableIndex(riDTO_1.getDmkTableEntry())) {
                    Integer index_0 = new Integer(EngineUtil.getLastKeyPart(riDTO_0.getDmkTableEntry()));
                    Integer index_1 = new Integer(EngineUtil.getLastKeyPart(riDTO_1.getDmkTableEntry()));
                    return index_0.compareTo(index_1);
                }
            }
            return 0;
        }
    }
}

